/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.IteratorPlusOne;
import com.ibm.wala.util.collections.IteratorPlusTwo;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.FixedSizeBitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SimpleIntVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCFG<I, T extends IBasicBlock<I>>
implements ControlFlowGraph<I, T>,
Constants {
    private final IMethod method;
    private final DelegatingNumberedNodeManager<T> nodeManager = new DelegatingNumberedNodeManager();
    private final SparseNumberedEdgeManager<T> normalEdgeManager = new SparseNumberedEdgeManager<T>(this.nodeManager, 2, 0);
    private final SparseNumberedEdgeManager<T> exceptionalEdgeManager = new SparseNumberedEdgeManager<T>(this.nodeManager, 0, 0);
    private final SimpleVector<SimpleIntVector> exceptionalSuccessors = new SimpleVector();
    private FixedSizeBitVector normalToExit;
    private FixedSizeBitVector exceptionalToExit;
    private FixedSizeBitVector fallThru;
    private final BitVector catchBlocks;
    private T exit;

    protected AbstractCFG(IMethod iMethod) {
        this.method = iMethod;
        this.catchBlocks = new BitVector(10);
    }

    protected void init() {
        this.normalToExit = new FixedSizeBitVector(this.getMaxNumber() + 1);
        this.exceptionalToExit = new FixedSizeBitVector(this.getMaxNumber() + 1);
        this.fallThru = new FixedSizeBitVector(this.getMaxNumber() + 1);
        this.exit = this.getNode(this.getMaxNumber());
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public T entry() {
        return (T)this.getNode(0);
    }

    @Override
    public T exit() {
        return this.exit;
    }

    @Override
    public int getPredNodeCount(T t) {
        boolean bl;
        if (t == null) {
            throw new IllegalArgumentException("N is null");
        }
        if (t.equals(this.exit())) {
            FixedSizeBitVector fixedSizeBitVector = FixedSizeBitVector.or(this.normalToExit, this.exceptionalToExit);
            return fixedSizeBitVector.populationCount();
        }
        boolean bl2 = this.getNumberOfNormalIn(t) > 0;
        boolean bl3 = bl = this.getNumberOfExceptionalIn(t) > 0;
        if (bl2) {
            if (bl) {
                return Iterator2Collection.toSet(this.getPredNodes(t)).size();
            }
            return this.getNumberOfNormalIn(t);
        }
        return this.getNumberOfExceptionalIn(t);
    }

    public int getNumberOfNormalIn(T t) {
        if (t == null) {
            throw new IllegalArgumentException("N is null");
        }
        assert (!t.equals(this.exit()));
        int n = this.getNumber(t);
        int n2 = 0;
        if (n > 0 && this.fallThru.get(n - 1)) {
            ++n2;
        }
        return this.normalEdgeManager.getPredNodeCount(t) + n2;
    }

    public int getNumberOfExceptionalIn(T t) {
        if (t == null) {
            throw new IllegalArgumentException("N is null");
        }
        assert (!t.equals(this.exit()));
        return this.exceptionalEdgeManager.getPredNodeCount(t);
    }

    boolean hasAnyNormalOut(int n) {
        return this.fallThru.get(n) || this.normalEdgeManager.getSuccNodeCount(n) > 0 || this.normalToExit.get(n);
    }

    private int getNumberOfNormalOut(int n) {
        int n2 = 0;
        if (this.fallThru.get(n)) {
            ++n2;
        }
        if (this.normalToExit.get(n)) {
            ++n2;
        }
        return this.normalEdgeManager.getSuccNodeCount(n) + n2;
    }

    public int getNumberOfExceptionalOut(int n) {
        int n2 = 0;
        if (this.exceptionalToExit.get(n)) {
            ++n2;
        }
        return this.exceptionalEdgeManager.getSuccNodeCount(n) + n2;
    }

    public int getNumberOfNormalOut(T t) {
        return this.getNumberOfNormalOut(this.getNumber(t));
    }

    public int getNumberOfExceptionalOut(T t) {
        return this.getNumberOfExceptionalOut(this.getNumber(t));
    }

    @Override
    public Iterator<T> getPredNodes(T t) {
        boolean bl;
        if (t == null) {
            throw new IllegalArgumentException("N is null");
        }
        if (t.equals(this.exit())) {
            return Predicate.filter(this.iterator(), new Predicate<T>(){

                @Override
                public boolean test(T t) {
                    int n = AbstractCFG.this.getNumber(t);
                    return AbstractCFG.this.normalToExit.get(n) || AbstractCFG.this.exceptionalToExit.get(n);
                }
            }).iterator();
        }
        int n = this.getNumber(t);
        boolean bl2 = this.getNumberOfNormalIn(t) > 0;
        boolean bl3 = bl = this.getNumberOfExceptionalIn(t) > 0;
        if (bl2) {
            if (bl) {
                HashSet hashSet = HashSetFactory.make(this.getNumberOfNormalIn(t) + this.getNumberOfExceptionalIn(t));
                hashSet.addAll(Iterator2Collection.toSet(this.normalEdgeManager.getPredNodes(t)));
                hashSet.addAll(Iterator2Collection.toSet(this.exceptionalEdgeManager.getPredNodes(t)));
                if (this.fallThru.get(n - 1)) {
                    hashSet.add(this.getNode(n - 1));
                }
                return hashSet.iterator();
            }
            if (n > 0 && this.fallThru.get(n - 1)) {
                return IteratorPlusOne.make(this.normalEdgeManager.getPredNodes(t), this.getNode(n - 1));
            }
            return this.normalEdgeManager.getPredNodes(t);
        }
        if (bl) {
            return this.exceptionalEdgeManager.getPredNodes(t);
        }
        return EmptyIterator.instance();
    }

    @Override
    public int getSuccNodeCount(T t) {
        if (t == null) {
            throw new IllegalArgumentException("N is null");
        }
        if (t.equals(this.exit())) {
            return 0;
        }
        int n = this.getNumberOfNormalOut(t);
        int n2 = this.getNumberOfExceptionalOut(t);
        if (n > 0) {
            if (n2 > 0) {
                if (n2 == 1) {
                    int n3 = this.getNumber(t);
                    if (this.exceptionalToExit.get(n3)) {
                        if (this.normalToExit.get(n3)) {
                            return n + n2 - 1;
                        }
                        return n + n2;
                    }
                    return this.slowCountSuccNodes(t);
                }
                return this.slowCountSuccNodes(t);
            }
            return n;
        }
        return n2;
    }

    private int slowCountSuccNodes(T t) {
        return Iterator2Collection.toSet(this.getSuccNodes(t)).size();
    }

    @Override
    public Iterator<T> getSuccNodes(T t) {
        int n = this.getNumber(t);
        if (this.normalToExit.get(n) && this.exceptionalToExit.get(n)) {
            return new CompoundIterator<T>(this.iterateNormalSuccessorsWithoutExit(n), this.iterateExceptionalSuccessors(n));
        }
        return new CompoundIterator<T>(this.iterateNormalSuccessors(n), this.iterateExceptionalSuccessors(n));
    }

    private Iterator<T> iterateExceptionalSuccessors(int n) {
        if (this.exceptionalEdgeManager.hasAnySuccessor(n)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            SimpleIntVector simpleIntVector = this.exceptionalSuccessors.get(n);
            int n2 = 0;
            while (n2 <= simpleIntVector.getMaxIndex()) {
                arrayList.add(this.getNode(simpleIntVector.get(n2)));
                ++n2;
            }
            if (this.exceptionalToExit.get(n)) {
                arrayList.add(this.exit);
            }
            return arrayList.iterator();
        }
        if (this.exceptionalToExit.get(n)) {
            return new NonNullSingletonIterator<T>(this.exit());
        }
        return EmptyIterator.instance();
    }

    Iterator<T> iterateExceptionalPredecessors(T t) {
        if (t.equals(this.exit())) {
            return Predicate.filter(this.iterator(), new Predicate<T>(){

                @Override
                public boolean test(T t) {
                    int n = AbstractCFG.this.getNumber(t);
                    return AbstractCFG.this.exceptionalToExit.get(n);
                }
            }).iterator();
        }
        return this.exceptionalEdgeManager.getPredNodes(t);
    }

    Iterator<T> iterateNormalPredecessors(T t) {
        if (t.equals(this.exit())) {
            return Predicate.filter(this.iterator(), new Predicate<T>(){

                @Override
                public boolean test(T t) {
                    int n = AbstractCFG.this.getNumber(t);
                    return AbstractCFG.this.normalToExit.get(n);
                }
            }).iterator();
        }
        int n = this.getNumber(t);
        if (n > 0 && this.fallThru.get(n - 1)) {
            return IteratorPlusOne.make(this.normalEdgeManager.getPredNodes(t), this.getNode(n - 1));
        }
        return this.normalEdgeManager.getPredNodes(t);
    }

    private Iterator<T> iterateNormalSuccessors(int n) {
        if (this.fallThru.get(n)) {
            if (this.normalToExit.get(n)) {
                return new IteratorPlusTwo<Object>(this.normalEdgeManager.getSuccNodes(n), this.getNode(n + 1), this.exit());
            }
            return IteratorPlusOne.make(this.normalEdgeManager.getSuccNodes(n), this.getNode(n + 1));
        }
        if (this.normalToExit.get(n)) {
            return IteratorPlusOne.make(this.normalEdgeManager.getSuccNodes(n), this.exit());
        }
        return this.normalEdgeManager.getSuccNodes(n);
    }

    private Iterator<T> iterateNormalSuccessorsWithoutExit(int n) {
        if (this.fallThru.get(n)) {
            return IteratorPlusOne.make(this.normalEdgeManager.getSuccNodes(n), this.getNode(n + 1));
        }
        return this.normalEdgeManager.getSuccNodes(n);
    }

    @Override
    public void addNode(T t) {
        this.nodeManager.addNode(t);
    }

    @Override
    public int getMaxNumber() {
        return this.nodeManager.getMaxNumber();
    }

    @Override
    public T getNode(int n) {
        return (T)((IBasicBlock)this.nodeManager.getNode(n));
    }

    @Override
    public int getNumber(T t) {
        return this.nodeManager.getNumber(t);
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodeManager.getNumberOfNodes();
    }

    @Override
    public Iterator<T> iterator() {
        return this.nodeManager.iterator();
    }

    @Override
    public void addEdge(T t, T t2) throws UnimplementedError {
        Assertions.UNREACHABLE("Don't call me .. use addNormalEdge or addExceptionalEdge");
    }

    @Override
    public void removeEdge(T t, T t2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasEdge(T t, T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("dst is null");
        }
        int n = this.getNumber(t);
        if (t2.equals(this.exit())) {
            return this.normalToExit.get(n) || this.exceptionalToExit.get(n);
        }
        if (this.getNumber(t2) == n + 1 && this.fallThru.get(n)) {
            return true;
        }
        return this.normalEdgeManager.hasEdge(t, t2) || this.exceptionalEdgeManager.hasEdge(t, t2);
    }

    public boolean hasExceptionalEdge(T t, T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("dst is null");
        }
        int n = this.getNumber(t);
        if (t2.equals(this.exit())) {
            return this.exceptionalToExit.get(n);
        }
        return this.exceptionalEdgeManager.hasEdge(t, t2);
    }

    public boolean hasNormalEdge(T t, T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("dst is null");
        }
        int n = this.getNumber(t);
        if (t2.equals(this.exit())) {
            return this.normalToExit.get(n);
        }
        if (this.getNumber(t2) == n + 1 && this.fallThru.get(n)) {
            return true;
        }
        return this.normalEdgeManager.hasEdge(t, t2);
    }

    public void addNormalEdge(T t, T t2) {
        if (t == null) {
            throw new IllegalArgumentException("src is null");
        }
        if (t2 == null) {
            throw new IllegalArgumentException("dst is null");
        }
        if (t2.equals(this.exit())) {
            this.normalToExit.set(this.getNumber(t));
        } else if (this.getNumber(t2) == this.getNumber(t) + 1) {
            this.fallThru.set(this.getNumber(t));
        } else {
            this.normalEdgeManager.addEdge(t, t2);
        }
    }

    public void addExceptionalEdge(T t, T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("dst is null");
        }
        if (t2.equals(this.exit())) {
            this.exceptionalToExit.set(this.getNumber(t));
        } else {
            this.exceptionalEdgeManager.addEdge(t, t2);
            SimpleIntVector simpleIntVector = this.exceptionalSuccessors.get(this.getNumber(t));
            if (simpleIntVector == null) {
                simpleIntVector = new SimpleIntVector(-1);
                this.exceptionalSuccessors.set(this.getNumber(t), simpleIntVector);
                simpleIntVector.set(0, this.getNumber(t2));
                return;
            }
            if (simpleIntVector.get(simpleIntVector.getMaxIndex()) != this.getNumber(t2)) {
                simpleIntVector.set(simpleIntVector.getMaxIndex() + 1, this.getNumber(t2));
            }
        }
    }

    @Override
    public void removeNodeAndEdges(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeNode(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean containsNode(T t) {
        return this.nodeManager.containsNode(t);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (IBasicBlock iBasicBlock : this) {
            stringBuffer.append("BB").append(this.getNumber((T)iBasicBlock)).append("\n");
            Iterator<IBasicBlock> iterator = this.getSuccNodes((T)iBasicBlock);
            while (iterator.hasNext()) {
                stringBuffer.append("    -> BB").append(this.getNumber((T)iterator.next())).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    protected void setCatchBlock(int n) {
        this.catchBlocks.set(n);
    }

    public boolean isCatchBlock(int n) {
        return this.catchBlocks.get(n);
    }

    @Override
    public BitVector getCatchBlocks() {
        return this.catchBlocks;
    }

    @Override
    public IMethod getMethod() {
        return this.method;
    }

    @Override
    public void removeAllIncidentEdges(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public List<T> getExceptionalSuccessors(T t) {
        if (t == null) {
            throw new IllegalArgumentException("b is null");
        }
        ArrayList<IBasicBlock> arrayList = new ArrayList<IBasicBlock>();
        Iterator<T> iterator = this.iterateExceptionalSuccessors(t.getNumber());
        while (iterator.hasNext()) {
            arrayList.add((IBasicBlock)iterator.next());
        }
        return arrayList;
    }

    @Override
    public Collection<T> getNormalSuccessors(T t) {
        if (t == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Iterator2Collection.toSet(this.iterateNormalSuccessors(t.getNumber()));
    }

    @Override
    public Iterator<T> iterateNodes(IntSet intSet) {
        return new NumberedNodeIterator(intSet, this);
    }

    @Override
    public void removeIncomingEdges(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    public FixedSizeBitVector getExceptionalToExit() {
        return this.exceptionalToExit;
    }

    public FixedSizeBitVector getNormalToExit() {
        return this.normalToExit;
    }

    @Override
    public Collection<T> getExceptionalPredecessors(T t) {
        if (t == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Iterator2Collection.toSet(this.iterateExceptionalPredecessors(t));
    }

    @Override
    public Collection<T> getNormalPredecessors(T t) {
        if (t == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Iterator2Collection.toSet(this.iterateNormalPredecessors(t));
    }

    @Override
    public IntSet getPredNodeNumbers(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(T t) {
        int n = this.getNumber(t);
        IntSet intSet = this.normalEdgeManager.getSuccNodeNumbers(t);
        MutableSparseIntSet mutableSparseIntSet = intSet == null ? MutableSparseIntSet.makeEmpty() : MutableSparseIntSet.make(intSet);
        intSet = this.exceptionalEdgeManager.getSuccNodeNumbers(t);
        if (intSet != null) {
            mutableSparseIntSet.addAll(intSet);
        }
        if (this.normalToExit.get(n) || this.exceptionalToExit.get(n)) {
            mutableSparseIntSet.add(this.exit.getNumber());
        }
        if (this.fallThru.get(n)) {
            mutableSparseIntSet.add(n + 1);
        }
        return mutableSparseIntSet;
    }
}

