/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.BytecodeLanguage;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrikeCFG
extends AbstractCFG<IInstruction, BasicBlock> {
    private static final boolean DEBUG = false;
    private int[] instruction2Block;
    private final IBytecodeMethod method;
    private final int hashBase;
    private final Set<ExceptionHandler> exceptionHandlers = HashSetFactory.make(10);

    public ShrikeCFG(IBytecodeMethod iBytecodeMethod) throws IllegalArgumentException {
        super(iBytecodeMethod);
        if (iBytecodeMethod == null) {
            throw new IllegalArgumentException("method cannot be null");
        }
        this.method = iBytecodeMethod;
        this.hashBase = iBytecodeMethod.hashCode() * 9967;
        this.makeBasicBlocks();
        this.init();
        this.computeI2BMapping();
        this.computeEdges();
    }

    @Override
    public IBytecodeMethod getMethod() {
        return this.method;
    }

    @Override
    public int hashCode() {
        return 9511 * this.getMethod().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ShrikeCFG && this.getMethod().equals(((ShrikeCFG)object).getMethod());
    }

    public IInstruction[] getInstructions() {
        try {
            return this.method.getInstructions();
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    private void computeI2BMapping() {
        this.instruction2Block = new int[this.getInstructions().length];
        for (BasicBlock basicBlock : this) {
            int n = basicBlock.getFirstInstructionIndex();
            while (n <= basicBlock.getLastInstructionIndex()) {
                this.instruction2Block[n] = this.getNumber(basicBlock);
                ++n;
            }
        }
    }

    private void computeEdges() {
        for (BasicBlock basicBlock : this) {
            if (basicBlock.equals(this.exit())) continue;
            if (basicBlock.equals(this.entry())) {
                BasicBlock basicBlock2 = this.getBlockForInstruction(0);
                assert (basicBlock2 != null);
                this.addNormalEdge(basicBlock, basicBlock2);
                continue;
            }
            basicBlock.computeOutgoingEdges();
        }
    }

    private void makeBasicBlocks() {
        ExceptionHandler[][] exceptionHandlerArray;
        try {
            exceptionHandlerArray = this.method.getHandlers();
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            exceptionHandlerArray = null;
        }
        boolean[] blArray = new boolean[this.getInstructions().length];
        boolean[] blArray2 = new boolean[this.getInstructions().length];
        int n = 2;
        blArray[0] = true;
        IInstruction[] iInstructionArray = this.getInstructions();
        int n2 = 0;
        while (n2 < iInstructionArray.length) {
            int[] nArray = iInstructionArray[n2].getBranchTargets();
            if (!(nArray.length <= 0 && iInstructionArray[n2].isFallThrough() || n2 + 1 >= iInstructionArray.length || blArray[n2 + 1])) {
                blArray[n2 + 1] = true;
                ++n;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                if (!blArray[nArray[n3]]) {
                    blArray[nArray[n3]] = true;
                    ++n;
                }
                ++n3;
            }
            if (iInstructionArray[n2].isPEI()) {
                ExceptionHandler[] exceptionHandlerArray2 = exceptionHandlerArray[n2];
                if (n2 + 1 < iInstructionArray.length && !blArray[n2 + 1]) {
                    blArray[n2 + 1] = true;
                    ++n;
                }
                if (exceptionHandlerArray2 != null && exceptionHandlerArray2.length > 0) {
                    int n4 = 0;
                    while (n4 < exceptionHandlerArray2.length) {
                        this.exceptionHandlers.add(exceptionHandlerArray2[n4]);
                        if (!blArray[exceptionHandlerArray2[n4].getHandler()]) {
                            blArray[exceptionHandlerArray2[n4].getHandler()] = true;
                            ++n;
                        }
                        blArray2[exceptionHandlerArray2[n4].getHandler()] = true;
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        BasicBlock basicBlock = new BasicBlock(-1);
        this.addNode(basicBlock);
        int n5 = 1;
        int n6 = 0;
        while (n6 < blArray.length) {
            if (blArray[n6]) {
                BasicBlock basicBlock2 = new BasicBlock(n6);
                this.addNode(basicBlock2);
                if (blArray2[n6]) {
                    this.setCatchBlock(n5);
                }
                ++n5;
            }
            ++n6;
        }
        BasicBlock basicBlock3 = new BasicBlock(-1);
        this.addNode(basicBlock3);
    }

    @Override
    public BasicBlock getBlockForInstruction(int n) {
        return (BasicBlock)this.getNode(this.instruction2Block[n]);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (BasicBlock basicBlock : this) {
            stringBuffer.append("BB").append(this.getNumber(basicBlock)).append("\n");
            int n = basicBlock.getFirstInstructionIndex();
            while (n <= basicBlock.getLastInstructionIndex()) {
                stringBuffer.append("  ").append(n).append("  ").append(this.getInstructions()[n]).append("\n");
                ++n;
            }
            Iterator<BasicBlock> iterator = this.getSuccNodes(basicBlock);
            while (iterator.hasNext()) {
                stringBuffer.append("    -> BB").append(this.getNumber(iterator.next())).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public int getMaxStackHeight() {
        return this.method.getMaxStackHeight();
    }

    public int getMaxLocals() {
        return this.method.getMaxLocals();
    }

    public Set<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    @Override
    public int getProgramCounter(int n) {
        try {
            return this.method.getBytecodeIndex(n);
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BasicBlock
    extends NodeWithNumber
    implements IBasicBlock<IInstruction> {
        private final int startIndex;

        public BasicBlock(int n) {
            this.startIndex = n;
        }

        @Override
        public boolean isCatchBlock() {
            return ShrikeCFG.this.isCatchBlock(this.getNumber());
        }

        private void computeOutgoingEdges() {
            IInstruction iInstruction = ShrikeCFG.this.getInstructions()[this.getLastInstructionIndex()];
            int[] nArray = iInstruction.getBranchTargets();
            int n = 0;
            while (n < nArray.length) {
                BasicBlock basicBlock = ShrikeCFG.this.getBlockForInstruction(nArray[n]);
                this.addNormalEdgeTo(basicBlock);
                ++n;
            }
            this.addExceptionalEdges(iInstruction);
            if (iInstruction.isFallThrough()) {
                BasicBlock basicBlock = (BasicBlock)ShrikeCFG.this.getNode(this.getNumber() + 1);
                this.addNormalEdgeTo(basicBlock);
            }
            if (iInstruction instanceof ReturnInstruction) {
                BasicBlock basicBlock = (BasicBlock)ShrikeCFG.this.exit();
                this.addNormalEdgeTo(basicBlock);
            }
        }

        protected void addExceptionalEdges(IInstruction iInstruction) {
            IClassHierarchy iClassHierarchy = this.getMethod().getClassHierarchy();
            if (iInstruction.isPEI()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Collection<Object> collection = null;
                boolean bl = false;
                ExceptionHandler[] exceptionHandlerArray = this.getExceptionHandlers();
                if (iInstruction instanceof ThrowInstruction) {
                    bl = true;
                } else if (exceptionHandlerArray != null && exceptionHandlerArray.length > 0) {
                    object4 = this.getMethod().getDeclaringClass().getClassLoader();
                    object3 = (BytecodeLanguage)object4.getLanguage();
                    collection = object3.getImplicitExceptionTypes(iInstruction);
                    if (iInstruction instanceof IInvokeInstruction) {
                        object2 = (IInvokeInstruction)iInstruction;
                        collection = HashSetFactory.make(collection);
                        object = MethodReference.findOrCreate((Language)object3, object4.getReference(), object2.getClassType(), object2.getMethodName(), object2.getMethodSignature());
                        try {
                            collection.addAll(object3.inferInvokeExceptions((MethodReference)object, iClassHierarchy));
                        }
                        catch (InvalidClassFileException invalidClassFileException) {
                            invalidClassFileException.printStackTrace();
                            Assertions.UNREACHABLE();
                        }
                    }
                }
                if (exceptionHandlerArray != null && exceptionHandlerArray.length > 0) {
                    if (!bl) {
                        collection = HashSetFactory.make(collection);
                    }
                    int n = 0;
                    while (n < exceptionHandlerArray.length) {
                        object3 = ShrikeCFG.this.getBlockForInstruction(exceptionHandlerArray[n].getHandler());
                        if (bl) {
                            this.addExceptionalEdgeTo((BasicBlock)object3);
                        } else {
                            Object object5;
                            object2 = null;
                            if (exceptionHandlerArray[n].getCatchClass() != null) {
                                object = ShrikeCFG.this.getMethod().getDeclaringClass().getReference().getClassLoader();
                                object2 = ShrikeUtil.makeTypeReference((ClassLoaderReference)object, exceptionHandlerArray[n].getCatchClass());
                                object5 = iClassHierarchy.lookupClass((TypeReference)object2);
                                if (object5 == null) {
                                    this.addExceptionalEdgeTo((BasicBlock)object3);
                                    Warnings.add(FailedExceptionResolutionWarning.create((TypeReference)object2));
                                    object2 = null;
                                }
                            } else if (!collection.isEmpty()) {
                                this.addExceptionalEdgeTo((BasicBlock)object3);
                                collection.clear();
                                object2 = null;
                            }
                            if (object2 != null) {
                                object = iClassHierarchy.lookupClass((TypeReference)object2);
                                object5 = new ArrayList(collection.size());
                                for (TypeReference typeReference : collection) {
                                    if (typeReference == null) continue;
                                    IClass iClass = iClassHierarchy.lookupClass(typeReference);
                                    if (iClass == null) {
                                        Warnings.add(FailedExceptionResolutionWarning.create((TypeReference)object2));
                                        this.addExceptionalEdgeTo((BasicBlock)object3);
                                        continue;
                                    }
                                    boolean bl2 = iClassHierarchy.isSubclassOf(iClass, (IClass)object);
                                    if (!bl2 && !iClassHierarchy.isSubclassOf((IClass)object, iClass)) continue;
                                    this.addExceptionalEdgeTo((BasicBlock)object3);
                                    if (!bl2) continue;
                                    ((ArrayList)object5).add(typeReference);
                                }
                                collection.removeAll((Collection<?>)object5);
                            }
                        }
                        ++n;
                    }
                    if (collection == null || !collection.isEmpty()) {
                        BasicBlock basicBlock = (BasicBlock)ShrikeCFG.this.exit();
                        this.addExceptionalEdgeTo(basicBlock);
                    }
                } else {
                    object4 = (BasicBlock)ShrikeCFG.this.exit();
                    this.addExceptionalEdgeTo((BasicBlock)object4);
                }
            }
        }

        private ExceptionHandler[] getExceptionHandlers() {
            ExceptionHandler[][] exceptionHandlerArray;
            try {
                exceptionHandlerArray = ShrikeCFG.this.method.getHandlers();
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
                exceptionHandlerArray = null;
            }
            ExceptionHandler[] exceptionHandlerArray2 = exceptionHandlerArray[this.getLastInstructionIndex()];
            return exceptionHandlerArray2;
        }

        private void addNormalEdgeTo(BasicBlock basicBlock) {
            ShrikeCFG.this.addNormalEdge(this, basicBlock);
        }

        private void addExceptionalEdgeTo(BasicBlock basicBlock) {
            ShrikeCFG.this.addExceptionalEdge(this, basicBlock);
        }

        @Override
        public int getLastInstructionIndex() {
            if (this == ShrikeCFG.this.entry() || this == ShrikeCFG.this.exit()) {
                return -2;
            }
            if (this.getNumber() == ShrikeCFG.this.getMaxNumber() - 1) {
                return ShrikeCFG.this.getInstructions().length - 1;
            }
            BasicBlock basicBlock = (BasicBlock)ShrikeCFG.this.getNode(this.getNumber() + 1);
            return basicBlock.getFirstInstructionIndex() - 1;
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.startIndex;
        }

        public String toString() {
            return "BB[Shrike]" + this.getNumber() + " - " + ShrikeCFG.this.method.getDeclaringClass().getReference().getName() + "." + ShrikeCFG.this.method.getName();
        }

        @Override
        public boolean isExitBlock() {
            return this == ShrikeCFG.this.exit();
        }

        @Override
        public boolean isEntryBlock() {
            return this == ShrikeCFG.this.entry();
        }

        @Override
        public IMethod getMethod() {
            return ShrikeCFG.this.getMethod();
        }

        public int hashCode() {
            return ShrikeCFG.this.hashBase + this.getNumber();
        }

        public boolean equals(Object object) {
            return object instanceof BasicBlock && ((BasicBlock)object).getMethod().equals(this.getMethod()) && ((BasicBlock)object).getNumber() == this.getNumber();
        }

        @Override
        public int getNumber() {
            return this.getGraphNodeId();
        }

        @Override
        public Iterator<IInstruction> iterator() {
            return new ArrayIterator<IInstruction>(ShrikeCFG.this.getInstructions(), this.getFirstInstructionIndex(), this.getLastInstructionIndex());
        }
    }

    private static class FailedExceptionResolutionWarning
    extends Warning {
        final TypeReference T;

        FailedExceptionResolutionWarning(TypeReference typeReference) {
            super((byte)1);
            this.T = typeReference;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.T;
        }

        public static FailedExceptionResolutionWarning create(TypeReference typeReference) {
            return new FailedExceptionResolutionWarning(typeReference);
        }
    }
}

