/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.strings.Atom;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayClass
implements IClass,
Constants {
    private final IClassHierarchy cha;
    private final TypeReference type;
    private final IClassLoader loader;

    ArrayClass(TypeReference typeReference, IClassLoader iClassLoader, IClassHierarchy iClassHierarchy) {
        this.type = typeReference;
        this.loader = iClassLoader;
        this.cha = iClassHierarchy;
        TypeReference typeReference2 = typeReference.getInnermostElementType();
        if (!typeReference2.isPrimitiveType()) {
            IClass iClass = iClassLoader.lookupClass(typeReference2.getName());
            if (iClass == null) {
                Assertions.UNREACHABLE("caller should not attempt to create an array with type " + typeReference);
            }
        } else assert (iClassLoader.getReference().equals(ClassLoaderReference.Primordial));
    }

    @Override
    public IClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public TypeName getName() {
        return this.getReference().getName();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public int getModifiers() {
        return 17;
    }

    public String getQualifiedNameForReflection() {
        return this.type.getName().toString();
    }

    @Override
    public IClass getSuperclass() {
        IClass iClass = this.getElementClass();
        assert (this.getReference().getArrayElementType().isPrimitiveType() || iClass != null);
        if (iClass == null || iClass.getReference() == this.getClassLoader().getLanguage().getRootType()) {
            return this.loader.lookupClass(this.getClassLoader().getLanguage().getRootType().getName());
        }
        TypeReference typeReference = iClass.getSuperclass().getReference();
        TypeReference typeReference2 = TypeReference.findOrCreateArrayOf(typeReference);
        return iClass.getSuperclass().getClassLoader().lookupClass(typeReference2.getName());
    }

    @Override
    public IMethod getMethod(Selector selector) {
        return this.loader.lookupClass(this.getClassLoader().getLanguage().getRootType().getName()).getMethod(selector);
    }

    @Override
    public IField getField(Atom atom) {
        return this.getSuperclass().getField(atom);
    }

    @Override
    public Collection<IMethod> getDeclaredMethods() {
        return Collections.emptySet();
    }

    public int getNumberOfDeclaredMethods() {
        return 0;
    }

    @Override
    public TypeReference getReference() {
        return this.type;
    }

    @Override
    public String getSourceFileName() {
        return null;
    }

    @Override
    public IMethod getClassInitializer() {
        return null;
    }

    @Override
    public boolean isArrayClass() {
        return true;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public IClass getElementClass() {
        TypeReference typeReference = this.getReference().getArrayElementType();
        if (typeReference.isPrimitiveType()) {
            return null;
        }
        return this.loader.lookupClass(typeReference.getName());
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        HashSet<IClass> hashSet = HashSetFactory.make(2);
        TypeReference[] typeReferenceArray = this.getClassLoader().getLanguage().getArrayInterfaces();
        int n = typeReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference typeReference = typeReferenceArray[n2];
            IClass iClass = this.loader.lookupClass(typeReference.getName());
            if (iClass != null) {
                hashSet.add(iClass);
            }
            ++n2;
        }
        return hashSet;
    }

    public Collection<IClass> getAllAncestorInterfaces() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReferenceType() {
        return true;
    }

    public int getDimensionality() {
        return this.getReference().getDimensionality();
    }

    public IClass getInnermostElementClass() {
        TypeReference typeReference = this.getReference().getInnermostElementType();
        if (typeReference.isPrimitiveType()) {
            return null;
        }
        return this.loader.lookupClass(typeReference.getName());
    }

    @Override
    public Collection<IClass> getDirectInterfaces() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayClass) {
            ArrayClass arrayClass = (ArrayClass)object;
            return this.loader.equals(arrayClass.loader) && this.type.equals(arrayClass.type);
        }
        return false;
    }

    @Override
    public Collection<IField> getAllInstanceFields() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<IField> getAllStaticFields() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<IMethod> getAllMethods() {
        return this.loader.lookupClass(this.getClassLoader().getLanguage().getRootType().getName()).getAllMethods();
    }

    @Override
    public Collection<IField> getAllFields() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public InputStream getSource() {
        return null;
    }
}

