/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.debug.Assertions;

public abstract class CallSiteReference
extends ProgramCounter
implements BytecodeConstants,
ContextItem {
    private final MethodReference declaredTarget;

    protected CallSiteReference(int n, MethodReference methodReference) {
        super(n);
        this.declaredTarget = methodReference;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.declaredTarget == null ? 0 : this.declaredTarget.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CallSiteReference callSiteReference = (CallSiteReference)object;
        return !(this.declaredTarget == null ? callSiteReference.declaredTarget != null : !this.declaredTarget.equals(callSiteReference.declaredTarget));
    }

    public static CallSiteReference make(int n, MethodReference methodReference, IInvokeInstruction.IDispatch iDispatch) {
        if (iDispatch == IInvokeInstruction.Dispatch.SPECIAL) {
            return new SpecialCall(n, methodReference);
        }
        if (iDispatch == IInvokeInstruction.Dispatch.VIRTUAL) {
            return new VirtualCall(n, methodReference);
        }
        if (iDispatch == IInvokeInstruction.Dispatch.INTERFACE) {
            return new InterfaceCall(n, methodReference);
        }
        if (iDispatch == IInvokeInstruction.Dispatch.STATIC) {
            return new StaticCall(n, methodReference);
        }
        throw new IllegalArgumentException("unsupported code: " + iDispatch);
    }

    public MethodReference getDeclaredTarget() {
        return this.declaredTarget;
    }

    public abstract IInvokeInstruction.IDispatch getInvocationCode();

    public String toString() {
        return "invoke" + this.getInvocationString(this.getInvocationCode()) + " " + this.declaredTarget + "@" + this.getProgramCounter();
    }

    protected String getInvocationString(IInvokeInstruction.IDispatch iDispatch) {
        if (iDispatch == IInvokeInstruction.Dispatch.STATIC) {
            return "static";
        }
        if (iDispatch == IInvokeInstruction.Dispatch.SPECIAL) {
            return "special";
        }
        if (iDispatch == IInvokeInstruction.Dispatch.VIRTUAL) {
            return "virtual";
        }
        if (iDispatch == IInvokeInstruction.Dispatch.INTERFACE) {
            return "interface";
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public String getInvocationString() {
        return this.getInvocationString(this.getInvocationCode());
    }

    public final boolean isInterface() {
        return this.getInvocationCode() == IInvokeInstruction.Dispatch.INTERFACE;
    }

    public final boolean isVirtual() {
        return this.getInvocationCode() == IInvokeInstruction.Dispatch.VIRTUAL;
    }

    public final boolean isSpecial() {
        return this.getInvocationCode() == IInvokeInstruction.Dispatch.SPECIAL;
    }

    public boolean isStatic() {
        return this.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC;
    }

    public boolean isFixed() {
        return this.isStatic() || this.isSpecial();
    }

    public boolean isDispatch() {
        return this.isVirtual() || this.isInterface();
    }

    static class InterfaceCall
    extends CallSiteReference {
        InterfaceCall(int n, MethodReference methodReference) {
            super(n, methodReference);
        }

        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.INTERFACE;
        }
    }

    static class SpecialCall
    extends CallSiteReference {
        SpecialCall(int n, MethodReference methodReference) {
            super(n, methodReference);
        }

        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.SPECIAL;
        }
    }

    static class StaticCall
    extends CallSiteReference {
        StaticCall(int n, MethodReference methodReference) {
            super(n, methodReference);
        }

        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.STATIC;
        }
    }

    static class VirtualCall
    extends CallSiteReference {
        VirtualCall(int n, MethodReference methodReference) {
            super(n, methodReference);
        }

        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.VIRTUAL;
        }
    }
}

