/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ArrayClassLoader;
import com.ibm.wala.classLoader.BytecodeClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileEntry;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashCodeComparator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.io.FileSuffixes;
import com.ibm.wala.util.shrike.ShrikeClassReaderHandle;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderImpl
implements IClassLoader {
    private static final int DEBUG_LEVEL = 0;
    private static final boolean OPTIMIZE_JAR_FILE_IO = true;
    private final SetOfClasses exclusions;
    private final ClassLoaderReference loader;
    protected final Map<TypeName, IClass> loadedClasses = HashMapFactory.make();
    private final Map<TypeName, ModuleEntry> sourceMap = HashMapFactory.make();
    private final IClassLoader parent;
    protected final IClassHierarchy cha;
    private final ArrayClassLoader arrayClassLoader;

    public ClassLoaderImpl(ClassLoaderReference classLoaderReference, ArrayClassLoader arrayClassLoader, IClassLoader iClassLoader, SetOfClasses setOfClasses, IClassHierarchy iClassHierarchy) {
        if (classLoaderReference == null) {
            throw new IllegalArgumentException("null loader");
        }
        this.arrayClassLoader = arrayClassLoader;
        this.parent = iClassLoader;
        this.loader = classLoaderReference;
        this.exclusions = setOfClasses;
        this.cha = iClassHierarchy;
    }

    private Set<ModuleEntry> getSourceFiles(Module module) throws IOException {
        TreeSet treeSet = new TreeSet(HashCodeComparator.instance());
        treeSet.addAll(Iterator2Collection.toSet(module.getEntries()));
        HashSet<ModuleEntry> hashSet = HashSetFactory.make();
        for (ModuleEntry moduleEntry : treeSet) {
            if (moduleEntry.isSourceFile()) {
                hashSet.add(moduleEntry);
                continue;
            }
            if (!moduleEntry.isModuleFile()) continue;
            hashSet.addAll(this.getSourceFiles(moduleEntry.asModule()));
        }
        return hashSet;
    }

    private Set<ModuleEntry> getClassFiles(Module module) throws IOException {
        TreeSet treeSet = new TreeSet(HashCodeComparator.instance());
        treeSet.addAll(Iterator2Collection.toSet(module.getEntries()));
        HashSet<ModuleEntry> hashSet = HashSetFactory.make();
        for (ModuleEntry moduleEntry : treeSet) {
            if (moduleEntry.isClassFile()) {
                hashSet.add(moduleEntry);
                continue;
            }
            if (!moduleEntry.isModuleFile()) continue;
            Set<ModuleEntry> set = this.getClassFiles(moduleEntry.asModule());
            this.removeClassFiles(set, hashSet);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private void removeClassFiles(Set<ModuleEntry> set, Set<ModuleEntry> set2) {
        HashSet hashSet = HashSetFactory.make();
        for (ModuleEntry object : set2) {
            hashSet.add(object.getClassName());
        }
        HashSet hashSet2 = HashSetFactory.make();
        for (ModuleEntry moduleEntry : set) {
            if (!hashSet.contains(moduleEntry.getClassName())) continue;
            hashSet2.add(moduleEntry);
        }
        set.removeAll(hashSet2);
    }

    private Collection<IClass> getAllClasses() {
        assert (this.loadedClasses != null);
        return this.loadedClasses.values();
    }

    private void loadAllClasses(Collection<ModuleEntry> collection, Map<String, Object> map) {
        for (ModuleEntry moduleEntry : collection) {
            if (!moduleEntry.isClassFile()) continue;
            String string = moduleEntry.getClassName().replace('.', '/');
            if (this.exclusions != null && this.exclusions.contains(string)) continue;
            ShrikeClassReaderHandle shrikeClassReaderHandle = new ShrikeClassReaderHandle(moduleEntry);
            string = "L" + string;
            try {
                Object object;
                TypeName typeName = TypeName.string2TypeName(string);
                if (this.loadedClasses.get(typeName) != null) {
                    Warnings.add(MultipleImplementationsWarning.create(string));
                    continue;
                }
                if (this.parent != null && this.parent.lookupClass(typeName) != null) {
                    Warnings.add(MultipleImplementationsWarning.create(string));
                    continue;
                }
                ShrikeClassReaderHandle shrikeClassReaderHandle2 = shrikeClassReaderHandle;
                if (map != null && (object = map.get(moduleEntry.getName())) != null) {
                    shrikeClassReaderHandle2 = new ByteArrayReaderHandle(moduleEntry, (byte[])object);
                }
                if (((BytecodeClass)(object = new ShrikeClass(shrikeClassReaderHandle2, this, this.cha))).getReference().getName().equals(typeName)) {
                    this.loadedClasses.put(typeName, new ShrikeClass(shrikeClassReaderHandle, this, this.cha));
                    continue;
                }
                Warnings.add(InvalidClassFile.create(string));
            }
            catch (InvalidClassFileException invalidClassFileException) {
                Warnings.add(InvalidClassFile.create(string));
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getAllClassAndSourceFileContents(byte[] byArray, String string, Map<String, Map<String, Long>> map) {
        HashMap<String, Object> hashMap;
        block9: {
            if (byArray == null) {
                return null;
            }
            Map<String, Long> map2 = map.get(string);
            if (map2 == null) {
                return null;
            }
            hashMap = HashMapFactory.make();
            try {
                JarInputStream jarInputStream = new JarInputStream(new ByteArrayInputStream(byArray));
                JarEntry jarEntry = null;
                while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                    byte[] byArray2 = this.getEntryBytes(jarEntry, map2.get(jarEntry.getName()), jarInputStream);
                    if (byArray2 == null) {
                        return null;
                    }
                    String string2 = jarEntry.getName();
                    if (FileSuffixes.isJarFile(string2) || FileSuffixes.isWarFile(string2)) {
                        Map<String, Object> map3 = this.getAllClassAndSourceFileContents(byArray2, string2, map);
                        if (map3 == null) {
                            return null;
                        }
                        for (String string3 : map3.keySet()) {
                            if (hashMap.containsKey(string3)) continue;
                            hashMap.put(string3, map3.get(string3));
                        }
                        continue;
                    }
                    if (!FileSuffixes.isClassFile(string2) && !FileSuffixes.isSourceFile(string2)) continue;
                    hashMap.put(string2, byArray2);
                }
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        return hashMap;
    }

    private byte[] getEntryBytes(JarEntry jarEntry, Long l, InputStream inputStream) throws IOException {
        if (l == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        long l2 = 0L;
        byte[] byArray = new byte[1024];
        while (n > -1 && l2 < l) {
            n = inputStream.read(byArray, 0, 1024);
            if (n <= -1) continue;
            byteArrayOutputStream.write(byArray, 0, n);
            l2 += (long)n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void loadAllSources(Set<ModuleEntry> set) {
        for (ModuleEntry moduleEntry : set) {
            String string = moduleEntry.getClassName().replace('.', '/');
            string = string.replace(File.separatorChar, '/');
            string = "L" + (string.startsWith("/") ? string.substring(1) : string);
            TypeName typeName = TypeName.string2TypeName(string);
            this.sourceMap.put(typeName, moduleEntry);
        }
    }

    @Override
    public void init(List<Module> list) throws IOException {
        if (list == null) {
            throw new IllegalArgumentException("modules is null");
        }
        HashSet<ModuleEntry> hashSet = HashSetFactory.make();
        HashSet hashSet2 = HashSetFactory.make();
        for (Module module : list) {
            if (module instanceof JarFileModule) {
                this.getJarFileContents((JarFileModule)module);
            }
            Set<ModuleEntry> set = this.getClassFiles(module);
            this.removeClassFiles(set, hashSet);
            Set<ModuleEntry> set2 = this.getSourceFiles(module);
            Map<String, Object> map = null;
            this.loadAllClasses(set, map);
            this.loadAllSources(set2);
            for (ModuleEntry moduleEntry : set) {
                hashSet.add(moduleEntry);
            }
            for (ModuleEntry moduleEntry : set2) {
                hashSet2.add(moduleEntry);
            }
        }
    }

    private Map<String, Map<String, Long>> getEntrySizes(Module module, String string) {
        HashMap<String, Map<String, Long>> hashMap = HashMapFactory.make();
        HashMap<String, Long> hashMap2 = HashMapFactory.make();
        for (ModuleEntry moduleEntry : Iterator2Iterable.make(module.getEntries())) {
            if (moduleEntry.isModuleFile()) {
                hashMap.putAll(this.getEntrySizes(moduleEntry.asModule(), moduleEntry.getName()));
                continue;
            }
            if (!(moduleEntry instanceof JarFileEntry)) continue;
            hashMap2.put(moduleEntry.getName(), ((JarFileEntry)moduleEntry).getSize());
        }
        hashMap.put(string, hashMap2);
        return hashMap;
    }

    private void getJarFileContents(JarFileModule jarFileModule) {
        block15: {
            String string = jarFileModule.getJarFile().getName();
            InputStream inputStream = null;
            try {
                try {
                    File file = FileProvider.getFile(string);
                    int n = 65536;
                    inputStream = new BufferedInputStream(new FileInputStream(file), n);
                    byte[] byArray = new byte[1024];
                    int n2 = inputStream.read(byArray);
                    while (n2 != -1) {
                        n2 = inputStream.read(byArray);
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ClassLoaderReference getReference() {
        return this.loader;
    }

    @Override
    public Iterator<IClass> iterateAllClasses() {
        return this.getAllClasses().iterator();
    }

    @Override
    public IClass lookupClass(TypeName typeName) {
        IClass iClass;
        if (typeName == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (typeName.isArrayType()) {
            return this.arrayClassLoader.lookupClass(typeName, this, this.cha);
        }
        IClassLoader iClassLoader = this.getParent();
        if (iClassLoader != null && (iClass = iClassLoader.lookupClass(typeName)) != null) {
            return iClass;
        }
        iClass = this.loadedClasses.get(typeName);
        return iClass;
    }

    @Override
    public IClassLoader getParent() {
        return this.parent;
    }

    @Override
    public Atom getName() {
        return this.loader.getName();
    }

    @Override
    public Language getLanguage() {
        return Language.JAVA;
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public int getNumberOfClasses() {
        return this.getAllClasses().size();
    }

    @Override
    public int getNumberOfMethods() {
        int n = 0;
        Iterator<IClass> iterator = this.iterateAllClasses();
        while (iterator.hasNext()) {
            IClass iClass = iterator.next();
            n += iClass.getDeclaredMethods().size();
        }
        return n;
    }

    @Override
    public String getSourceFileName(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        ModuleEntry moduleEntry = this.sourceMap.get(iClass.getName());
        return moduleEntry == null ? null : moduleEntry.getName();
    }

    @Override
    public InputStream getSource(IMethod iMethod, int n) {
        return this.getSource(iMethod.getDeclaringClass());
    }

    @Override
    public String getSourceFileName(IMethod iMethod, int n) {
        return this.getSourceFileName(iMethod.getDeclaringClass());
    }

    @Override
    public InputStream getSource(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        ModuleEntry moduleEntry = this.sourceMap.get(iClass.getName());
        return moduleEntry == null ? null : moduleEntry.getInputStream();
    }

    @Override
    public void removeAll(Collection<IClass> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("toRemove is null");
        }
        for (IClass iClass : collection) {
            this.loadedClasses.remove(iClass.getName());
            this.sourceMap.remove(iClass.getName());
        }
    }

    @Override
    public SSAInstructionFactory getInstructionFactory() {
        return this.getLanguage().instructionFactory();
    }

    static class ByteArrayReaderHandle
    extends ShrikeClassReaderHandle {
        private byte[] contents;
        private boolean cleared;

        public ByteArrayReaderHandle(ModuleEntry moduleEntry, byte[] byArray) {
            super(moduleEntry);
            assert (byArray != null && byArray.length > 0);
            this.contents = byArray;
        }

        public ClassReader get() throws InvalidClassFileException {
            if (this.cleared) {
                return super.get();
            }
            return new ClassReader(this.contents);
        }

        public void clear() {
            if (this.cleared) {
                super.clear();
            } else {
                this.contents = null;
                this.cleared = true;
            }
        }
    }

    private static class InvalidClassFile
    extends Warning {
        final String className;

        InvalidClassFile(String string) {
            super((byte)2);
            this.className = string;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.className;
        }

        public static InvalidClassFile create(String string) {
            return new InvalidClassFile(string);
        }
    }

    private static class MultipleImplementationsWarning
    extends Warning {
        final String className;

        MultipleImplementationsWarning(String string) {
            super((byte)2);
            this.className = string;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.className;
        }

        public static MultipleImplementationsWarning create(String string) {
            return new MultipleImplementationsWarning(string);
        }
    }
}

