/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.JarFileEntry;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileUtil;
import com.ibm.wala.util.ref.CacheReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileModule
implements Module {
    private final JarFile file;
    private final HashMap<ZipEntry, Object> cache = HashMapFactory.make();

    public JarFileModule(JarFile jarFile) {
        if (jarFile == null) {
            throw new IllegalArgumentException("null f");
        }
        this.file = jarFile;
    }

    public String getAbsolutePath() {
        return this.file.getName();
    }

    public String toString() {
        return "JarFileModule:" + this.file.getName();
    }

    protected ModuleEntry createEntry(ZipEntry zipEntry) {
        return new JarFileEntry(zipEntry.getName(), this);
    }

    @Override
    public Iterator<ModuleEntry> getEntries() {
        HashSet hashSet = HashSetFactory.make();
        Enumeration<JarEntry> enumeration = this.file.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            hashSet.add(this.createEntry(zipEntry));
        }
        return hashSet.iterator();
    }

    public int hashCode() {
        return this.file.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JarFileModule jarFileModule = (JarFileModule)object;
        return this.file.getName().equals(jarFileModule.file.getName());
    }

    public byte[] getContents(ZipEntry zipEntry) {
        byte[] byArray = (byte[])CacheReference.get(this.cache.get(zipEntry));
        if (byArray != null) {
            return byArray;
        }
        try {
            InputStream inputStream = this.file.getInputStream(zipEntry);
            byte[] byArray2 = FileUtil.readBytes(inputStream);
            this.cache.put(zipEntry, CacheReference.make(byArray2));
            inputStream.close();
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public JarFile getJarFile() {
        return this.file;
    }
}

