/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.classLoader.BytecodeLanguage;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.LanguageImpl;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadIndirectInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAStoreIndirectInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.shrike.Exceptions;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLanguage
extends LanguageImpl
implements BytecodeLanguage,
Constants {
    private static final Collection<TypeReference> arrayAccessExceptions = Collections.unmodifiableCollection(Arrays.asList(TypeReference.JavaLangNullPointerException, TypeReference.JavaLangArrayIndexOutOfBoundsException));
    private static final Collection<TypeReference> aaStoreExceptions = Collections.unmodifiableCollection(Arrays.asList(TypeReference.JavaLangNullPointerException, TypeReference.JavaLangArrayIndexOutOfBoundsException, TypeReference.JavaLangArrayStoreException));
    private static final Collection<TypeReference> newScalarExceptions = Collections.unmodifiableCollection(Arrays.asList(TypeReference.JavaLangExceptionInInitializerError, TypeReference.JavaLangOutOfMemoryError));
    private static final Collection<TypeReference> newArrayExceptions = Collections.unmodifiableCollection(Arrays.asList(TypeReference.JavaLangOutOfMemoryError, TypeReference.JavaLangNegativeArraySizeException));
    private static final Collection<TypeReference> exceptionInInitializerError = Collections.singleton(TypeReference.JavaLangExceptionInInitializerError);
    private static final Collection<TypeReference> nullPointerException = Collections.singleton(TypeReference.JavaLangNullPointerException);
    private static final Collection<TypeReference> arithmeticException = Collections.singleton(TypeReference.JavaLangArithmeticException);
    private static final Collection<TypeReference> classCastException = Collections.singleton(TypeReference.JavaLangClassCastException);
    private static final Collection<TypeReference> classNotFoundException = Collections.singleton(TypeReference.JavaLangClassNotFoundException);
    private static final Collection<TypeReference> loadClassExceptions = Collections.singleton(TypeReference.JavaLangClassNotFoundException);
    private static final SSAInstructionFactory javaShrikeFactory = new JavaInstructionFactory();

    public JavaLanguage() {
        JavaPrimitiveType.init();
    }

    public static Collection<TypeReference> getAaStoreExceptions() {
        return aaStoreExceptions;
    }

    public static Collection<TypeReference> getArithmeticException() {
        return arithmeticException;
    }

    public static Collection<TypeReference> getArrayAccessExceptions() {
        return arrayAccessExceptions;
    }

    public static Collection<TypeReference> getClassCastException() {
        return classCastException;
    }

    public static Collection<TypeReference> getClassNotFoundException() {
        return classNotFoundException;
    }

    public static Collection<TypeReference> getNewArrayExceptions() {
        return newArrayExceptions;
    }

    public static Collection<TypeReference> getNewScalarExceptions() {
        return newScalarExceptions;
    }

    public static Collection<TypeReference> getNullPointerException() {
        return nullPointerException;
    }

    public static Collection<TypeReference> getExceptionInInitializerError() {
        return exceptionInInitializerError;
    }

    @Override
    public Atom getName() {
        return ClassLoaderReference.Java;
    }

    @Override
    public TypeReference getRootType() {
        return TypeReference.JavaLangObject;
    }

    @Override
    public TypeReference getThrowableType() {
        return TypeReference.JavaLangThrowable;
    }

    @Override
    public TypeReference getConstantType(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return TypeReference.Boolean;
        }
        if (object instanceof Long) {
            return TypeReference.Long;
        }
        if (object instanceof Double) {
            return TypeReference.Double;
        }
        if (object instanceof Float) {
            return TypeReference.Float;
        }
        if (object instanceof Number) {
            return TypeReference.Int;
        }
        if (object instanceof String) {
            return TypeReference.JavaLangString;
        }
        if (object instanceof ConstantInstruction.ClassToken || object instanceof TypeReference) {
            return TypeReference.JavaLangClass;
        }
        if (object instanceof IMethod) {
            IMethod iMethod = (IMethod)object;
            return iMethod.isInit() ? TypeReference.JavaLangReflectConstructor : TypeReference.JavaLangReflectMethod;
        }
        assert (false) : "unknown constant " + object + ": " + object.getClass();
        return null;
    }

    @Override
    public boolean isNullType(TypeReference typeReference) {
        return typeReference == null || typeReference == TypeReference.Null;
    }

    @Override
    public TypeReference[] getArrayInterfaces() {
        return new TypeReference[]{TypeReference.JavaIoSerializable, TypeReference.JavaLangCloneable};
    }

    @Override
    public TypeName lookupPrimitiveType(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<TypeReference> inferInvokeExceptions(MethodReference methodReference, IClassHierarchy iClassHierarchy) throws InvalidClassFileException {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("cha is null");
        }
        if (methodReference == null) {
            throw new IllegalArgumentException("target is null");
        }
        ArrayList<TypeReference> arrayList = new ArrayList<TypeReference>(iClassHierarchy.getJavaLangRuntimeExceptionTypes());
        arrayList.addAll(iClassHierarchy.getJavaLangErrorTypes());
        IClass iClass = iClassHierarchy.lookupClass(methodReference.getDeclaringClass());
        if (iClass == null) {
            Warnings.add(Exceptions.MethodResolutionFailure.moderate(methodReference));
        }
        if (iClass != null) {
            IMethod iMethod = iClass.getMethod(methodReference.getSelector());
            if (iMethod == null) {
                Warnings.add(Exceptions.MethodResolutionFailure.severe(methodReference));
            } else {
                TypeReference[] typeReferenceArray = iMethod.getDeclaredExceptions();
                if (typeReferenceArray != null) {
                    arrayList.addAll(Arrays.asList(typeReferenceArray));
                }
            }
        }
        return arrayList;
    }

    @Override
    public Collection<TypeReference> getImplicitExceptionTypes(IInstruction iInstruction) {
        if (iInstruction == null) {
            throw new IllegalArgumentException("pei is null");
        }
        switch (((Instruction)iInstruction).getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                return JavaLanguage.getArrayAccessExceptions();
            }
            case 83: {
                return JavaLanguage.getAaStoreExceptions();
            }
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                return JavaLanguage.getNullPointerException();
            }
            case 108: 
            case 109: 
            case 112: 
            case 113: {
                return JavaLanguage.getArithmeticException();
            }
            case 187: {
                return newScalarExceptions;
            }
            case 188: 
            case 189: 
            case 197: {
                return newArrayExceptions;
            }
            case 190: {
                return JavaLanguage.getNullPointerException();
            }
            case 191: {
                return JavaLanguage.getNullPointerException();
            }
            case 192: {
                return JavaLanguage.getClassCastException();
            }
            case 194: 
            case 195: {
                return JavaLanguage.getNullPointerException();
            }
            case 19: {
                if (((ConstantInstruction)iInstruction).getType().equals("Ljava/lang/Class;")) {
                    return JavaLanguage.getClassNotFoundException();
                }
                return null;
            }
            case 178: 
            case 179: {
                return JavaLanguage.getExceptionInInitializerError();
            }
        }
        return Collections.emptySet();
    }

    @Override
    public SSAInstructionFactory instructionFactory() {
        return javaShrikeFactory;
    }

    @Override
    public boolean isDoubleType(TypeReference typeReference) {
        return typeReference == TypeReference.Double;
    }

    @Override
    public boolean isFloatType(TypeReference typeReference) {
        return typeReference == TypeReference.Float;
    }

    @Override
    public boolean isIntType(TypeReference typeReference) {
        return typeReference == TypeReference.Int;
    }

    @Override
    public boolean isLongType(TypeReference typeReference) {
        return typeReference == TypeReference.Long;
    }

    @Override
    public boolean isVoidType(TypeReference typeReference) {
        return typeReference == TypeReference.Void;
    }

    @Override
    public boolean isMetadataType(TypeReference typeReference) {
        return typeReference == TypeReference.JavaLangClass;
    }

    @Override
    public boolean isStringType(TypeReference typeReference) {
        return typeReference == TypeReference.JavaLangString;
    }

    @Override
    public boolean isBooleanType(TypeReference typeReference) {
        return typeReference == TypeReference.Boolean;
    }

    @Override
    public boolean isCharType(TypeReference typeReference) {
        return typeReference == TypeReference.Char;
    }

    @Override
    public Object getMetadataToken(Object object) {
        if (object instanceof ConstantInstruction.ClassToken) {
            return ShrikeUtil.makeTypeReference(ClassLoaderReference.Primordial, ((ConstantInstruction.ClassToken)object).getTypeName());
        }
        assert (object instanceof TypeReference);
        return object;
    }

    @Override
    public TypeReference getPointerType(TypeReference typeReference) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Java does not permit explicit pointers");
    }

    @Override
    public TypeReference getMetadataType() {
        return TypeReference.JavaLangClass;
    }

    @Override
    public TypeReference getStringType() {
        return TypeReference.JavaLangString;
    }

    @Override
    public PrimitiveType getPrimitive(TypeReference typeReference) {
        return JavaPrimitiveType.getPrimitive(typeReference);
    }

    public static class JavaInstructionFactory
    implements SSAInstructionFactory {
        public SSAArrayLengthInstruction ArrayLengthInstruction(int n, int n2) {
            return new SSAArrayLengthInstruction(n, n2){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSAArrayLoadInstruction ArrayLoadInstruction(int n, int n2, int n3, TypeReference typeReference) {
            return new SSAArrayLoadInstruction(n, n2, n3, typeReference){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getArrayAccessExceptions();
                }
            };
        }

        public SSAArrayStoreInstruction ArrayStoreInstruction(int n, int n2, int n3, TypeReference typeReference) {
            return new SSAArrayStoreInstruction(n, n2, n3, typeReference){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (this.typeIsPrimitive()) {
                        return JavaLanguage.getArrayAccessExceptions();
                    }
                    return JavaLanguage.getAaStoreExceptions();
                }
            };
        }

        public SSABinaryOpInstruction BinaryOpInstruction(IBinaryOpInstruction.IOperator iOperator, boolean bl, boolean bl2, int n, int n2, int n3, boolean bl3) {
            assert (!bl);
            assert (!bl2);
            return new SSABinaryOpInstruction(iOperator, n, n2, n3, bl3){

                @Override
                public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
                    return sSAInstructionFactory.BinaryOpInstruction(this.getOperator(), false, false, nArray == null || nArray.length == 0 ? this.getDef(0) : nArray[0], nArray2 == null ? this.getUse(0) : nArray2[0], nArray2 == null ? this.getUse(1) : nArray2[1], this.mayBeIntegerOp());
                }

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (this.isPEI()) {
                        return JavaLanguage.getArithmeticException();
                    }
                    return Collections.emptySet();
                }
            };
        }

        public SSACheckCastInstruction CheckCastInstruction(int n, int n2, int[] nArray) {
            throw new UnsupportedOperationException();
        }

        public SSACheckCastInstruction CheckCastInstruction(int n, int n2, TypeReference[] typeReferenceArray) {
            assert (typeReferenceArray.length == 1);
            return new SSACheckCastInstruction(n, n2, typeReferenceArray){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getClassCastException();
                }
            };
        }

        public SSACheckCastInstruction CheckCastInstruction(int n, int n2, int n3) {
            return this.CheckCastInstruction(n, n2, new int[]{n3});
        }

        public SSACheckCastInstruction CheckCastInstruction(int n, int n2, TypeReference typeReference) {
            return this.CheckCastInstruction(n, n2, new TypeReference[]{typeReference});
        }

        public SSAComparisonInstruction ComparisonInstruction(IComparisonInstruction.Operator operator, int n, int n2, int n3) {
            return new SSAComparisonInstruction(operator, n, n2, n3);
        }

        public SSAConditionalBranchInstruction ConditionalBranchInstruction(IConditionalBranchInstruction.IOperator iOperator, TypeReference typeReference, int n, int n2) {
            return new SSAConditionalBranchInstruction(iOperator, typeReference, n, n2);
        }

        public SSAConversionInstruction ConversionInstruction(int n, int n2, TypeReference typeReference, TypeReference typeReference2, boolean bl) {
            assert (!bl);
            return new SSAConversionInstruction(n, n2, typeReference, typeReference2){

                public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) throws IllegalArgumentException {
                    if (nArray2 != null && nArray2.length == 0) {
                        throw new IllegalArgumentException("(uses != null) and (uses.length == 0)");
                    }
                    return sSAInstructionFactory.ConversionInstruction(nArray == null || nArray.length == 0 ? this.getDef(0) : nArray[0], nArray2 == null ? this.getUse(0) : nArray2[0], this.getFromType(), this.getToType(), false);
                }
            };
        }

        public SSAGetCaughtExceptionInstruction GetCaughtExceptionInstruction(int n, int n2) {
            return new SSAGetCaughtExceptionInstruction(n, n2);
        }

        public SSAGetInstruction GetInstruction(int n, FieldReference fieldReference) {
            return new SSAGetInstruction(n, fieldReference){};
        }

        public SSAGetInstruction GetInstruction(int n, int n2, FieldReference fieldReference) {
            return new SSAGetInstruction(n, n2, fieldReference){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSAGotoInstruction GotoInstruction() {
            return new SSAGotoInstruction();
        }

        public SSAInstanceofInstruction InstanceofInstruction(int n, int n2, TypeReference typeReference) {
            return new SSAInstanceofInstruction(n, n2, typeReference);
        }

        public SSAInvokeInstruction InvokeInstruction(int n, int[] nArray, int n2, CallSiteReference callSiteReference) {
            return new SSAInvokeInstruction(n, nArray, n2, callSiteReference){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (!this.isStatic()) {
                        return JavaLanguage.getNullPointerException();
                    }
                    return Collections.emptySet();
                }
            };
        }

        public SSAInvokeInstruction InvokeInstruction(int[] nArray, int n, CallSiteReference callSiteReference) {
            return new SSAInvokeInstruction(nArray, n, callSiteReference){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (!this.isStatic()) {
                        return JavaLanguage.getNullPointerException();
                    }
                    return Collections.emptySet();
                }
            };
        }

        public SSAMonitorInstruction MonitorInstruction(int n, boolean bl) {
            return new SSAMonitorInstruction(n, bl){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSANewInstruction NewInstruction(int n, NewSiteReference newSiteReference) {
            return new SSANewInstruction(n, newSiteReference){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (this.getNewSite().getDeclaredType().isArrayType()) {
                        return JavaLanguage.getNewArrayExceptions();
                    }
                    return JavaLanguage.getNewScalarExceptions();
                }
            };
        }

        public SSAPhiInstruction PhiInstruction(int n, int[] nArray) throws IllegalArgumentException {
            return new SSAPhiInstruction(n, nArray){};
        }

        public SSAPutInstruction PutInstruction(int n, int n2, FieldReference fieldReference) {
            return new SSAPutInstruction(n, n2, fieldReference){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSAPutInstruction PutInstruction(int n, FieldReference fieldReference) {
            return new SSAPutInstruction(n, fieldReference){};
        }

        public SSAReturnInstruction ReturnInstruction() {
            return new SSAReturnInstruction();
        }

        public SSAReturnInstruction ReturnInstruction(int n, boolean bl) {
            return new SSAReturnInstruction(n, bl);
        }

        public SSASwitchInstruction SwitchInstruction(int n, int n2, int[] nArray) {
            return new SSASwitchInstruction(n, n2, nArray);
        }

        public SSAThrowInstruction ThrowInstruction(int n) {
            return new SSAThrowInstruction(n){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSAUnaryOpInstruction UnaryOpInstruction(IUnaryOpInstruction.IOperator iOperator, int n, int n2) {
            return new SSAUnaryOpInstruction(iOperator, n, n2);
        }

        public SSALoadMetadataInstruction LoadMetadataInstruction(int n, TypeReference typeReference, Object object) {
            return new SSALoadMetadataInstruction(n, typeReference, object){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return loadClassExceptions;
                }
            };
        }

        public SSANewInstruction NewInstruction(int n, NewSiteReference newSiteReference, int[] nArray) {
            return new SSANewInstruction(n, newSiteReference, nArray){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNewArrayExceptions();
                }
            };
        }

        public SSAPiInstruction PiInstruction(int n, int n2, int n3, int n4, SSAInstruction sSAInstruction) {
            return new SSAPiInstruction(n, n2, n3, n4, sSAInstruction);
        }

        public SSAAddressOfInstruction AddressOfInstruction(int n, int n2, TypeReference typeReference) {
            throw new UnsupportedOperationException();
        }

        public SSAAddressOfInstruction AddressOfInstruction(int n, int n2, int n3, TypeReference typeReference) {
            throw new UnsupportedOperationException();
        }

        public SSAAddressOfInstruction AddressOfInstruction(int n, int n2, FieldReference fieldReference, TypeReference typeReference) {
            throw new UnsupportedOperationException();
        }

        public SSALoadIndirectInstruction LoadIndirectInstruction(int n, TypeReference typeReference, int n2) {
            throw new UnsupportedOperationException();
        }

        public SSAStoreIndirectInstruction StoreIndirectInstruction(int n, int n2, TypeReference typeReference) {
            throw new UnsupportedOperationException();
        }
    }
}

