/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileSuffixes;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedJarFileModule
implements Module {
    private static final boolean DEBUG = false;
    private final JarFileModule parent;
    private final ZipEntry entry;
    private HashMap<String, byte[]> cache = null;

    public NestedJarFileModule(JarFileModule jarFileModule, ZipEntry zipEntry) {
        this.parent = jarFileModule;
        this.entry = zipEntry;
        if (jarFileModule == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (zipEntry == null) {
            throw new IllegalArgumentException("null entry");
        }
    }

    public InputStream getInputStream(String string) {
        this.populateCache();
        byte[] byArray = this.cache.get(string);
        return new ByteArrayInputStream(byArray);
    }

    private void populateCache() {
        if (this.cache != null) {
            return;
        }
        this.cache = HashMapFactory.make();
        byte[] byArray = this.parent.getContents(this.entry);
        try {
            JarInputStream jarInputStream = new JarInputStream(new ByteArrayInputStream(byArray));
            ZipEntry zipEntry = jarInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                if (FileSuffixes.isClassFile(string) || FileSuffixes.isSourceFile(string)) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[1024];
                    int n = jarInputStream.read(byArray2);
                    while (n != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                        n = jarInputStream.read(byArray2);
                    }
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    this.cache.put(string, byArray3);
                }
                zipEntry = jarInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            Warnings.add(new Warning(){

                public String getMsg() {
                    return "could not read contents of nested jar file " + NestedJarFileModule.this.entry.getName() + ", parent " + NestedJarFileModule.this.parent.getAbsolutePath();
                }
            });
        }
    }

    protected long getEntrySize(String string) {
        this.populateCache();
        byte[] byArray = this.cache.get(string);
        return byArray.length;
    }

    @Override
    public Iterator<ModuleEntry> getEntries() {
        this.populateCache();
        final Iterator<String> iterator = this.cache.keySet().iterator();
        return new Iterator<ModuleEntry>(){
            String next = null;
            {
                this.advance();
            }

            private void advance() {
                this.next = iterator.hasNext() ? (String)iterator.next() : null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ModuleEntry next() {
                Entry entry = new Entry(this.next);
                this.advance();
                return entry;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public String toString() {
        return "Nested Jar File:" + this.entry.getName();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.parent == null ? 0 : this.parent.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NestedJarFileModule nestedJarFileModule = (NestedJarFileModule)object;
        return !(this.parent == null ? nestedJarFileModule.parent != null : !this.parent.equals(nestedJarFileModule.parent));
    }

    private class Entry
    implements ModuleEntry {
        private final String name;

        Entry(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public boolean isClassFile() {
            return FileSuffixes.isClassFile(this.getName());
        }

        public InputStream getInputStream() {
            return NestedJarFileModule.this.getInputStream(this.name);
        }

        public boolean isModuleFile() {
            return false;
        }

        public Module asModule() {
            Assertions.UNREACHABLE();
            return null;
        }

        public String toString() {
            return "nested entry: " + this.name;
        }

        public String getClassName() {
            return FileSuffixes.stripSuffix(this.getName());
        }

        public boolean isSourceFile() {
            return FileSuffixes.isSourceFile(this.getName());
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            if (!this.getOuterType().equals(entry.getOuterType())) {
                return false;
            }
            return !(this.name == null ? entry.name != null : !this.name.equals(entry.name));
        }

        private NestedJarFileModule getOuterType() {
            return NestedJarFileModule.this;
        }
    }
}

