/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.BytecodeLanguage;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.ITypeTestInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.bytecode.BytecodeStream;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShrikeBTMethod
implements IMethod,
BytecodeConstants {
    private static final boolean verbose = false;
    private static int methodsParsed = 0;
    protected final IClass declaringClass;
    private MethodReference methodReference;
    private SoftReference<BytecodeInfo> bcInfo;

    public ShrikeBTMethod(IClass iClass) {
        this.declaringClass = iClass;
    }

    protected BytecodeInfo getBCInfo() throws InvalidClassFileException {
        BytecodeInfo bytecodeInfo = null;
        if (this.bcInfo != null) {
            bytecodeInfo = this.bcInfo.get();
        }
        if (bytecodeInfo == null) {
            bytecodeInfo = this.computeBCInfo();
            this.bcInfo = new SoftReference<BytecodeInfo>(bytecodeInfo);
        }
        return bytecodeInfo;
    }

    public int getBytecodeIndex(int n) throws InvalidClassFileException {
        return this.getBCInfo().pcMap[n];
    }

    public int getNumShrikeInstructions() throws InvalidClassFileException {
        return this.getBCInfo().pcMap.length;
    }

    public Collection<CallSiteReference> getCallSites() throws InvalidClassFileException {
        Set<CallSiteReference> set = Collections.emptySet();
        if (this.isNative()) {
            return set;
        }
        return this.getBCInfo().callSites == null ? set : Collections.unmodifiableCollection(Arrays.asList(this.getBCInfo().callSites));
    }

    Collection<NewSiteReference> getNewSites() throws InvalidClassFileException {
        Set<NewSiteReference> set = Collections.emptySet();
        if (this.isNative()) {
            return set;
        }
        return this.getBCInfo().newSites == null ? set : Collections.unmodifiableCollection(Arrays.asList(this.getBCInfo().newSites));
    }

    public Collection<TypeReference> getImplicitExceptionTypes() throws InvalidClassFileException {
        if (this.isNative()) {
            return Collections.emptySet();
        }
        return this.getBCInfo().implicitExceptions == null ? Arrays.asList(new TypeReference[0]) : Arrays.asList(this.getBCInfo().implicitExceptions);
    }

    private BytecodeInfo computeBCInfo() throws InvalidClassFileException {
        BytecodeInfo bytecodeInfo = new BytecodeInfo();
        bytecodeInfo.exceptionTypes = this.computeDeclaredExceptions();
        if (this.isNative()) {
            return bytecodeInfo;
        }
        this.processBytecodesWithShrikeBT(bytecodeInfo);
        return bytecodeInfo;
    }

    public boolean hasMonitorOp() throws InvalidClassFileException {
        if (this.isNative()) {
            return false;
        }
        return this.getBCInfo().hasMonitorOp;
    }

    public Iterator<FieldReference> getFieldsWritten() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        if (this.getBCInfo().fieldsWritten == null) {
            return EmptyIterator.instance();
        }
        List<FieldReference> list = Arrays.asList(this.getBCInfo().fieldsWritten);
        return list.iterator();
    }

    public Iterator<FieldReference> getFieldsRead() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        if (this.getBCInfo().fieldsRead == null) {
            return EmptyIterator.instance();
        }
        List<FieldReference> list = Arrays.asList(this.getBCInfo().fieldsRead);
        return list.iterator();
    }

    public Iterator getArraysRead() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        return this.getBCInfo().arraysRead == null ? EmptyIterator.instance() : Arrays.asList(this.getBCInfo().arraysRead).iterator();
    }

    public Iterator<TypeReference> getArraysWritten() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        if (this.getBCInfo().fieldsRead == null) {
            return EmptyIterator.instance();
        }
        List<TypeReference> list = Arrays.asList(this.getBCInfo().arraysWritten);
        return list.iterator();
    }

    public Iterator getCastTypes() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        return this.getBCInfo().castTypes == null ? EmptyIterator.instance() : Arrays.asList(this.getBCInfo().castTypes).iterator();
    }

    protected abstract byte[] getBytecodes();

    public BytecodeStream getBytecodeStream() {
        byte[] byArray = this.getBytecodes();
        if (byArray == null) {
            return null;
        }
        return new BytecodeStream(this, byArray);
    }

    protected abstract String getMethodName() throws InvalidClassFileException;

    protected abstract String getMethodSignature() throws InvalidClassFileException;

    private MethodReference computeMethodReference() {
        try {
            Atom atom = Atom.findOrCreateUnicodeAtom(this.getMethodName());
            ImmutableByteArray immutableByteArray = ImmutableByteArray.make(this.getMethodSignature());
            Descriptor descriptor = Descriptor.findOrCreate(this.declaringClass.getClassLoader().getLanguage(), immutableByteArray);
            return MethodReference.findOrCreate(this.declaringClass.getReference(), atom, descriptor);
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public MethodReference getReference() {
        if (this.methodReference == null) {
            this.methodReference = this.computeMethodReference();
        }
        return this.methodReference;
    }

    @Override
    public boolean isClinit() {
        return this.getReference().getSelector().equals(MethodReference.clinitSelector);
    }

    @Override
    public boolean isInit() {
        return this.getReference().getName().equals(MethodReference.initAtom);
    }

    protected abstract int getModifiers();

    @Override
    public boolean isNative() {
        return (this.getModifiers() & 0x100) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    @Override
    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    @Override
    public boolean isSynchronized() {
        return (this.getModifiers() & 0x20) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public IClass getDeclaringClass() {
        return this.declaringClass;
    }

    protected abstract Decoder makeDecoder();

    protected abstract void processDebugInfo(BytecodeInfo var1) throws InvalidClassFileException;

    private void processBytecodesWithShrikeBT(BytecodeInfo bytecodeInfo) throws InvalidClassFileException {
        bytecodeInfo.decoder = this.makeDecoder();
        if (!this.isAbstract() && bytecodeInfo.decoder == null) {
            Assertions.UNREACHABLE("bad method " + this.getReference());
        }
        if (bytecodeInfo.decoder == null) {
            return;
        }
        bytecodeInfo.pcMap = bytecodeInfo.decoder.getInstructionsToBytecodes();
        this.processDebugInfo(bytecodeInfo);
        SimpleVisitor simpleVisitor = new SimpleVisitor(bytecodeInfo);
        BytecodeLanguage bytecodeLanguage = (BytecodeLanguage)this.getDeclaringClass().getClassLoader().getLanguage();
        IInstruction[] iInstructionArray = bytecodeInfo.decoder.getInstructions();
        int n = 0;
        while (n < iInstructionArray.length) {
            Collection<TypeReference> collection;
            simpleVisitor.setInstructionIndex(n);
            iInstructionArray[n].visit((IInstruction.Visitor)simpleVisitor);
            if (iInstructionArray[n].isPEI() && (collection = bytecodeLanguage.getImplicitExceptionTypes(iInstructionArray[n])) != null) {
                simpleVisitor.implicitExceptions.addAll(collection);
            }
            ++n;
        }
        this.copyVisitorSetsToArrays(simpleVisitor, bytecodeInfo);
    }

    private void copyVisitorSetsToArrays(SimpleVisitor simpleVisitor, BytecodeInfo bytecodeInfo) {
        bytecodeInfo.newSites = new NewSiteReference[simpleVisitor.newSites.size()];
        int n = 0;
        Iterator<Object> iterator = simpleVisitor.newSites.iterator();
        while (iterator.hasNext()) {
            bytecodeInfo.newSites[n++] = iterator.next();
        }
        bytecodeInfo.fieldsRead = new FieldReference[simpleVisitor.fieldsRead.size()];
        n = 0;
        iterator = simpleVisitor.fieldsRead.iterator();
        while (iterator.hasNext()) {
            bytecodeInfo.fieldsRead[n++] = (FieldReference)iterator.next();
        }
        bytecodeInfo.fieldsRead = new FieldReference[simpleVisitor.fieldsRead.size()];
        n = 0;
        iterator = simpleVisitor.fieldsRead.iterator();
        while (iterator.hasNext()) {
            bytecodeInfo.fieldsRead[n++] = (FieldReference)iterator.next();
        }
        bytecodeInfo.fieldsWritten = new FieldReference[simpleVisitor.fieldsWritten.size()];
        n = 0;
        iterator = simpleVisitor.fieldsWritten.iterator();
        while (iterator.hasNext()) {
            bytecodeInfo.fieldsWritten[n++] = (FieldReference)iterator.next();
        }
        bytecodeInfo.callSites = new CallSiteReference[simpleVisitor.callSites.size()];
        n = 0;
        iterator = simpleVisitor.callSites.iterator();
        while (iterator.hasNext()) {
            bytecodeInfo.callSites[n++] = (CallSiteReference)iterator.next();
        }
        bytecodeInfo.arraysRead = new TypeReference[simpleVisitor.arraysRead.size()];
        n = 0;
        iterator = simpleVisitor.arraysRead.iterator();
        while (iterator.hasNext()) {
            bytecodeInfo.arraysRead[n++] = (TypeReference)iterator.next();
        }
        bytecodeInfo.arraysWritten = new TypeReference[simpleVisitor.arraysWritten.size()];
        n = 0;
        iterator = simpleVisitor.arraysWritten.iterator();
        while (iterator.hasNext()) {
            bytecodeInfo.arraysWritten[n++] = (TypeReference)iterator.next();
        }
        bytecodeInfo.implicitExceptions = new TypeReference[simpleVisitor.implicitExceptions.size()];
        n = 0;
        iterator = simpleVisitor.implicitExceptions.iterator();
        while (iterator.hasNext()) {
            bytecodeInfo.implicitExceptions[n++] = (TypeReference)iterator.next();
        }
        bytecodeInfo.castTypes = new TypeReference[simpleVisitor.castTypes.size()];
        n = 0;
        iterator = simpleVisitor.castTypes.iterator();
        while (iterator.hasNext()) {
            bytecodeInfo.castTypes[n++] = (TypeReference)iterator.next();
        }
        bytecodeInfo.hasMonitorOp = simpleVisitor.hasMonitorOp;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ShrikeBTMethod) {
            ShrikeBTMethod shrikeBTMethod = (ShrikeBTMethod)object;
            return this.getDeclaringClass().equals(shrikeBTMethod.getDeclaringClass()) && this.getReference().equals(shrikeBTMethod.getReference());
        }
        return false;
    }

    public int hashCode() {
        return 9661 * this.getReference().hashCode();
    }

    @Override
    public abstract int getMaxLocals();

    @Override
    public abstract int getMaxStackHeight();

    @Override
    public Atom getName() {
        return this.getReference().getName();
    }

    @Override
    public Descriptor getDescriptor() {
        return this.getReference().getDescriptor();
    }

    public IInstruction[] getInstructions() throws InvalidClassFileException {
        if (this.getBCInfo().decoder == null) {
            return null;
        }
        return this.getBCInfo().decoder.getInstructions();
    }

    public ExceptionHandler[][] getHandlers() throws InvalidClassFileException {
        if (this.getBCInfo().decoder == null) {
            return null;
        }
        return this.getBCInfo().decoder.getHandlers();
    }

    @Override
    public TypeReference getParameterType(int n) {
        if (!this.isStatic()) {
            if (n == 0) {
                return this.declaringClass.getReference();
            }
            return this.getReference().getParameterType(n - 1);
        }
        return this.getReference().getParameterType(n);
    }

    @Override
    public int getNumberOfParameters() {
        if (this.isStatic() || this.isClinit()) {
            return this.getReference().getNumberOfParameters();
        }
        return this.getReference().getNumberOfParameters() + 1;
    }

    @Override
    public abstract boolean hasExceptionHandler();

    @Override
    public TypeReference[] getDeclaredExceptions() throws InvalidClassFileException {
        return this.getBCInfo().exceptionTypes == null ? new TypeReference[]{} : this.getBCInfo().exceptionTypes;
    }

    protected abstract String[] getDeclaredExceptionTypeNames() throws InvalidClassFileException;

    private TypeReference[] computeDeclaredExceptions() {
        String[] stringArray;
        block4: {
            stringArray = this.getDeclaredExceptionTypeNames();
            if (stringArray != null) break block4;
            return null;
        }
        try {
            ClassLoaderReference classLoaderReference = this.getDeclaringClass().getClassLoader().getReference();
            TypeReference[] typeReferenceArray = new TypeReference[stringArray.length];
            int n = 0;
            while (n < typeReferenceArray.length) {
                typeReferenceArray[n] = TypeReference.findOrCreate(classLoaderReference, TypeName.findOrCreate(ImmutableByteArray.make("L" + stringArray[n])));
                ++n;
            }
            return typeReferenceArray;
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public int getLineNumber(int n) {
        try {
            return this.getBCInfo().lineNumberMap == null ? -1 : this.getBCInfo().lineNumberMap[n];
        }
        catch (InvalidClassFileException invalidClassFileException) {
            return -1;
        }
    }

    public Set<TypeReference> getCaughtExceptionTypes() throws InvalidClassFileException {
        ExceptionHandler[][] exceptionHandlerArray = this.getHandlers();
        if (exceptionHandlerArray == null) {
            return Collections.emptySet();
        }
        HashSet<TypeReference> hashSet = HashSetFactory.make(10);
        ClassLoaderReference classLoaderReference = this.getReference().getDeclaringClass().getClassLoader();
        int n = 0;
        while (n < exceptionHandlerArray.length) {
            int n2 = 0;
            while (n2 < exceptionHandlerArray[n].length) {
                TypeReference typeReference = ShrikeUtil.makeTypeReference(classLoaderReference, exceptionHandlerArray[n][n2].getCatchClass());
                if (typeReference == null) {
                    typeReference = TypeReference.JavaLangThrowable;
                }
                hashSet.add(typeReference);
                ++n2;
            }
            ++n;
        }
        return hashSet;
    }

    @Override
    public String getSignature() {
        return this.getReference().getSignature();
    }

    @Override
    public Selector getSelector() {
        return this.getReference().getSelector();
    }

    @Override
    public abstract String getLocalVariableName(int var1, int var2);

    @Override
    public abstract boolean hasLocalVariableTable();

    public void clearCaches() {
        this.bcInfo = null;
    }

    protected static class BytecodeInfo {
        Decoder decoder;
        CallSiteReference[] callSites;
        FieldReference[] fieldsWritten;
        FieldReference[] fieldsRead;
        NewSiteReference[] newSites;
        TypeReference[] arraysRead;
        TypeReference[] arraysWritten;
        TypeReference[] implicitExceptions;
        TypeReference[] castTypes;
        boolean hasMonitorOp;
        private int[] pcMap;
        protected int[] lineNumberMap;
        protected int[][] localVariableMap;
        private TypeReference[] exceptionTypes;

        protected BytecodeInfo() {
        }
    }

    private class SimpleVisitor
    extends IInstruction.Visitor {
        private final BytecodeInfo info;
        final Set<CallSiteReference> callSites = HashSetFactory.make(5);
        final Set<FieldReference> fieldsWritten = HashSetFactory.make(5);
        final Set<FieldReference> fieldsRead = HashSetFactory.make(5);
        final Set<NewSiteReference> newSites = HashSetFactory.make(5);
        final Set<TypeReference> arraysRead = HashSetFactory.make(5);
        final Set<TypeReference> arraysWritten = HashSetFactory.make(5);
        final Set<TypeReference> implicitExceptions = HashSetFactory.make(5);
        final Set<TypeReference> castTypes = HashSetFactory.make(5);
        boolean hasMonitorOp;
        private int instructionIndex;

        public SimpleVisitor(BytecodeInfo bytecodeInfo) {
            this.info = bytecodeInfo;
        }

        public void setInstructionIndex(int n) {
            this.instructionIndex = n;
        }

        public int getProgramCounter() throws InvalidClassFileException {
            return this.info.pcMap[this.instructionIndex];
        }

        public void visitMonitor(MonitorInstruction monitorInstruction) {
            this.hasMonitorOp = true;
        }

        public void visitNew(NewInstruction newInstruction) {
            ClassLoaderReference classLoaderReference = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            TypeReference typeReference = ShrikeUtil.makeTypeReference(classLoaderReference, newInstruction.getType());
            try {
                this.newSites.add(NewSiteReference.make(this.getProgramCounter(), typeReference));
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }

        public void visitGet(IGetInstruction iGetInstruction) {
            ClassLoaderReference classLoaderReference = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            FieldReference fieldReference = FieldReference.findOrCreate(classLoaderReference, iGetInstruction.getClassType(), iGetInstruction.getFieldName(), iGetInstruction.getFieldType());
            this.fieldsRead.add(fieldReference);
        }

        public void visitPut(IPutInstruction iPutInstruction) {
            ClassLoaderReference classLoaderReference = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            FieldReference fieldReference = FieldReference.findOrCreate(classLoaderReference, iPutInstruction.getClassType(), iPutInstruction.getFieldName(), iPutInstruction.getFieldType());
            this.fieldsWritten.add(fieldReference);
        }

        public void visitInvoke(IInvokeInstruction iInvokeInstruction) {
            IClassLoader iClassLoader = ShrikeBTMethod.this.getDeclaringClass().getClassLoader();
            MethodReference methodReference = MethodReference.findOrCreate(iClassLoader.getLanguage(), iClassLoader.getReference(), iInvokeInstruction.getClassType(), iInvokeInstruction.getMethodName(), iInvokeInstruction.getMethodSignature());
            int n = 0;
            try {
                n = this.getProgramCounter();
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            CallSiteReference callSiteReference = null;
            callSiteReference = CallSiteReference.make(n, methodReference, iInvokeInstruction.getInvocationCode());
            this.callSites.add(callSiteReference);
        }

        public void visitArrayLoad(IArrayLoadInstruction iArrayLoadInstruction) {
            this.arraysRead.add(ShrikeUtil.makeTypeReference(ShrikeBTMethod.this.getDeclaringClass().getClassLoader().getReference(), iArrayLoadInstruction.getType()));
        }

        public void visitArrayStore(IArrayStoreInstruction iArrayStoreInstruction) {
            this.arraysWritten.add(ShrikeUtil.makeTypeReference(ShrikeBTMethod.this.getDeclaringClass().getClassLoader().getReference(), iArrayStoreInstruction.getType()));
        }

        public void visitCheckCast(ITypeTestInstruction iTypeTestInstruction) {
            String[] stringArray = iTypeTestInstruction.getTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                this.castTypes.add(ShrikeUtil.makeTypeReference(ShrikeBTMethod.this.getDeclaringClass().getClassLoader().getReference(), string));
                ++n2;
            }
        }
    }
}

