/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.ShrikeBTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.IndirectionData;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.ExceptionsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableReader;
import com.ibm.wala.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrikeCT.RuntimeInvisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.RuntimeVisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.generics.MethodTypeSignature;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShrikeCTMethod
extends ShrikeBTMethod
implements IBytecodeMethod {
    private final int shrikeMethodIndex;
    private int modifiers = -1;
    private final IClassHierarchy cha;
    private static final IndirectionData NO_INDIRECTIONS = new IndirectionData(){
        private final int[] NOTHING = new int[0];

        public int[] indirectlyReadLocals(int n) {
            return this.NOTHING;
        }

        public int[] indirectlyWrittenLocals(int n) {
            return this.NOTHING;
        }
    };

    public ShrikeCTMethod(IClass iClass, int n) {
        super(iClass);
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        this.shrikeMethodIndex = n;
        this.cha = iClass.getClassHierarchy();
    }

    @Override
    public byte[] getBytecodes() {
        CodeReader codeReader = this.getCodeReader();
        if (codeReader == null) {
            return null;
        }
        return codeReader.getBytecode();
    }

    @Override
    protected String getMethodName() throws InvalidClassFileException {
        ClassReader classReader = this.getClassReader();
        return classReader.getMethodName(this.shrikeMethodIndex);
    }

    @Override
    protected String getMethodSignature() throws InvalidClassFileException {
        ClassReader classReader = this.getClassReader();
        return classReader.getMethodType(this.shrikeMethodIndex);
    }

    @Override
    protected int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = this.getClassReader().getMethodAccessFlags(this.shrikeMethodIndex);
        }
        return this.modifiers;
    }

    @Override
    protected Decoder makeDecoder() {
        CodeReader codeReader = this.getCodeReader();
        if (codeReader == null) {
            return null;
        }
        CTDecoder cTDecoder = new CTDecoder(codeReader);
        try {
            cTDecoder.decode();
        }
        catch (Decoder.InvalidBytecodeException invalidBytecodeException) {
            Assertions.UNREACHABLE();
        }
        return cTDecoder;
    }

    @Override
    public int getMaxLocals() {
        CodeReader codeReader = this.getCodeReader();
        return codeReader.getMaxLocals();
    }

    @Override
    public int getMaxStackHeight() {
        CodeReader codeReader = this.getCodeReader();
        return codeReader.getMaxStack() + 2;
    }

    @Override
    public boolean hasExceptionHandler() {
        CodeReader codeReader = this.getCodeReader();
        if (codeReader == null) {
            return false;
        }
        int[] nArray = codeReader.getRawHandlers();
        return nArray != null && nArray.length > 0;
    }

    @Override
    protected String[] getDeclaredExceptionTypeNames() throws InvalidClassFileException {
        ExceptionsReader exceptionsReader = this.getExceptionReader();
        if (exceptionsReader == null) {
            return null;
        }
        return exceptionsReader.getClasses();
    }

    @Override
    protected void processDebugInfo(ShrikeBTMethod.BytecodeInfo bytecodeInfo) throws InvalidClassFileException {
        CodeReader codeReader = this.getCodeReader();
        bytecodeInfo.lineNumberMap = LineNumberTableReader.makeBytecodeToSourceMap((CodeReader)codeReader);
        bytecodeInfo.localVariableMap = LocalVariableTableReader.makeVarMap((CodeReader)codeReader);
    }

    @Override
    public String getLocalVariableName(int n, int n2) {
        int[][] nArray = null;
        try {
            nArray = this.getBCInfo().localVariableMap;
        }
        catch (InvalidClassFileException invalidClassFileException) {
            return null;
        }
        if (n2 > this.getMaxLocals()) {
            throw new IllegalArgumentException("illegal local number: " + n2 + ", method " + this.getName() + " uses at most " + this.getMaxLocals());
        }
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = nArray[n];
        int n3 = n2 * 2;
        if (nArray2 == null || n3 >= nArray2.length) {
            return null;
        }
        int n4 = nArray2[n3];
        if (n4 == 0) {
            return null;
        }
        try {
            return this.getClassReader().getCP().getCPUtf8(n4);
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasLocalVariableTable() {
        try {
            ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
            this.getCodeReader().initAttributeIterator(attrIterator);
            while (true) {
                if (!attrIterator.isValid()) {
                    return false;
                }
                if (attrIterator.getName().equals("LocalVariableTable")) {
                    return true;
                }
                attrIterator.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
            Assertions.UNREACHABLE();
            return false;
        }
    }

    private ClassReader getClassReader() {
        return ((ShrikeClass)this.getDeclaringClass()).getReader();
    }

    private CodeReader getCodeReader() {
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, attrIterator);
        CodeReader codeReader = null;
        try {
            while (attrIterator.isValid()) {
                if (attrIterator.getName().equals("Code")) {
                    codeReader = new CodeReader(attrIterator);
                    break;
                }
                attrIterator.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
        return codeReader;
    }

    private ExceptionsReader getExceptionReader() {
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, attrIterator);
        ExceptionsReader exceptionsReader = null;
        try {
            while (attrIterator.isValid()) {
                if (attrIterator.getName().equals("Exceptions")) {
                    exceptionsReader = new ExceptionsReader(attrIterator);
                    break;
                }
                attrIterator.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
        return exceptionsReader;
    }

    private SignatureReader getSignatureReader() {
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, attrIterator);
        SignatureReader signatureReader = null;
        try {
            while (attrIterator.isValid()) {
                if (attrIterator.getName().equals("Signature")) {
                    signatureReader = new SignatureReader(attrIterator);
                    break;
                }
                attrIterator.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
        return signatureReader;
    }

    private AnnotationsReader getAnnotationsReader(boolean bl) {
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, attrIterator);
        RuntimeInvisibleAnnotationsReader runtimeInvisibleAnnotationsReader = null;
        try {
            while (attrIterator.isValid()) {
                if (bl) {
                    if (attrIterator.getName().equals("RuntimeInvisibleAnnotations")) {
                        runtimeInvisibleAnnotationsReader = new RuntimeInvisibleAnnotationsReader(attrIterator);
                        break;
                    }
                } else if (attrIterator.getName().equals("RuntimeVisibleAnnotations")) {
                    runtimeInvisibleAnnotationsReader = new RuntimeVisibleAnnotationsReader(attrIterator);
                    break;
                }
                attrIterator.advance();
            }
        }
        catch (InvalidClassFileException invalidClassFileException) {
            Assertions.UNREACHABLE();
        }
        return runtimeInvisibleAnnotationsReader;
    }

    private String computeGenericsSignature() throws InvalidClassFileException {
        SignatureReader signatureReader = this.getSignatureReader();
        if (signatureReader == null) {
            return null;
        }
        return signatureReader.getSignature();
    }

    @Override
    public TypeReference getReturnType() {
        return this.getReference().getReturnType();
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    private String getGenericsSignature() throws InvalidClassFileException {
        return this.computeGenericsSignature();
    }

    public MethodTypeSignature getMethodTypeSignature() throws InvalidClassFileException {
        String string = this.getGenericsSignature();
        return string == null ? null : MethodTypeSignature.make(string);
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations() throws InvalidClassFileException, AnnotationsReader.UnimplementedException {
        return this.getAnnotations(true);
    }

    public Collection<Annotation> getRuntimeVisibleAnnotations() throws InvalidClassFileException, AnnotationsReader.UnimplementedException {
        return this.getAnnotations(false);
    }

    public Collection<Annotation> getAnnotations(boolean bl) throws InvalidClassFileException, AnnotationsReader.UnimplementedException {
        AnnotationsReader annotationsReader = this.getAnnotationsReader(bl);
        if (annotationsReader != null) {
            int[] nArray = annotationsReader.getAnnotationOffsets();
            HashSet<Annotation> hashSet = HashSetFactory.make();
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray2[n2];
                String string = annotationsReader.getAnnotationType(n3);
                string = string.replaceAll(";", "");
                TypeReference typeReference = TypeReference.findOrCreate(this.getDeclaringClass().getClassLoader().getReference(), string);
                hashSet.add(Annotation.make(typeReference));
                ++n2;
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    public HashMap<String, String> getAnnotations(int n) {
        int[] nArray;
        AnnotationsReader annotationsReader = this.getAnnotationsReader(true);
        if (annotationsReader == null) {
            return null;
        }
        try {
            nArray = annotationsReader.getAnnotationOffsets();
            if (nArray.length <= n) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        int n2 = nArray[n];
        HashMap hashMap = annotationsReader.getAnnotationValues(n2);
        return hashMap;
    }

    @Override
    public IndirectionData getIndirectionData() {
        return NO_INDIRECTIONS;
    }
}

