/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.bytecode.BytecodeStream;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.strings.Atom;

public class SyntheticMethod
implements IMethod {
    public static final SSAInstruction[] NO_STATEMENTS = new SSAInstruction[0];
    private final MethodReference method;
    protected final IMethod resolvedMethod;
    protected final IClass declaringClass;
    private final boolean isStatic;
    private final boolean isFactory;

    public SyntheticMethod(MethodReference methodReference, IClass iClass, boolean bl, boolean bl2) {
        if (methodReference == null) {
            throw new IllegalArgumentException("null method");
        }
        this.method = methodReference;
        this.resolvedMethod = null;
        this.declaringClass = iClass;
        this.isStatic = bl;
        this.isFactory = bl2;
    }

    public SyntheticMethod(IMethod iMethod, IClass iClass, boolean bl, boolean bl2) {
        if (iMethod == null) {
            throw new IllegalArgumentException("null method");
        }
        this.resolvedMethod = iMethod;
        this.method = this.resolvedMethod.getReference();
        this.declaringClass = iClass;
        this.isStatic = bl;
        this.isFactory = bl2;
    }

    public boolean isClinit() {
        return this.method.getSelector().equals(MethodReference.clinitSelector);
    }

    public boolean isInit() {
        return this.method.getSelector().equals(MethodReference.initSelector);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isNative() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPublic() {
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public boolean isBridge() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public boolean isSynthetic() {
        return true;
    }

    public MethodReference getReference() {
        return this.method;
    }

    public InducedCFG makeControlFlowGraph(SSAInstruction[] sSAInstructionArray) {
        return new InducedCFG(sSAInstructionArray, this, Everywhere.EVERYWHERE);
    }

    public BytecodeStream getBytecodeStream() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getMaxLocals() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getMaxStackHeight() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public IClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("synthetic ");
        if (this.isFactoryMethod()) {
            stringBuffer.append(" factory ");
        }
        stringBuffer.append(this.method.toString());
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        n = 31 * n + (this.method == null ? 0 : this.method.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SyntheticMethod syntheticMethod = (SyntheticMethod)object;
        if (this.declaringClass == null ? syntheticMethod.declaringClass != null : !this.declaringClass.equals(syntheticMethod.declaringClass)) {
            return false;
        }
        return !(this.method == null ? syntheticMethod.method != null : !this.method.equals(syntheticMethod.method));
    }

    public boolean hasExceptionHandler() {
        return false;
    }

    public boolean hasPoison() {
        return false;
    }

    public String getPoison() {
        return null;
    }

    public byte getPoisonLevel() {
        return -1;
    }

    @Deprecated
    public SSAInstruction[] getStatements(SSAOptions sSAOptions) {
        return NO_STATEMENTS;
    }

    public IR makeIR(Context context, SSAOptions sSAOptions) throws UnimplementedError {
        throw new UnimplementedError("haven't implemented IR yet for class " + this.getClass());
    }

    public TypeReference getParameterType(int n) {
        if (this.isStatic()) {
            return this.method.getParameterType(n);
        }
        if (n == 0) {
            return this.method.getDeclaringClass();
        }
        return this.method.getParameterType(n - 1);
    }

    public int getNumberOfParameters() {
        int n = this.method.getNumberOfParameters();
        return this.isStatic() ? n : n + 1;
    }

    public TypeReference[] getDeclaredExceptions() throws InvalidClassFileException {
        if (this.resolvedMethod == null) {
            return null;
        }
        return this.resolvedMethod.getDeclaredExceptions();
    }

    public Atom getName() {
        return this.method.getSelector().getName();
    }

    public Descriptor getDescriptor() {
        return this.method.getSelector().getDescriptor();
    }

    public int getLineNumber(int n) {
        return -1;
    }

    public boolean isFactoryMethod() {
        return this.isFactory;
    }

    public String getSignature() {
        return this.getReference().getSignature();
    }

    public Selector getSelector() {
        return this.getReference().getSelector();
    }

    public String getLocalVariableName(int n, int n2) {
        return null;
    }

    public boolean hasLocalVariableTable() {
        return false;
    }

    public SSAInstruction[] getStatements() {
        return this.getStatements(SSAOptions.defaultOptions());
    }

    public TypeReference getReturnType() {
        return this.getReference().getReturnType();
    }

    public IClassHierarchy getClassHierarchy() {
        return this.getDeclaringClass().getClassHierarchy();
    }
}

