/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;

public class CallFlowEdges {
    private final SparseVector<IBinaryNaturalRelation> edges = new SparseVector(1, 1.1f);
    private final SparseVector<IntSet> identityEdges = new SparseVector(1, 1.1f);

    public void addCallEdge(int n, int n2, int n3) {
        if (n2 == n3) {
            BimodalMutableIntSet bimodalMutableIntSet = (BimodalMutableIntSet)this.identityEdges.get(n2);
            if (bimodalMutableIntSet == null) {
                bimodalMutableIntSet = new BimodalMutableIntSet();
                this.identityEdges.set(n2, bimodalMutableIntSet);
            }
            bimodalMutableIntSet.add(n);
        } else {
            IBinaryNaturalRelation iBinaryNaturalRelation = this.edges.get(n3);
            if (iBinaryNaturalRelation == null) {
                iBinaryNaturalRelation = new BasicNaturalRelation(new byte[]{1}, 1);
                this.edges.set(n3, iBinaryNaturalRelation);
            }
            iBinaryNaturalRelation.add(n, n2);
        }
    }

    public IntSet getCallFlowSources(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid c : " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid d2: " + n2);
        }
        IntSet intSet = this.identityEdges.get(n2);
        IBinaryNaturalRelation iBinaryNaturalRelation = this.edges.get(n2);
        IntSet intSet2 = null;
        if (iBinaryNaturalRelation == null) {
            if (intSet != null) {
                intSet2 = intSet.contains(n) ? SparseIntSet.singleton(n2) : null;
            }
        } else if (intSet == null) {
            intSet2 = iBinaryNaturalRelation.getRelated(n);
        } else if (intSet.contains(n)) {
            if (iBinaryNaturalRelation.getRelated(n) == null) {
                intSet2 = SparseIntSet.singleton(n2);
            } else {
                intSet2 = MutableSparseIntSet.make(iBinaryNaturalRelation.getRelated(n));
                ((MutableSparseIntSet)intSet2).add(n2);
            }
        } else {
            intSet2 = iBinaryNaturalRelation.getRelated(n);
        }
        return intSet2;
    }

    public IntSet getCallFlowSourceNodes(int n) {
        IntSet intSet = this.identityEdges.get(n);
        IBinaryNaturalRelation iBinaryNaturalRelation = this.edges.get(n);
        IntSet intSet2 = null;
        if (iBinaryNaturalRelation == null) {
            if (intSet != null) {
                intSet2 = intSet;
            }
        } else if (intSet == null) {
            intSet2 = this.getDomain(iBinaryNaturalRelation);
        } else {
            intSet2 = MutableSparseIntSet.make(intSet);
            ((MutableSparseIntSet)intSet2).addAll(this.getDomain(iBinaryNaturalRelation));
        }
        return intSet2;
    }

    private IntSet getDomain(IBinaryNaturalRelation iBinaryNaturalRelation) {
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        int n = iBinaryNaturalRelation.maxKeyValue();
        int n2 = 0;
        while (n2 <= n) {
            if (iBinaryNaturalRelation.getRelated(n2) != null) {
                mutableSparseIntSet.add(n2);
            }
            ++n2;
        }
        return mutableSparseIntSet;
    }
}

