/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseLongIntVector;
import com.ibm.wala.util.math.LongUtil;

public class LocalSummaryEdges {
    private final SparseVector<IBinaryNaturalRelation> summaries = new SparseVector(1, 1.1f);
    private static final int UNASSIGNED = -1;
    private final SparseLongIntVector entryExitMap = new SparseLongIntVector(-1);
    private int nextEntryExitIndex = 0;

    public void insertSummaryEdge(int n, int n2, int n3, int n4) {
        int n5 = this.getIndexForEntryExitPair(n, n2);
        IBinaryNaturalRelation iBinaryNaturalRelation = this.summaries.get(n5);
        if (iBinaryNaturalRelation == null) {
            iBinaryNaturalRelation = new BasicNaturalRelation(new byte[]{2}, 0);
            this.summaries.set(n5, iBinaryNaturalRelation);
        }
        iBinaryNaturalRelation.add(n3, n4);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        int n5 = this.getIndexForEntryExitPair(n, n2);
        IBinaryNaturalRelation iBinaryNaturalRelation = this.summaries.get(n5);
        if (iBinaryNaturalRelation == null) {
            return false;
        }
        return iBinaryNaturalRelation.contains(n3, n4);
    }

    public IntSet getSummaryEdges(int n, int n2, int n3) {
        int n4 = this.getIndexForEntryExitPair(n, n2);
        IBinaryNaturalRelation iBinaryNaturalRelation = this.summaries.get(n4);
        if (iBinaryNaturalRelation == null) {
            return null;
        }
        return iBinaryNaturalRelation.getRelated(n3);
    }

    public IntSet getInvertedSummaryEdgesForTarget(int n, int n2, int n3) {
        int n4 = this.getIndexForEntryExitPair(n, n2);
        IBinaryNaturalRelation iBinaryNaturalRelation = this.summaries.get(n4);
        if (iBinaryNaturalRelation == null) {
            return null;
        }
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        for (IntPair intPair : iBinaryNaturalRelation) {
            if (intPair.getY() != n3) continue;
            mutableSparseIntSet.add(intPair.getX());
        }
        return mutableSparseIntSet;
    }

    private int getIndexForEntryExitPair(int n, int n2) {
        long l = LongUtil.pack(n, n2);
        int n3 = this.entryExitMap.get(l);
        if (n3 == -1) {
            n3 = this.nextEntryExitIndex++;
            this.entryExitMap.set(l, n3);
        }
        return n3;
    }
}

