/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.dataflow.IFDS.CallFlowEdges;
import com.ibm.wala.dataflow.IFDS.IBinaryReturnFlowFunction;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IFlowFunctionMap;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.IReversibleFlowFunction;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.ITabulationWorklist;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.LocalPathEdges;
import com.ibm.wala.dataflow.IFDS.LocalSummaryEdges;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationCancelException;
import com.ibm.wala.dataflow.IFDS.TabulationProblem;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Heap;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.ToStringComparator;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabulationSolver<T, P, F> {
    protected static final int DEBUG_LEVEL = 0;
    protected static final boolean verbose = "true".equals(System.getProperty("com.ibm.wala.fixedpoint.impl.verbose"));
    static final int VERBOSE_INTERVAL = 1000;
    static final boolean VERBOSE_TRACE_MEMORY = false;
    private static int verboseCounter = 0;
    protected static final boolean PERIODIC_WIPE_SOFT_CACHES = true;
    private static final int WIPE_SOFT_CACHE_INTERVAL = 1000000;
    private static int wipeCount = 1000000;
    protected final ISupergraph<T, P> supergraph;
    protected final IFlowFunctionMap<T> flowFunctionMap;
    private final TabulationProblem<T, P, F> problem;
    private final Map<T, LocalPathEdges> pathEdges = HashMapFactory.make();
    private final Map<T, CallFlowEdges> callFlowEdges = HashMapFactory.make();
    protected final Map<P, LocalSummaryEdges> summaryEdges = HashMapFactory.make();
    private final Map<P, Set<PathEdge<T>>> seeds = HashMapFactory.make();
    private final Set<PathEdge<T>> allSeeds = HashSetFactory.make();
    private ITabulationWorklist<T> worklist;
    protected final IProgressMonitor progressMonitor;
    private PathEdge<T> curPathEdge;
    private PathEdge<T> curSummaryEdge;

    protected TabulationSolver(TabulationProblem<T, P, F> tabulationProblem, IProgressMonitor iProgressMonitor) {
        if (tabulationProblem == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.supergraph = tabulationProblem.getSupergraph();
        this.flowFunctionMap = tabulationProblem.getFunctionMap();
        this.problem = tabulationProblem;
        this.progressMonitor = iProgressMonitor;
    }

    protected ITabulationWorklist<T> makeWorklist() {
        return new Worklist();
    }

    public static <T, P, F> TabulationSolver<T, P, F> make(TabulationProblem<T, P, F> tabulationProblem) {
        return new TabulationSolver<T, P, F>(tabulationProblem, null);
    }

    public TabulationResult<T, P, F> solve() throws CancelException {
        try {
            this.initialize();
            this.forwardTabulateSLRPs();
            Result result = new Result();
            return result;
        }
        catch (CancelException cancelException) {
            Result result = new Result();
            throw new TabulationCancelException(cancelException, result);
        }
        catch (CancelRuntimeException cancelRuntimeException) {
            Result result = new Result();
            throw new TabulationCancelException(cancelRuntimeException, result);
        }
    }

    protected void initialize() {
        for (PathEdge<T> pathEdge : this.problem.initialSeeds()) {
            this.addSeed(pathEdge);
        }
    }

    public void addSeed(PathEdge<T> pathEdge) {
        Set<PathEdge<T>> set = MapUtil.findOrCreateSet(this.seeds, this.supergraph.getProcOf(pathEdge.entry));
        set.add(pathEdge);
        this.allSeeds.add(pathEdge);
        this.propagate(pathEdge.entry, pathEdge.d1, pathEdge.target, pathEdge.d2);
    }

    private void forwardTabulateSLRPs() throws CancelException {
        assert (this.curPathEdge == null) : "curPathEdge should not be non-null here";
        if (this.worklist == null) {
            this.worklist = this.makeWorklist();
        }
        while (this.worklist.size() > 0) {
            MonitorUtil.throwExceptionIfCanceled(this.progressMonitor);
            if (verbose) {
                this.performVerboseAction();
            }
            this.tendToSoftCaches();
            PathEdge<T> pathEdge = this.popFromWorkList();
            this.curPathEdge = pathEdge;
            int n = this.merge(pathEdge.entry, pathEdge.d1, pathEdge.target, pathEdge.d2);
            if (n == -1) continue;
            if (n != pathEdge.d2) {
                this.propagate(pathEdge.entry, pathEdge.d1, pathEdge.target, n);
                continue;
            }
            if (this.supergraph.isCall(pathEdge.target)) {
                this.processCall(pathEdge);
                continue;
            }
            if (this.supergraph.isExit(pathEdge.target)) {
                this.processExit(pathEdge);
                continue;
            }
            this.processNormal(pathEdge);
        }
        this.curPathEdge = null;
    }

    protected void tendToSoftCaches() {
        if (++wipeCount > 1000000) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
    }

    protected final void performVerboseAction() {
        if (++verboseCounter % 1000 == 0) {
            System.err.println("Tabulation Solver " + verboseCounter);
            System.err.println("  " + this.peekFromWorkList());
        }
    }

    private void processNormal(final PathEdge<T> pathEdge) {
        Iterator iterator = this.supergraph.getSuccNodes(pathEdge.target);
        while (iterator.hasNext()) {
            final Object t = iterator.next();
            IUnaryFlowFunction iUnaryFlowFunction = this.flowFunctionMap.getNormalFlowFunction(pathEdge.target, t);
            IntSet intSet = this.computeFlow(pathEdge.d2, iUnaryFlowFunction);
            if (intSet == null) continue;
            intSet.foreach(new IntSetAction(){

                public void act(int n) {
                    TabulationSolver.this.propagate(pathEdge.entry, pathEdge.d1, t, n);
                }
            });
        }
    }

    protected void processExit(PathEdge<T> pathEdge) {
        int n;
        int n2;
        LocalSummaryEdges localSummaryEdges = this.findOrCreateLocalSummaryEdges(this.supergraph.getProcOf(pathEdge.target));
        if (!localSummaryEdges.contains(n2 = this.supergraph.getLocalBlockNumber(pathEdge.entry), n = this.supergraph.getLocalBlockNumber(pathEdge.target), pathEdge.d1, pathEdge.d2)) {
            localSummaryEdges.insertSummaryEdge(n2, n, pathEdge.d1, pathEdge.d2);
        }
        assert (this.curSummaryEdge == null) : "curSummaryEdge should be null here";
        this.curSummaryEdge = pathEdge;
        CallFlowEdges callFlowEdges = this.findOrCreateCallFlowEdges(pathEdge.entry);
        IntSet intSet = callFlowEdges.getCallFlowSourceNodes(pathEdge.d1);
        if (intSet != null) {
            IntIterator intIterator = intSet.intIterator();
            while (intIterator.hasNext()) {
                int n3 = intIterator.next();
                IntSet intSet2 = callFlowEdges.getCallFlowSources(n3, pathEdge.d1);
                this.propagateToReturnSites(pathEdge, this.supergraph.getNode(n3), intSet2);
            }
        }
        this.curSummaryEdge = null;
    }

    private void propagateToReturnSites(PathEdge<T> pathEdge, final T t, IntSet intSet) {
        P p = this.supergraph.getProcOf(t);
        final Object[] objectArray = this.supergraph.getEntriesForProcedure(p);
        Iterator<T> iterator = this.supergraph.getReturnSites(t, this.supergraph.getProcOf(pathEdge.target));
        while (iterator.hasNext()) {
            final T t2 = iterator.next();
            if (!this.supergraph.hasEdge(pathEdge.target, t2)) continue;
            IFlowFunction iFlowFunction = this.flowFunctionMap.getReturnFlowFunction(t, pathEdge.target, t2);
            if (iFlowFunction instanceof IBinaryReturnFlowFunction) {
                this.propagateToReturnSiteWithBinaryFlowFunction(pathEdge, t, intSet, objectArray, t2, iFlowFunction);
                continue;
            }
            final IntSet intSet2 = this.computeFlow(pathEdge.d2, (IUnaryFlowFunction)iFlowFunction);
            IntSetAction intSetAction = new IntSetAction(){

                public void act(int n) {
                    TabulationSolver.this.propToReturnSite(t, objectArray, t2, n, intSet2);
                }
            };
            intSet.foreach(intSetAction);
        }
    }

    private void propagateToReturnSiteWithBinaryFlowFunction(final PathEdge pathEdge, final T t, IntSet intSet, final T[] TArray, final T t2, final IFlowFunction iFlowFunction) {
        intSet.foreach(new IntSetAction(){

            public void act(int n) {
                IntSet intSet = TabulationSolver.this.computeBinaryFlow(n, pathEdge.d2, (IBinaryReturnFlowFunction)iFlowFunction);
                TabulationSolver.this.propToReturnSite(t, TArray, t2, n, intSet);
            }
        });
    }

    private void propToReturnSite(final T t, final T[] TArray, final T t2, final int n, IntSet intSet) {
        if (intSet != null) {
            intSet.foreach(new IntSetAction(){

                public void act(final int n3) {
                    int n2 = 0;
                    while (n2 < TArray.length) {
                        final Object object = TArray[n2];
                        IntSet intSet = TabulationSolver.this.getInversePathEdges(object, t, n);
                        if (intSet != null) {
                            intSet.foreach(new IntSetAction(){

                                public void act(int n2) {
                                    TabulationSolver.this.curPathEdge = PathEdge.createPathEdge(object, n2, t, n);
                                    TabulationSolver.this.propagate(object, n2, t2, n3);
                                }
                            });
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    protected IntSet getInversePathEdges(T t, T t2, int n) {
        int n2 = this.supergraph.getLocalBlockNumber(t2);
        LocalPathEdges localPathEdges = this.pathEdges.get(t);
        if (localPathEdges == null) {
            return null;
        }
        return localPathEdges.getInverse(n2, n);
    }

    protected void processCall(final PathEdge<T> pathEdge) {
        IntSet intSet;
        IUnaryFlowFunction iUnaryFlowFunction;
        Object object;
        int n = this.supergraph.getNumber(pathEdge.target);
        HashSet<Iterator<T>> hashSet = HashSetFactory.make();
        Iterator<T> iterator = this.supergraph.getReturnSites(pathEdge.target, null);
        while (iterator.hasNext()) {
            hashSet.add((Iterator<T>)iterator.next());
        }
        boolean bl = false;
        final Iterator<Object> iterator222 = this.supergraph.getCalledNodes(pathEdge.target);
        while (iterator222.hasNext()) {
            bl = true;
            object = iterator222.next();
            this.processParticularCallee(pathEdge, n, hashSet, object);
        }
        iterator222 = this.supergraph.getNormalSuccessors(pathEdge.target);
        while (iterator222.hasNext()) {
            object = iterator222.next();
            iUnaryFlowFunction = this.flowFunctionMap.getNormalFlowFunction(pathEdge.target, object);
            intSet = this.computeFlow(pathEdge.d2, iUnaryFlowFunction);
            if (intSet == null) continue;
            intSet.foreach(new IntSetAction(){

                public void act(int n) {
                    TabulationSolver.this.propagate(pathEdge.entry, pathEdge.d1, object, n);
                }
            });
        }
        for (final Iterator<Object> iterator222 : hashSet) {
            iUnaryFlowFunction = null;
            iUnaryFlowFunction = bl ? this.flowFunctionMap.getCallToReturnFlowFunction((Iterator<T>)pathEdge.target, iterator222) : this.flowFunctionMap.getCallNoneToReturnFlowFunction((Iterator<T>)pathEdge.target, iterator222);
            intSet = this.computeFlow(pathEdge.d2, iUnaryFlowFunction);
            if (intSet == null) continue;
            intSet.foreach(new IntSetAction(){

                public void act(int n) {
                    if (!$assertionsDisabled && n < 0) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && pathEdge.d1 < 0) {
                        throw new AssertionError();
                    }
                    TabulationSolver.this.propagate(pathEdge.entry, pathEdge.d1, iterator222, n);
                }
            });
        }
    }

    protected void processParticularCallee(final PathEdge<T> pathEdge, int n, Collection<T> collection, final T t) {
        Object object;
        Object object2;
        Object object322;
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        Iterator2Set iterator2Set = Iterator2Collection.toSet(this.supergraph.getReturnSites(pathEdge.target, this.supergraph.getProcOf(t)));
        collection.addAll(iterator2Set);
        for (Object object322 : iterator2Set) {
            object2 = this.flowFunctionMap.getCallFlowFunction(pathEdge.target, t, object322);
            object = this.computeFlow(pathEdge.d2, (IUnaryFlowFunction)object2);
            if (object == null) continue;
            mutableSparseIntSet.addAll((IntSet)object);
        }
        object322 = this.flowFunctionMap.getCallFlowFunction(pathEdge.target, t, null);
        IntSet intSet = this.computeFlow(pathEdge.d2, (IUnaryFlowFunction)object322);
        if (intSet != null) {
            mutableSparseIntSet.addAll(intSet);
        }
        if (mutableSparseIntSet != null) {
            object2 = this.summaryEdges.get(this.supergraph.getProcOf(t));
            object = this.findOrCreateCallFlowEdges(t);
            int n2 = this.supergraph.getLocalBlockNumber(t);
            mutableSparseIntSet.foreach(new IntSetAction((CallFlowEdges)object, n, (LocalSummaryEdges)object2, n2, iterator2Set){
                private final /* synthetic */ CallFlowEdges val$callFlow;
                private final /* synthetic */ int val$callNodeNum;
                private final /* synthetic */ LocalSummaryEdges val$summaries;
                private final /* synthetic */ int val$s_p_num;
                private final /* synthetic */ Collection val$returnSitesForCallee;
                {
                    this.val$callFlow = callFlowEdges;
                    this.val$callNodeNum = n;
                    this.val$summaries = localSummaryEdges;
                    this.val$s_p_num = n2;
                    this.val$returnSitesForCallee = collection;
                }

                public void act(final int n) {
                    boolean bl = !TabulationSolver.this.propagate(t, n, t, n);
                    TabulationSolver.this.recordCall(pathEdge.target, t, n, bl);
                    this.val$callFlow.addCallEdge(this.val$callNodeNum, pathEdge.d2, n);
                    if (this.val$summaries != null) {
                        Object p = TabulationSolver.this.supergraph.getProcOf(t);
                        T[] TArray = TabulationSolver.this.supergraph.getExitsForProcedure(p);
                        int n2 = 0;
                        while (n2 < TArray.length) {
                            final Object t2 = TArray[n2];
                            int n3 = TabulationSolver.this.supergraph.getLocalBlockNumber(t2);
                            IntSet intSet = this.val$summaries.getSummaryEdges(this.val$s_p_num, n3, n);
                            if (intSet != null) {
                                for (final Object e : this.val$returnSitesForCallee) {
                                    if (!TabulationSolver.this.supergraph.hasEdge(t2, e)) continue;
                                    final IFlowFunction iFlowFunction = TabulationSolver.this.flowFunctionMap.getReturnFlowFunction(pathEdge.target, t2, e);
                                    intSet.foreach(new IntSetAction(){

                                        public void act(int n2) {
                                            if (!$assertionsDisabled && TabulationSolver.this.curSummaryEdge != null) {
                                                throw new AssertionError((Object)"curSummaryEdge should be null here");
                                            }
                                            TabulationSolver.this.curSummaryEdge = PathEdge.createPathEdge(t, n, t2, n2);
                                            if (iFlowFunction instanceof IBinaryReturnFlowFunction) {
                                                IntSet intSet = TabulationSolver.this.computeBinaryFlow(pathEdge.d2, n2, (IBinaryReturnFlowFunction)iFlowFunction);
                                                if (intSet != null) {
                                                    intSet.foreach(new IntSetAction(){

                                                        public void act(int n) {
                                                            TabulationSolver.this.propagate(pathEdge.entry, pathEdge.d1, e, n);
                                                        }
                                                    });
                                                }
                                            } else {
                                                IntSet intSet = TabulationSolver.this.computeFlow(n2, (IUnaryFlowFunction)iFlowFunction);
                                                if (intSet != null) {
                                                    intSet.foreach(new IntSetAction(){

                                                        public void act(int n) {
                                                            TabulationSolver.this.propagate(pathEdge.entry, pathEdge.d1, e, n);
                                                        }
                                                    });
                                                }
                                            }
                                            TabulationSolver.this.curSummaryEdge = null;
                                        }
                                    });
                                }
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
    }

    protected void recordCall(T t, T t2, int n, boolean bl) {
    }

    protected IntSet computeBinaryFlow(int n, int n2, IBinaryReturnFlowFunction iBinaryReturnFlowFunction) {
        SparseIntSet sparseIntSet = iBinaryReturnFlowFunction.getTargets(n, n2);
        return sparseIntSet;
    }

    protected IntSet computeFlow(int n, IUnaryFlowFunction iUnaryFlowFunction) {
        IntSet intSet = iUnaryFlowFunction.getTargets(n);
        if (intSet == null) {
            return null;
        }
        return intSet;
    }

    protected IntSet computeInverseFlow(int n, IReversibleFlowFunction iReversibleFlowFunction) {
        return iReversibleFlowFunction.getSources(n);
    }

    protected PathEdge<T> popFromWorkList() {
        assert (this.worklist != null);
        return this.worklist.take();
    }

    private PathEdge peekFromWorkList() {
        assert (this.worklist != null);
        PathEdge<T> pathEdge = this.worklist.take();
        this.worklist.insert(pathEdge);
        return pathEdge;
    }

    protected boolean propagate(T t, int n, T t2, int n2) {
        int n3 = this.supergraph.getLocalBlockNumber(t2);
        if (n3 < 0) {
            System.err.println("BOOM " + t2);
            this.supergraph.getLocalBlockNumber(t2);
        }
        assert (n3 >= 0);
        LocalPathEdges localPathEdges = this.findOrCreateLocalPathEdges(t);
        assert (n2 >= 0);
        if (!localPathEdges.contains(n, n3, n2)) {
            localPathEdges.addPathEdge(n, n3, n2);
            this.addToWorkList(t, n, t2, n2);
            return true;
        }
        return false;
    }

    public LocalPathEdges getLocalPathEdges(T t) {
        return this.pathEdges.get(t);
    }

    private int merge(T t, int n, T t2, int n2) {
        assert (n2 >= 0);
        IMergeFunction iMergeFunction = this.problem.getMergeFunction();
        if (iMergeFunction != null) {
            LocalPathEdges localPathEdges = this.pathEdges.get(t);
            IntSet intSet = localPathEdges.getReachable(this.supergraph.getLocalBlockNumber(t2), n);
            if (intSet == null) {
                return n2;
            }
            int n3 = intSet.size();
            if (n3 == 0 || n3 == 1 && intSet.contains(n2)) {
                return n2;
            }
            int n4 = iMergeFunction.merge(intSet, n2);
            return n4;
        }
        return n2;
    }

    protected void addToWorkList(T t, int n, T t2, int n2) {
        if (this.worklist == null) {
            this.worklist = this.makeWorklist();
        }
        this.worklist.insert(PathEdge.createPathEdge(t, n, t2, n2));
    }

    protected LocalPathEdges findOrCreateLocalPathEdges(T t) {
        LocalPathEdges localPathEdges = this.pathEdges.get(t);
        if (localPathEdges == null) {
            localPathEdges = this.makeLocalPathEdges();
            this.pathEdges.put(t, localPathEdges);
        }
        return localPathEdges;
    }

    private LocalPathEdges makeLocalPathEdges() {
        return this.problem.getMergeFunction() == null ? new LocalPathEdges(false) : new LocalPathEdges(true);
    }

    protected LocalSummaryEdges findOrCreateLocalSummaryEdges(P p) {
        LocalSummaryEdges localSummaryEdges = this.summaryEdges.get(p);
        if (localSummaryEdges == null) {
            localSummaryEdges = new LocalSummaryEdges();
            this.summaryEdges.put(p, localSummaryEdges);
        }
        return localSummaryEdges;
    }

    protected CallFlowEdges findOrCreateCallFlowEdges(T t) {
        CallFlowEdges callFlowEdges = this.callFlowEdges.get(t);
        if (callFlowEdges == null) {
            callFlowEdges = new CallFlowEdges();
            this.callFlowEdges.put(t, callFlowEdges);
        }
        return callFlowEdges;
    }

    public IntSet getResult(T t) {
        P p = this.supergraph.getProcOf(t);
        int n = this.supergraph.getLocalBlockNumber(t);
        T[] TArray = this.supergraph.getEntriesForProcedure(p);
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        HashSet<Object> hashSet = HashSetFactory.make(Arrays.asList(TArray));
        Set<PathEdge<T>> set = this.seeds.get(p);
        if (set != null) {
            for (PathEdge<Object> object : set) {
                hashSet.add(object.entry);
            }
        }
        for (Object object : hashSet) {
            LocalPathEdges localPathEdges = this.pathEdges.get(object);
            if (localPathEdges == null) continue;
            mutableSparseIntSet.addAll(localPathEdges.getReachable(n));
        }
        return mutableSparseIntSet;
    }

    public ISupergraph<T, P> getSupergraph() {
        return this.supergraph;
    }

    public IntSet getSummarySources(T t, int n, T t2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("not currently supported.  be careful");
    }

    public TabulationProblem<T, P, F> getProblem() {
        return this.problem;
    }

    public Collection<PathEdge<T>> getSeeds() {
        return Collections.unmodifiableCollection(this.allSeeds);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    protected PathEdge<T> getCurPathEdge() {
        return this.curPathEdge;
    }

    protected PathEdge<T> getCurSummaryEdge() {
        return this.curSummaryEdge;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Result
    implements TabulationResult<T, P, F> {
        @Override
        public IntSet getResult(T t) {
            return TabulationSolver.this.getResult(t);
        }

        public String toString() {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            TreeMap treeMap = new TreeMap(ToStringComparator.instance());
            Comparator<Object> comparator = new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    if (!(object instanceof IBasicBlock)) {
                        return -1;
                    }
                    IBasicBlock iBasicBlock = (IBasicBlock)object;
                    IBasicBlock iBasicBlock2 = (IBasicBlock)object2;
                    return iBasicBlock.getNumber() - iBasicBlock2.getNumber();
                }
            };
            for (Object object2 : TabulationSolver.this.supergraph) {
                object = TabulationSolver.this.supergraph.getProcOf(object2);
                TreeSet treeSet = (TreeSet)treeMap.get(object);
                if (treeSet == null) {
                    treeSet = new TreeSet(comparator);
                    treeMap.put(object, treeSet);
                }
                treeSet.add(object2);
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                object = (Set)entry.getValue();
                for (Object e : object) {
                    stringBuffer.append(e + " : " + this.getResult(e) + "\n");
                }
            }
            return stringBuffer.toString();
        }

        @Override
        public TabulationProblem<T, P, F> getProblem() {
            return TabulationSolver.this.problem;
        }

        @Override
        public Collection<T> getSupergraphNodesReached() {
            HashSet hashSet = HashSetFactory.make();
            for (Map.Entry entry : TabulationSolver.this.pathEdges.entrySet()) {
                Object k = entry.getKey();
                Object p = TabulationSolver.this.supergraph.getProcOf(k);
                IntSet intSet = ((LocalPathEdges)entry.getValue()).getReachedNodeNumbers();
                IntIterator intIterator = intSet.intIterator();
                while (intIterator.hasNext()) {
                    hashSet.add(TabulationSolver.this.supergraph.getLocalBlock(p, intIterator.next()));
                }
            }
            return hashSet;
        }

        @Override
        public IntSet getSummaryTargets(T t, int n, T t2) {
            LocalSummaryEdges localSummaryEdges = TabulationSolver.this.summaryEdges.get(TabulationSolver.this.supergraph.getProcOf(t));
            if (localSummaryEdges == null) {
                return null;
            }
            int n2 = TabulationSolver.this.supergraph.getLocalBlockNumber(t);
            int n3 = TabulationSolver.this.supergraph.getLocalBlockNumber(t2);
            return localSummaryEdges.getSummaryEdges(n2, n3, n);
        }

        @Override
        public Collection<PathEdge<T>> getSeeds() {
            return TabulationSolver.this.getSeeds();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Worklist
    extends Heap<PathEdge<T>>
    implements ITabulationWorklist<T> {
        Worklist() {
            super(100);
        }

        @Override
        protected boolean compareElements(PathEdge<T> pathEdge, PathEdge<T> pathEdge2) {
            return TabulationSolver.this.problem.getDomain().hasPriorityOver(pathEdge, pathEdge2);
        }
    }
}

