/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.demandpa.flowgraph.AbstractFlowGraph;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.PointerKeyAndCallSite;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDemandFlowGraph
extends AbstractFlowGraph {
    private static final boolean DEBUG = false;
    private static int wipeCount = 0;
    final BitVectorIntSet cgNodesVisited = new BitVectorIntSet();
    final Map<CGNode, Set<CallerSiteContext>> callerCache = HashMapFactory.make();

    @Override
    public void addSubgraphForNode(CGNode cGNode) throws IllegalArgumentException {
        if (cGNode == null) {
            throw new IllegalArgumentException("node == null");
        }
        IR iR = cGNode.getIR();
        if (iR == null) {
            throw new IllegalArgumentException("no ir for node " + cGNode);
        }
        int n = this.cg.getNumber(cGNode);
        if (!this.cgNodesVisited.contains(n)) {
            this.cgNodesVisited.add(n);
            this.unconditionallyAddConstraintsFromNode(cGNode, iR);
            this.addNodesForInvocations(cGNode, iR);
            this.addNodesForParameters(cGNode, iR);
        }
    }

    @Override
    public boolean hasSubgraphForNode(CGNode cGNode) {
        return this.cgNodesVisited.contains(this.cg.getNumber(cGNode));
    }

    public Iterator<PointerKeyAndCallSite> getParamSuccs(LocalPointerKey localPointerKey) {
        CGNode cGNode = (CGNode)this.params.get(localPointerKey);
        if (cGNode == null) {
            return EmptyIterator.instance();
        }
        int n = localPointerKey.getValueNumber() - 1;
        ArrayList<PointerKeyAndCallSite> arrayList = new ArrayList<PointerKeyAndCallSite>();
        for (CGNode cGNode2 : this.cg) {
            this.addSubgraphForNode(cGNode2);
            IR iR = cGNode2.getIR();
            Iterator<CallSiteReference> iterator = iR.iterateCallSites();
            while (iterator.hasNext()) {
                CallSiteReference callSiteReference = iterator.next();
                if (!this.cg.getPossibleTargets(cGNode2, callSiteReference).contains(cGNode)) continue;
                SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = iR.getCalls(callSiteReference);
                int n2 = 0;
                while (n2 < sSAAbstractInvokeInstructionArray.length) {
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray[n2];
                    PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode2, sSAAbstractInvokeInstruction.getUse(n));
                    assert (this.containsNode(pointerKey));
                    assert (this.containsNode(localPointerKey));
                    arrayList.add(new PointerKeyAndCallSite(pointerKey, callSiteReference));
                    ++n2;
                }
            }
        }
        return arrayList.iterator();
    }

    public Iterator<PointerKeyAndCallSite> getParamPreds(LocalPointerKey localPointerKey) {
        Set set = (Set)this.callParams.get(localPointerKey);
        if (set == null) {
            return EmptyIterator.instance();
        }
        ArrayList<PointerKeyAndCallSite> arrayList = new ArrayList<PointerKeyAndCallSite>();
        for (SSAInvokeInstruction sSAInvokeInstruction : set) {
            int n = 0;
            while (n < sSAInvokeInstruction.getNumberOfUses()) {
                if (localPointerKey.getValueNumber() == sSAInvokeInstruction.getUse(n)) {
                    CallSiteReference callSiteReference = sSAInvokeInstruction.getCallSite();
                    Set<CGNode> set2 = this.cg.getPossibleTargets(localPointerKey.getNode(), callSiteReference);
                    for (CGNode cGNode : set2) {
                        this.addSubgraphForNode(cGNode);
                        PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, n + 1);
                        assert (this.containsNode(pointerKey));
                        arrayList.add(new PointerKeyAndCallSite(pointerKey, callSiteReference));
                    }
                }
                ++n;
            }
        }
        return arrayList.iterator();
    }

    public Iterator<PointerKeyAndCallSite> getReturnSuccs(LocalPointerKey localPointerKey) {
        SSAInvokeInstruction sSAInvokeInstruction = (SSAInvokeInstruction)this.callDefs.get(localPointerKey);
        if (sSAInvokeInstruction == null) {
            return EmptyIterator.instance();
        }
        ArrayList<PointerKeyAndCallSite> arrayList = new ArrayList<PointerKeyAndCallSite>();
        boolean bl = localPointerKey.getValueNumber() == sSAInvokeInstruction.getException();
        CallSiteReference callSiteReference = sSAInvokeInstruction.getCallSite();
        Set<CGNode> set = this.cg.getPossibleTargets(localPointerKey.getNode(), callSiteReference);
        for (CGNode cGNode : set) {
            PointerKey pointerKey;
            this.addSubgraphForNode(cGNode);
            PointerKey pointerKey2 = pointerKey = bl ? this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode) : this.heapModel.getPointerKeyForReturnValue(cGNode);
            assert (this.containsNode(pointerKey));
            arrayList.add(new PointerKeyAndCallSite(pointerKey, callSiteReference));
        }
        return arrayList.iterator();
    }

    public Iterator<PointerKeyAndCallSite> getReturnPreds(LocalPointerKey localPointerKey) {
        CGNode cGNode = (CGNode)this.returns.get(localPointerKey);
        if (cGNode == null) {
            return EmptyIterator.instance();
        }
        boolean bl = localPointerKey == this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode);
        ArrayList<PointerKeyAndCallSite> arrayList = new ArrayList<PointerKeyAndCallSite>();
        for (CGNode cGNode2 : this.cg) {
            this.addSubgraphForNode(cGNode2);
            IR iR = cGNode2.getIR();
            Iterator<CallSiteReference> iterator = iR.iterateCallSites();
            while (iterator.hasNext()) {
                CallSiteReference callSiteReference = iterator.next();
                if (!this.cg.getPossibleTargets(cGNode2, callSiteReference).contains(cGNode)) continue;
                SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = iR.getCalls(callSiteReference);
                int n = 0;
                while (n < sSAAbstractInvokeInstructionArray.length) {
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = sSAAbstractInvokeInstructionArray[n];
                    PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode2, bl ? sSAAbstractInvokeInstruction.getException() : sSAAbstractInvokeInstruction.getDef());
                    assert (this.containsNode(pointerKey));
                    assert (this.containsNode(localPointerKey));
                    arrayList.add(new PointerKeyAndCallSite(pointerKey, callSiteReference));
                    ++n;
                }
            }
        }
        return arrayList.iterator();
    }

    protected abstract void addNodesForParameters(CGNode var1, IR var2);

    protected void unconditionallyAddConstraintsFromNode(CGNode cGNode, IR iR) {
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
        this.debugPrintIR(iR);
        if (iR == null) {
            return;
        }
        DefUse defUse = cGNode.getDU();
        this.addNodeInstructionConstraints(cGNode, iR, defUse);
        this.addNodePassthruExceptionConstraints(cGNode, iR);
        this.addNodeConstantConstraints(cGNode, iR);
    }

    protected void addNodeInstructionConstraints(CGNode cGNode, IR iR, DefUse defUse) {
        FlowStatementVisitor flowStatementVisitor = this.makeVisitor(cGNode);
        SSACFG sSACFG = iR.getControlFlowGraph();
        for (ISSABasicBlock iSSABasicBlock : sSACFG) {
            this.addBlockInstructionConstraints(cGNode, sSACFG, iSSABasicBlock, flowStatementVisitor);
        }
    }

    protected void addBlockInstructionConstraints(CGNode cGNode, ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph, ISSABasicBlock iSSABasicBlock, FlowStatementVisitor flowStatementVisitor) {
        flowStatementVisitor.setBasicBlock(iSSABasicBlock);
        for (SSAInstruction sSAInstruction : iSSABasicBlock) {
            if (sSAInstruction == null) continue;
            sSAInstruction.visit(flowStatementVisitor);
        }
        this.addPhiConstraints(cGNode, controlFlowGraph, iSSABasicBlock);
    }

    private void addPhiConstraints(CGNode cGNode, ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph, ISSABasicBlock iSSABasicBlock) {
        Iterator<ISSABasicBlock> iterator = controlFlowGraph.getSuccNodes(iSSABasicBlock);
        while (iterator.hasNext()) {
            ISSABasicBlock iSSABasicBlock2 = iterator.next();
            if (iSSABasicBlock2.isExitBlock()) continue;
            int n = 0;
            Iterator<Object> iterator2 = controlFlowGraph.getPredNodes(iSSABasicBlock2);
            while (iterator2.hasNext()) {
                if (iterator2.next() == iSSABasicBlock) break;
                ++n;
            }
            assert (n < controlFlowGraph.getPredNodeCount(iSSABasicBlock2));
            iterator2 = iSSABasicBlock2.iteratePhis();
            while (iterator2.hasNext()) {
                SSAPhiInstruction sSAPhiInstruction = (SSAPhiInstruction)iterator2.next();
                if (sSAPhiInstruction == null) continue;
                PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, sSAPhiInstruction.getDef());
                if (sSAPhiInstruction.getUse(n) <= 0) continue;
                PointerKey pointerKey2 = this.heapModel.getPointerKeyForLocal(cGNode, sSAPhiInstruction.getUse(n));
                this.addNode(pointerKey);
                this.addNode(pointerKey2);
                this.addEdge(pointerKey, pointerKey2, AssignLabel.noFilter());
            }
        }
    }

    protected abstract FlowStatementVisitor makeVisitor(CGNode var1);

    private void debugPrintIR(IR iR) {
    }

    @Override
    public Set<CallerSiteContext> getPotentialCallers(PointerKey pointerKey) {
        CGNode cGNode = null;
        if (pointerKey instanceof LocalPointerKey) {
            cGNode = ((LocalPointerKey)pointerKey).getNode();
        } else if (pointerKey instanceof ReturnValueKey) {
            cGNode = ((ReturnValueKey)pointerKey).getNode();
        } else {
            throw new IllegalArgumentException("formalPk must represent a local");
        }
        Set<CallerSiteContext> set = this.callerCache.get(cGNode);
        if (set == null) {
            set = HashSetFactory.make();
            Iterator<CGNode> iterator = this.cg.getPredNodes(cGNode);
            while (iterator.hasNext()) {
                CGNode cGNode2 = iterator.next();
                Iterator<CallSiteReference> iterator2 = this.cg.getPossibleSites(cGNode2, cGNode);
                while (iterator2.hasNext()) {
                    CallSiteReference callSiteReference = iterator2.next();
                    set.add(new CallerSiteContext(cGNode2, callSiteReference));
                }
            }
            this.callerCache.put(cGNode, set);
        }
        return set;
    }

    @Override
    public Set<CGNode> getPossibleTargets(CGNode cGNode, CallSiteReference callSiteReference, LocalPointerKey localPointerKey) {
        return this.cg.getPossibleTargets(cGNode, callSiteReference);
    }

    public AbstractDemandFlowGraph(CallGraph callGraph, HeapModel heapModel, MemoryAccessMap memoryAccessMap, IClassHierarchy iClassHierarchy) {
        super(memoryAccessMap, heapModel, iClassHierarchy, callGraph);
    }

    protected static interface FlowStatementVisitor
    extends SSAInstruction.IVisitor {
        public void setBasicBlock(ISSABasicBlock var1);
    }
}

