/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AbstractDemandFlowGraph;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DemandValueFlowGraph
extends AbstractDemandFlowGraph {
    public DemandValueFlowGraph(CallGraph callGraph, HeapModel heapModel, MemoryAccessMap memoryAccessMap, ClassHierarchy classHierarchy) {
        super(callGraph, heapModel, memoryAccessMap, classHierarchy);
    }

    protected void addNodesForParameters(CGNode cGNode, IR iR) {
        SymbolTable symbolTable = iR.getSymbolTable();
        int n = symbolTable.getNumberOfParameters();
        int n2 = 0;
        while (n2 < n) {
            int n3 = symbolTable.getParameter(n2);
            PointerKey pointerKey = this.heapModel.getPointerKeyForLocal(cGNode, n3);
            this.addNode(pointerKey);
            this.params.put(pointerKey, cGNode);
            ++n2;
        }
        PointerKey pointerKey = this.heapModel.getPointerKeyForReturnValue(cGNode);
        this.addNode(pointerKey);
        this.returns.put(pointerKey, cGNode);
        PointerKey pointerKey2 = this.heapModel.getPointerKeyForExceptionalReturnValue(cGNode);
        this.addNode(pointerKey2);
        this.returns.put(pointerKey2, cGNode);
    }

    protected AbstractDemandFlowGraph.FlowStatementVisitor makeVisitor(CGNode cGNode) {
        return new AllValsStatementVisitor(cGNode);
    }

    private class AllValsStatementVisitor
    extends SSAInstruction.Visitor
    implements AbstractDemandFlowGraph.FlowStatementVisitor {
        protected final CGNode node;
        protected final IR ir;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public AllValsStatementVisitor(CGNode cGNode) {
            this.node = cGNode;
            this.ir = cGNode.getIR();
            this.symbolTable = this.ir.getSymbolTable();
            assert (this.symbolTable != null);
            this.du = cGNode.getDU();
        }

        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAArrayLoadInstruction.getDef());
            PointerKey pointerKey2 = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAArrayLoadInstruction.getArrayRef());
            DemandValueFlowGraph.this.addNode(pointerKey);
            DemandValueFlowGraph.this.addNode(pointerKey2);
            DemandValueFlowGraph.this.addEdge(pointerKey, pointerKey2, GetFieldLabel.make(ArrayContents.v()));
        }

        public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAArrayStoreInstruction.getValue());
            PointerKey pointerKey2 = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAArrayStoreInstruction.getArrayRef());
            DemandValueFlowGraph.this.addNode(pointerKey);
            DemandValueFlowGraph.this.addNode(pointerKey2);
            DemandValueFlowGraph.this.addEdge(pointerKey2, pointerKey, PutFieldLabel.make(ArrayContents.v()));
        }

        public void visitCheckCast(SSACheckCastInstruction sSACheckCastInstruction) {
            Object object;
            HashSet<IClass> hashSet = HashSetFactory.make();
            TypeReference[] typeReferenceArray = sSACheckCastInstruction.getDeclaredResultTypes();
            int n = typeReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = typeReferenceArray[n2];
                IClass iClass = DemandValueFlowGraph.this.cha.lookupClass((TypeReference)object);
                if (iClass == null) {
                    return;
                }
                hashSet.add(iClass);
                ++n2;
            }
            object = DemandValueFlowGraph.this.heapModel.getFilteredPointerKeyForLocal(this.node, sSACheckCastInstruction.getResult(), new FilteredPointerKey.MultipleClassesFilter(hashSet.toArray(new IClass[hashSet.size()])));
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSACheckCastInstruction.getVal());
            DemandValueFlowGraph.this.addNode(object);
            DemandValueFlowGraph.this.addNode(pointerKey);
            DemandValueFlowGraph.this.addEdge(object, pointerKey, AssignLabel.noFilter());
        }

        public void visitReturn(SSAReturnInstruction sSAReturnInstruction) {
            if (sSAReturnInstruction.returnsVoid()) {
                return;
            }
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAReturnInstruction.getResult());
            DemandValueFlowGraph.this.addNode(pointerKey);
            PointerKey pointerKey2 = DemandValueFlowGraph.this.heapModel.getPointerKeyForReturnValue(this.node);
            DemandValueFlowGraph.this.addNode(pointerKey2);
            DemandValueFlowGraph.this.addEdge(pointerKey2, pointerKey, AssignLabel.noFilter());
        }

        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            this.visitGetInternal(sSAGetInstruction.getDef(), sSAGetInstruction.getRef(), sSAGetInstruction.isStatic(), sSAGetInstruction.getDeclaredField());
        }

        protected void visitGetInternal(int n, int n2, boolean bl, FieldReference fieldReference) {
            IField iField = DemandValueFlowGraph.this.cg.getClassHierarchy().resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, n);
            assert (pointerKey != null);
            if (bl) {
                PointerKey pointerKey2 = DemandValueFlowGraph.this.heapModel.getPointerKeyForStaticField(iField);
                DemandValueFlowGraph.this.addNode(pointerKey);
                DemandValueFlowGraph.this.addNode(pointerKey2);
                DemandValueFlowGraph.this.addEdge(pointerKey, pointerKey2, AssignGlobalLabel.v());
            } else {
                PointerKey pointerKey3 = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, n2);
                DemandValueFlowGraph.this.addNode(pointerKey);
                DemandValueFlowGraph.this.addNode(pointerKey3);
                DemandValueFlowGraph.this.addEdge(pointerKey, pointerKey3, GetFieldLabel.make(iField));
            }
        }

        public void visitPut(SSAPutInstruction sSAPutInstruction) {
            this.visitPutInternal(sSAPutInstruction.getVal(), sSAPutInstruction.getRef(), sSAPutInstruction.isStatic(), sSAPutInstruction.getDeclaredField());
        }

        public void visitPutInternal(int n, int n2, boolean bl, FieldReference fieldReference) {
            IField iField = DemandValueFlowGraph.this.cg.getClassHierarchy().resolveField(fieldReference);
            if (iField == null) {
                return;
            }
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, n);
            assert (pointerKey != null);
            if (bl) {
                PointerKey pointerKey2 = DemandValueFlowGraph.this.heapModel.getPointerKeyForStaticField(iField);
                DemandValueFlowGraph.this.addNode(pointerKey);
                DemandValueFlowGraph.this.addNode(pointerKey2);
                DemandValueFlowGraph.this.addEdge(pointerKey2, pointerKey, AssignGlobalLabel.v());
            } else {
                PointerKey pointerKey3 = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, n2);
                DemandValueFlowGraph.this.addNode(pointerKey);
                DemandValueFlowGraph.this.addNode(pointerKey3);
                DemandValueFlowGraph.this.addEdge(pointerKey3, pointerKey, PutFieldLabel.make(iField));
            }
        }

        public void visitInvoke(SSAInvokeInstruction sSAInvokeInstruction) {
            int n = 0;
            while (n < sSAInvokeInstruction.getNumberOfUses()) {
                PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAInvokeInstruction.getUse(n));
                DemandValueFlowGraph.this.addNode(pointerKey);
                Set set = MapUtil.findOrCreateSet(DemandValueFlowGraph.this.callParams, pointerKey);
                set.add(sSAInvokeInstruction);
                ++n;
            }
            if (sSAInvokeInstruction.hasDef()) {
                PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAInvokeInstruction.getDef());
                DemandValueFlowGraph.this.addNode(pointerKey);
                DemandValueFlowGraph.this.callDefs.put(pointerKey, sSAInvokeInstruction);
            }
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAInvokeInstruction.getException());
            DemandValueFlowGraph.this.addNode(pointerKey);
            DemandValueFlowGraph.this.callDefs.put(pointerKey, sSAInvokeInstruction);
        }

        public void visitNew(SSANewInstruction sSANewInstruction) {
            InstanceKey instanceKey = DemandValueFlowGraph.this.heapModel.getInstanceKeyForAllocation(this.node, sSANewInstruction.getNewSite());
            if (instanceKey == null) {
                return;
            }
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSANewInstruction.getDef());
            DemandValueFlowGraph.this.addNode(instanceKey);
            DemandValueFlowGraph.this.addNode(pointerKey);
            DemandValueFlowGraph.this.addEdge(pointerKey, instanceKey, NewLabel.v());
            IClass iClass = instanceKey.getConcreteType();
            int n = 0;
            InstanceKey instanceKey2 = instanceKey;
            PointerKey pointerKey2 = pointerKey;
            while (iClass != null && iClass.isArrayClass()) {
                if ((iClass = ((ArrayClass)iClass).getElementClass()) == null || !iClass.isArrayClass()) continue;
                InstanceKey instanceKey3 = DemandValueFlowGraph.this.heapModel.getInstanceKeyForMultiNewArray(this.node, sSANewInstruction.getNewSite(), n);
                PointerKey pointerKey3 = DemandValueFlowGraph.this.heapModel.getPointerKeyForArrayContents(instanceKey2);
                DemandValueFlowGraph.this.addNode(instanceKey3);
                DemandValueFlowGraph.this.addNode(pointerKey3);
                DemandValueFlowGraph.this.addEdge(pointerKey3, instanceKey3, NewLabel.v());
                DemandValueFlowGraph.this.addEdge(pointerKey2, pointerKey3, PutFieldLabel.make(ArrayContents.v()));
                instanceKey2 = instanceKey3;
                pointerKey2 = pointerKey3;
                ++n;
            }
        }

        public void visitThrow(SSAThrowInstruction sSAThrowInstruction) {
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
            List<ProgramCounter> list = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAGetCaughtExceptionInstruction.getDef());
            Set<IClass> set = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(sSAGetCaughtExceptionInstruction, this.ir);
            DemandValueFlowGraph.this.addExceptionDefConstraints(this.ir, this.node, list, pointerKey, set);
        }

        public void visitPi(SSAPiInstruction sSAPiInstruction) {
            PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAPiInstruction.getDef());
            PointerKey pointerKey2 = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, sSAPiInstruction.getVal());
            DemandValueFlowGraph.this.addNode(pointerKey);
            DemandValueFlowGraph.this.addNode(pointerKey2);
            DemandValueFlowGraph.this.addEdge(pointerKey, pointerKey2, AssignLabel.noFilter());
        }

        private void handleNonHeapInstruction(SSAInstruction sSAInstruction) {
            int n = 0;
            while (n < sSAInstruction.getNumberOfDefs()) {
                int n2 = sSAInstruction.getDef(n);
                PointerKey pointerKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, n2);
                DemandValueFlowGraph.this.addNode(pointerKey);
                int n3 = 0;
                while (n3 < sSAInstruction.getNumberOfUses()) {
                    int n4 = sSAInstruction.getUse(n3);
                    PointerKey pointerKey2 = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, n4);
                    DemandValueFlowGraph.this.addNode(pointerKey2);
                    DemandValueFlowGraph.this.addEdge(pointerKey, pointerKey2, AssignLabel.noFilter());
                    ++n3;
                }
                ++n;
            }
        }

        public void visitArrayLength(SSAArrayLengthInstruction sSAArrayLengthInstruction) {
            this.handleNonHeapInstruction(sSAArrayLengthInstruction);
        }

        public void visitBinaryOp(SSABinaryOpInstruction sSABinaryOpInstruction) {
            this.handleNonHeapInstruction(sSABinaryOpInstruction);
        }

        public void visitComparison(SSAComparisonInstruction sSAComparisonInstruction) {
            this.handleNonHeapInstruction(sSAComparisonInstruction);
        }

        public void visitConversion(SSAConversionInstruction sSAConversionInstruction) {
            this.handleNonHeapInstruction(sSAConversionInstruction);
        }

        public void visitInstanceof(SSAInstanceofInstruction sSAInstanceofInstruction) {
            this.handleNonHeapInstruction(sSAInstanceofInstruction);
        }

        public void visitUnaryOp(SSAUnaryOpInstruction sSAUnaryOpInstruction) {
            this.handleNonHeapInstruction(sSAUnaryOpInstruction);
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(ISSABasicBlock iSSABasicBlock) {
            this.basicBlock = iSSABasicBlock;
        }

        public void visitLoadMetadata(SSALoadMetadataInstruction sSALoadMetadataInstruction) {
            Assertions.UNREACHABLE();
        }
    }
}

