/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.genericutil;

import com.ibm.wala.demandpa.genericutil.MultiMap;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMultiMap<K, V>
implements MultiMap<K, V> {
    protected final Map<K, Set<V>> map = HashMapFactory.make();
    protected final boolean create;

    protected AbstractMultiMap(boolean bl) {
        this.create = bl;
    }

    protected abstract Set<V> createSet();

    protected Set<V> emptySet() {
        return Collections.emptySet();
    }

    @Override
    public Set<V> get(K k) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            if (this.create) {
                set = this.createSet();
                this.map.put(k, set);
            } else {
                set = this.emptySet();
            }
        }
        return set;
    }

    @Override
    public boolean put(K k, V v) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            set = this.createSet();
            this.map.put(k, set);
        }
        return set.add(v);
    }

    @Override
    public boolean remove(K k, V v) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            return false;
        }
        boolean bl = set.remove(v);
        if (set.isEmpty()) {
            this.map.remove(k);
        }
        return bl;
    }

    @Override
    public Set<V> removeAll(K k) {
        return this.map.remove(k);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    @Override
    public int size() {
        int n = 0;
        for (K k : this.keySet()) {
            n += this.get(k).size();
        }
        return n;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean putAll(K k, Collection<? extends V> collection) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            set = this.createSet();
            this.map.put(k, set);
        }
        return set.addAll(collection);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

