/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.genericutil;

import com.ibm.wala.demandpa.genericutil.ObjectVisitor;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySet<T>
extends AbstractSet<T> {
    private static final ArraySet EMPTY = new ArraySet<Object>(0, true){

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }
    };
    private T[] _elems;
    private int _curIndex = 0;
    private final boolean checkDupes;

    public static final <T> ArraySet<T> empty() {
        return EMPTY;
    }

    public ArraySet(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid n: " + n);
        }
        this._elems = new Object[n];
        this.checkDupes = bl;
    }

    public ArraySet() {
        this(1, true);
    }

    public ArraySet(ArraySet<T> arraySet) throws IllegalArgumentException {
        if (arraySet == null) {
            throw new IllegalArgumentException("other == null");
        }
        int n = arraySet._curIndex;
        this._elems = new Object[n];
        this.checkDupes = arraySet.checkDupes;
        this._curIndex = n;
        System.arraycopy(arraySet._elems, 0, this._elems, 0, n);
    }

    private ArraySet(Collection<T> collection) {
        this(collection.size(), true);
        ((AbstractCollection)this).addAll(collection);
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null o");
        }
        if (this.checkDupes && this.contains(t)) {
            return false;
        }
        if (this._curIndex == this._elems.length) {
            T[] TArray = this._elems;
            this._elems = new Object[TArray.length * 2];
            System.arraycopy(TArray, 0, this._elems, 0, TArray.length);
        }
        this._elems[this._curIndex] = t;
        ++this._curIndex;
        return true;
    }

    @Override
    public boolean addAll(ArraySet<T> arraySet) throws IllegalArgumentException {
        if (arraySet == null) {
            throw new IllegalArgumentException("other == null");
        }
        boolean bl = false;
        int n = 0;
        while (n < arraySet.size()) {
            boolean bl2 = this.add(arraySet.get(n));
            bl = bl || bl2;
            ++n;
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        int n = 0;
        while (n < this._curIndex) {
            if (this._elems[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean intersects(ArraySet<T> arraySet) throws IllegalArgumentException {
        if (arraySet == null) {
            throw new IllegalArgumentException("other == null");
        }
        int n = 0;
        while (n < arraySet.size()) {
            if (this.contains(arraySet.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void forall(ObjectVisitor<T> objectVisitor) {
        if (objectVisitor == null) {
            throw new IllegalArgumentException("null visitor");
        }
        int n = 0;
        while (n < this._curIndex) {
            objectVisitor.visit(this._elems[n]);
            ++n;
        }
    }

    @Override
    public int size() {
        return this._curIndex;
    }

    public T get(int n) {
        return this._elems[n];
    }

    @Override
    public boolean remove(Object object) {
        int n = 0;
        while (n < this._curIndex && !this._elems[n].equals(object)) {
            ++n;
        }
        if (n == this._curIndex) {
            return false;
        }
        return this.remove(n);
    }

    public boolean remove(int n) {
        try {
            System.arraycopy(this._elems, n + 1, this._elems, n, this._curIndex - (n + 1));
            --this._curIndex;
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid ind: " + n);
        }
    }

    @Override
    public void clear() {
        this._curIndex = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArraySetIterator();
    }

    public static <T> ArraySet<T> make() {
        return new ArraySet<T>();
    }

    public static <T> ArraySet<T> make(Collection<T> collection) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("other == null");
        }
        return new ArraySet<T>(collection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArraySetIterator
    implements Iterator<T> {
        int ind = 0;
        final int setSize;

        public ArraySetIterator() {
            this.setSize = ArraySet.this.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.ind < this.setSize;
        }

        @Override
        public T next() {
            if (this.ind >= this.setSize) {
                throw new NoSuchElementException();
            }
            return ArraySet.this.get(this.ind++);
        }
    }
}

