/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.genericutil;

import com.ibm.wala.demandpa.genericutil.ObjectVisitor;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.Function;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.security.Permission;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final BitSet EMPTY_BITSET = new BitSet();
    public static final boolean FULLY_QUALIFIED_NAMES = false;

    public static String str(Throwable throwable) throws IllegalArgumentException {
        if (throwable == null) {
            throw new IllegalArgumentException("thrown == null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return byteArrayOutputStream.toString();
    }

    public static <T> boolean forSome(Collection<T> collection, Predicate<T> predicate) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("c == null");
        }
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> T find(Collection<T> collection, Predicate<T> predicate) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("c == null");
        }
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> boolean forAll(Collection<T> collection, Predicate<T> predicate) throws NullPointerException {
        for (T t : collection) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> void doForAll(Collection<T> collection, ObjectVisitor<T> objectVisitor) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("c == null");
        }
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            objectVisitor.visit(iterator.next());
        }
    }

    public static <T, U> List<U> map(List<T> list, Function<T, U> function) throws IllegalArgumentException {
        if (list == null) {
            throw new IllegalArgumentException("srcList == null");
        }
        ArrayList<U> arrayList = new ArrayList<U>();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(function.apply(iterator.next()));
        }
        return arrayList;
    }

    public static <T, U> Set<U> mapToSet(Collection<T> collection, Function<T, U> function) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("srcSet == null");
        }
        HashSet hashSet = HashSetFactory.make();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.add(function.apply(iterator.next()));
        }
        return hashSet;
    }

    public static int[] realloc(int[] nArray, int n) throws IllegalArgumentException {
        if (nArray == null) {
            throw new IllegalArgumentException("data == null");
        }
        if (nArray.length < n) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    public static String objectFieldsToString(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("obj == null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        System.setSecurityManager(new SecurityManager(){

            public void checkPermission(Permission permission) {
            }
        });
        Class<?> clazz = object.getClass();
        StringBuffer stringBuffer = new StringBuffer(Util.removePackageName(clazz.getName()));
        while (clazz != Object.class) {
            Field[] fieldArray = clazz.getDeclaredFields();
            if (fieldArray.length > 0) {
                stringBuffer = stringBuffer.append(" (");
            }
            int n = 0;
            while (n < fieldArray.length) {
                fieldArray[n].setAccessible(true);
                try {
                    Class<?> clazz2 = fieldArray[n].getType();
                    String string = fieldArray[n].getName();
                    Object object2 = fieldArray[n].get(object);
                    stringBuffer = stringBuffer.append(string);
                    stringBuffer = stringBuffer.append("=");
                    stringBuffer = stringBuffer.append(object2 == null ? "null" : object2.toString());
                    stringBuffer = stringBuffer.append(" : ");
                    stringBuffer = stringBuffer.append(Util.removePackageName(clazz2.getName()));
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                stringBuffer = stringBuffer.append(n + 1 >= fieldArray.length ? ")" : ",");
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        System.setSecurityManager(securityManager);
        return stringBuffer.toString();
    }

    public static String removePackageName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static <T> boolean intersecting(Set<T> set, final Set<T> set2) {
        return Util.forSome(set, new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return set2.contains(t);
            }
        });
    }

    public static String topLevelTypeString(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("typeStr == null");
        }
        int n = string.indexOf(36);
        String string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    public static <T> void addIfNotNull(T t, Collection<T> collection) {
        if (t != null) {
            collection.add(t);
        }
    }

    public static long getUsedMemory() {
        Util.gc();
        long l = Runtime.getRuntime().totalMemory();
        Util.gc();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        return l3;
    }

    private static void gc() {
        try {
            int n = 0;
            while (n < 2) {
                System.gc();
                Thread.sleep(100L);
                System.runFinalization();
                Thread.sleep(100L);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

