/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.escape;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.escape.LocalLiveRangeAnalysis;
import com.ibm.wala.escape.TrivialMethodEscape;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.graph.traverse.DFSDiscoverTimeIterator;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.warnings.WalaException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FILiveObjectAnalysis
implements ILiveObjectAnalysis {
    private final CallGraph callGraph;
    private final HeapGraph heapGraph;
    private final Map<InstanceKey, Set<CGNode>> liveNodes = HashMapFactory.make();
    private final Set<InstanceKey> liveEverywhere = HashSetFactory.make();
    private final boolean expensiveIntraproceduralAnalysis;

    public FILiveObjectAnalysis(CallGraph callGraph, HeapGraph heapGraph, boolean bl) {
        this.callGraph = callGraph;
        this.heapGraph = heapGraph;
        this.expensiveIntraproceduralAnalysis = bl;
    }

    @Override
    public boolean mayBeLive(CGNode cGNode, int n, CGNode cGNode2, int n2) throws IllegalArgumentException, WalaException {
        if (cGNode == null) {
            throw new IllegalArgumentException("allocMethod == null");
        }
        NewSiteReference newSiteReference = TrivialMethodEscape.findAlloc(cGNode, n);
        InstanceKey instanceKey = this.heapGraph.getHeapModel().getInstanceKeyForAllocation(cGNode, newSiteReference);
        return this.mayBeLive(instanceKey, cGNode2, n2);
    }

    @Override
    public boolean mayBeLive(InstanceKey instanceKey, CGNode cGNode, int n) {
        if (this.liveEverywhere.contains(instanceKey)) {
            return true;
        }
        Set<CGNode> set = this.liveNodes.get(instanceKey);
        if (set != null) {
            if (set.contains(cGNode)) {
                if (n == -1) {
                    return true;
                }
                if (this.mayBeLiveInSomeCaller(instanceKey, cGNode)) {
                    return true;
                }
                if (this.expensiveIntraproceduralAnalysis) {
                    return this.mayBeLiveIntraprocedural(instanceKey, cGNode, n);
                }
                return true;
            }
            return false;
        }
        set = this.computeLiveNodes(instanceKey);
        this.liveNodes.put(instanceKey, set);
        return this.mayBeLive(instanceKey, cGNode, n);
    }

    private boolean mayBeLiveInSomeCaller(InstanceKey instanceKey, CGNode cGNode) {
        Iterator<CGNode> iterator = this.callGraph.getPredNodes(cGNode);
        while (iterator.hasNext()) {
            CGNode cGNode2 = iterator.next();
            if (!this.mayBeLive(instanceKey, cGNode2, -1)) continue;
            return true;
        }
        return false;
    }

    private boolean mayBeLiveIntraprocedural(InstanceKey instanceKey, CGNode cGNode, int n) {
        IR iR = cGNode.getIR();
        DefUse defUse = cGNode.getDU();
        DFSDiscoverTimeIterator<InstanceKey> dFSDiscoverTimeIterator = DFS.iterateDiscoverTime(GraphInverter.invert(this.heapGraph), instanceKey);
        while (dFSDiscoverTimeIterator.hasNext()) {
            LocalPointerKey localPointerKey;
            Object e = dFSDiscoverTimeIterator.next();
            if (!(e instanceof LocalPointerKey) || !(localPointerKey = (LocalPointerKey)e).getNode().equals(cGNode) || !LocalLiveRangeAnalysis.isLive(localPointerKey.getValueNumber(), n, iR, defUse)) continue;
            return true;
        }
        return false;
    }

    private Set<CGNode> computeLiveNodes(InstanceKey instanceKey) {
        HashSet hashSet = HashSetFactory.make();
        DFSDiscoverTimeIterator<InstanceKey> dFSDiscoverTimeIterator = DFS.iterateDiscoverTime(GraphInverter.invert(this.heapGraph), instanceKey);
        while (dFSDiscoverTimeIterator.hasNext()) {
            PointerKey pointerKey;
            Object object = dFSDiscoverTimeIterator.next();
            if (object instanceof StaticFieldKey) {
                this.liveEverywhere.add(instanceKey);
                return Collections.emptySet();
            }
            if (object instanceof AbstractLocalPointerKey) {
                pointerKey = (AbstractLocalPointerKey)object;
                hashSet.add(((AbstractLocalPointerKey)pointerKey).getNode());
                continue;
            }
            if (!(object instanceof PropagationCallGraphBuilder.TypedPointerKey)) continue;
            pointerKey = (PropagationCallGraphBuilder.TypedPointerKey)object;
            if ((object = ((PropagationCallGraphBuilder.TypedPointerKey)pointerKey).getBase()) instanceof AbstractLocalPointerKey) {
                AbstractLocalPointerKey abstractLocalPointerKey = (AbstractLocalPointerKey)object;
                hashSet.add(abstractLocalPointerKey.getNode());
                continue;
            }
            Assertions.UNREACHABLE("unexpected base of TypedPointerKey: " + object.getClass() + " " + object);
        }
        return DFS.getReachableNodes(this.callGraph, hashSet);
    }

    @Override
    public boolean mayBeLive(InstanceKey instanceKey, CGNode cGNode, IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("instructionIndices is null");
        }
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (!this.mayBeLive(instanceKey, cGNode, n)) continue;
            return true;
        }
        return false;
    }
}

