/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.escape;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.escape.IMethodEscapeAnalysis;
import com.ibm.wala.escape.INodeEscapeAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.warnings.WalaException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TrivialMethodEscape
implements IMethodEscapeAnalysis,
INodeEscapeAnalysis {
    private final HeapGraph hg;
    private final CallGraph cg;

    public TrivialMethodEscape(CallGraph callGraph, HeapGraph heapGraph) {
        this.hg = heapGraph;
        this.cg = callGraph;
    }

    public boolean mayEscape(MethodReference methodReference, int n, MethodReference methodReference2) throws WalaException {
        if (methodReference == null) {
            throw new IllegalArgumentException("null allocMethod");
        }
        Set<CGNode> set = this.cg.getNodes(methodReference2);
        if (set.size() == 0) {
            throw new WalaException("could not find call graph node for method " + methodReference2);
        }
        Set<CGNode> set2 = this.cg.getNodes(methodReference);
        if (set2.size() == 0) {
            throw new WalaException("could not find call graph node for allocation method " + methodReference);
        }
        return this.mayEscape(set2, n, set);
    }

    public boolean mayEscape(CGNode cGNode, int n, CGNode cGNode2) throws WalaException {
        return this.mayEscape(Collections.singleton(cGNode), n, Collections.singleton(cGNode2));
    }

    private boolean mayEscape(Set set, int n, Set set2) throws WalaException {
        Object object;
        Object object2;
        HashSet<CGNode> hashSet = HashSetFactory.make();
        for (ContextItem contextItem : set) {
            object2 = TrivialMethodEscape.findAlloc(contextItem, n);
            object = this.hg.getHeapModel().getInstanceKeyForAllocation((CGNode)contextItem, (NewSiteReference)object2);
            if (object == null) {
                throw new WalaException("could not get instance key at site " + object2 + " in " + contextItem);
            }
            hashSet.add((CGNode)object);
        }
        for (ContextItem contextItem : hashSet) {
            object2 = this.hg.getPredNodes(contextItem);
            while (object2.hasNext()) {
                ReturnValueKey returnValueKey;
                object = (PointerKey)object2.next();
                if (!(object instanceof AbstractLocalPointerKey)) {
                    return true;
                }
                if (!(object instanceof ReturnValueKey) || !set2.contains((returnValueKey = (ReturnValueKey)object).getNode())) continue;
                return true;
            }
        }
        return false;
    }

    static NewSiteReference findAlloc(CGNode cGNode, int n) throws WalaException {
        if (cGNode == null) {
            throw new IllegalArgumentException("null n");
        }
        Iterator<NewSiteReference> iterator = cGNode.iterateNewSites();
        while (iterator.hasNext()) {
            NewSiteReference newSiteReference = iterator.next();
            if (newSiteReference.getProgramCounter() != n) continue;
            return newSiteReference;
        }
        throw new WalaException("Failed to find an allocation at pc " + n + " in node " + cGNode);
    }
}

