/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.fixedpoint.impl;

import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixedpoint.impl.GeneralStatement;
import com.ibm.wala.fixedpoint.impl.NullaryStatement;
import com.ibm.wala.fixedpoint.impl.UnaryStatement;
import com.ibm.wala.fixpoint.IFixedPointStatement;
import com.ibm.wala.fixpoint.IFixedPointSystem;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.SparseNumberedGraph;
import com.ibm.wala.util.graph.traverse.Topological;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFixedPointSystem<T extends IVariable>
implements IFixedPointSystem<T> {
    static final boolean DEBUG = false;
    private final NumberedGraph<INodeWithNumber> graph;
    private final Set<GeneralStatement> equations = HashSetFactory.make();
    private final Set<IVariable> variables = HashSetFactory.make();

    public DefaultFixedPointSystem(int n) {
        this.graph = new SparseNumberedGraph<INodeWithNumber>(n);
    }

    public DefaultFixedPointSystem() {
        this(1);
    }

    public boolean equals(Object object) {
        return this.graph.equals(object);
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public String toString() {
        return this.graph.toString();
    }

    @Override
    public void removeStatement(IFixedPointStatement iFixedPointStatement) {
        this.graph.removeNodeAndEdges(iFixedPointStatement);
    }

    @Override
    public Iterator<AbstractStatement> getStatements() {
        return new FilterIterator<AbstractStatement>(this.graph.iterator(), new Filter(){

            public boolean accepts(Object object) {
                return object instanceof AbstractStatement;
            }
        });
    }

    @Override
    public void addStatement(IFixedPointStatement iFixedPointStatement) throws IllegalArgumentException, UnimplementedError {
        if (iFixedPointStatement == null) {
            throw new IllegalArgumentException("statement == null");
        }
        if (iFixedPointStatement instanceof UnaryStatement) {
            this.addStatement((UnaryStatement)iFixedPointStatement);
        } else if (iFixedPointStatement instanceof NullaryStatement) {
            this.addStatement((NullaryStatement)iFixedPointStatement);
        } else if (iFixedPointStatement instanceof GeneralStatement) {
            this.addStatement((GeneralStatement)iFixedPointStatement);
        } else {
            Assertions.UNREACHABLE("unexpected: " + iFixedPointStatement.getClass());
        }
    }

    public void addStatement(GeneralStatement generalStatement) {
        if (generalStatement == null) {
            throw new IllegalArgumentException("s is null");
        }
        IVariable[] iVariableArray = generalStatement.getRHS();
        Object t = generalStatement.getLHS();
        this.equations.add(generalStatement);
        this.graph.addNode(generalStatement);
        if (t != null) {
            this.variables.add((IVariable)t);
            this.graph.addNode((INodeWithNumber)t);
            this.graph.addEdge(generalStatement, (INodeWithNumber)t);
        }
        int n = 0;
        while (n < iVariableArray.length) {
            IVariable iVariable = iVariableArray[n];
            IVariable iVariable2 = iVariable;
            if (iVariable2 != null) {
                this.variables.add(iVariable2);
                this.graph.addNode(iVariable2);
                this.graph.addEdge(iVariable2, generalStatement);
            }
            ++n;
        }
    }

    public void addStatement(UnaryStatement unaryStatement) {
        if (unaryStatement == null) {
            throw new IllegalArgumentException("s is null");
        }
        Object t = unaryStatement.getLHS();
        Object t2 = unaryStatement.getRightHandSide();
        this.graph.addNode(unaryStatement);
        if (t != null) {
            this.variables.add((IVariable)t);
            this.graph.addNode((INodeWithNumber)t);
            this.graph.addEdge(unaryStatement, (INodeWithNumber)t);
        }
        this.variables.add((IVariable)t2);
        this.graph.addNode((INodeWithNumber)t2);
        this.graph.addEdge((INodeWithNumber)t2, unaryStatement);
    }

    public void addStatement(NullaryStatement nullaryStatement) {
        if (nullaryStatement == null) {
            throw new IllegalArgumentException("s is null");
        }
        Object t = nullaryStatement.getLHS();
        this.graph.addNode(nullaryStatement);
        if (t != null) {
            this.variables.add((IVariable)t);
            this.graph.addNode((INodeWithNumber)t);
            this.graph.addEdge(nullaryStatement, (INodeWithNumber)t);
        }
    }

    public void addVariable(IVariable iVariable) {
        this.variables.add(iVariable);
        this.graph.addNode(iVariable);
    }

    public AbstractStatement getStep(int n) {
        return (AbstractStatement)this.graph.getNode(n);
    }

    @Override
    public void reorder() {
        Iterator<INodeWithNumber> iterator = Topological.makeTopologicalIter(this.graph);
        int n = 0;
        while (iterator.hasNext()) {
            INodeWithNumber iNodeWithNumber = iterator.next();
            if (!(iNodeWithNumber instanceof IVariable)) continue;
            IVariable iVariable = (IVariable)iNodeWithNumber;
            iVariable.setOrderNumber(n++);
        }
    }

    private void checkGraph() {
        try {
            GraphIntegrity.check(this.graph);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    @Override
    public Iterator getStatementsThatUse(IVariable iVariable) {
        return this.graph.containsNode(iVariable) ? this.graph.getSuccNodes(iVariable) : EmptyIterator.instance();
    }

    @Override
    public Iterator getStatementsThatDef(IVariable iVariable) {
        return this.graph.containsNode(iVariable) ? this.graph.getPredNodes(iVariable) : EmptyIterator.instance();
    }

    public IVariable getVariable(int n) {
        return (IVariable)this.graph.getNode(n);
    }

    @Override
    public int getNumberOfStatementsThatUse(IVariable iVariable) {
        return this.graph.containsNode(iVariable) ? this.graph.getSuccNodeCount(iVariable) : 0;
    }

    @Override
    public int getNumberOfStatementsThatDef(IVariable iVariable) {
        return this.graph.containsNode(iVariable) ? this.graph.getPredNodeCount(iVariable) : 0;
    }

    @Override
    public Iterator<IVariable> getVariables() {
        return new FilterIterator<IVariable>(this.graph.iterator(), new Filter(){

            public boolean accepts(Object object) {
                return object instanceof IVariable;
            }
        });
    }

    public int getNumberOfNodes() {
        return this.graph.getNumberOfNodes();
    }

    public Iterator<? extends INodeWithNumber> getPredNodes(INodeWithNumber iNodeWithNumber) {
        return this.graph.getPredNodes(iNodeWithNumber);
    }

    public int getPredNodeCount(INodeWithNumber iNodeWithNumber) {
        return this.graph.getPredNodeCount(iNodeWithNumber);
    }

    @Override
    public boolean containsStatement(IFixedPointStatement iFixedPointStatement) {
        return this.equations.contains(iFixedPointStatement);
    }

    @Override
    public boolean containsVariable(IVariable iVariable) {
        return this.variables.contains(iVariable);
    }
}

