/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.Set;

public class ArgumentTypeEntrypoint
extends Entrypoint {
    private final TypeReference[][] paramTypes;
    private final IClassHierarchy cha;

    protected TypeReference[][] makeParameterTypes(IMethod iMethod) throws IllegalArgumentException {
        if (iMethod == null) {
            throw new IllegalArgumentException("method == null");
        }
        TypeReference[][] typeReferenceArray = new TypeReference[iMethod.getNumberOfParameters()][];
        int n = 0;
        while (n < typeReferenceArray.length) {
            TypeReference[] typeReferenceArray2;
            TypeReference typeReference = iMethod.getParameterType(n);
            if (!typeReference.isPrimitiveType()) {
                ArrayClass arrayClass;
                IClass iClass;
                IClass iClass2 = this.cha.lookupClass(typeReference);
                if (iClass2 == null) {
                    typeReference = null;
                } else if (!iClass2.isInterface() && iClass2.isAbstract()) {
                    typeReference = this.chooseAConcreteSubClass(iClass2);
                } else if (iClass2.isInterface()) {
                    typeReference = this.chooseAnImplementor(iClass2);
                } else if (iClass2.isArrayClass() && (iClass = (arrayClass = (ArrayClass)iClass2).getInnermostElementClass()) != null && iClass.isInterface()) {
                    TypeReference typeReference2 = this.chooseAnImplementor(iClass);
                    if (typeReference2 == null) {
                        typeReference = null;
                    } else {
                        typeReference = TypeReference.findOrCreateArrayOf(typeReference2);
                        int n2 = 1;
                        while (n2 < arrayClass.getDimensionality()) {
                            typeReference = TypeReference.findOrCreateArrayOf(typeReference);
                            ++n2;
                        }
                    }
                }
            }
            if (typeReference == null) {
                typeReferenceArray2 = new TypeReference[]{};
            } else {
                TypeReference[] typeReferenceArray3 = new TypeReference[1];
                typeReferenceArray2 = typeReferenceArray3;
                typeReferenceArray3[0] = typeReference;
            }
            typeReferenceArray[n] = typeReferenceArray2;
            ++n;
        }
        return typeReferenceArray;
    }

    private TypeReference chooseAnImplementor(IClass iClass) {
        Set<IClass> set = this.cha.getImplementors(iClass.getReference());
        if (!set.isEmpty()) {
            return set.iterator().next().getReference();
        }
        return null;
    }

    private TypeReference chooseAConcreteSubClass(IClass iClass) {
        Collection<IClass> collection = this.cha.computeSubClasses(iClass.getReference());
        for (IClass iClass2 : collection) {
            if (iClass2.isAbstract()) continue;
            return iClass2.getReference();
        }
        return null;
    }

    public ArgumentTypeEntrypoint(IMethod iMethod, IClassHierarchy iClassHierarchy) {
        super(iMethod);
        this.cha = iClassHierarchy;
        this.paramTypes = this.makeParameterTypes(iMethod);
    }

    public TypeReference[] getParameterTypes(int n) {
        return this.paramTypes[n];
    }

    public int getNumberOfParameters() {
        return this.paramTypes.length;
    }
}

