/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicCallGraph
extends AbstractNumberedGraph<CGNode>
implements CallGraph {
    private static final boolean DEBUG = false;
    private final DelegatingNumberedNodeManager<CGNode> nodeManager = new DelegatingNumberedNodeManager();
    private CGNode fakeRoot;
    private CGNode fakeWorldClinit;
    private SSAContextInterpreter interpreter;
    private final Set<CGNode> entrypointNodes = HashSetFactory.make();
    private final Map<Key, CGNode> nodes = HashMapFactory.make();
    private final Map<MethodReference, Set<CGNode>> mr2Nodes = HashMapFactory.make();

    public void init() throws CancelException {
        this.fakeRoot = this.makeFakeRootNode();
        Key key = new Key(this.fakeRoot.getMethod(), this.fakeRoot.getContext());
        this.registerNode(key, this.fakeRoot);
        this.fakeWorldClinit = this.makeFakeWorldClinitNode();
        if (this.fakeWorldClinit != null) {
            key = new Key(this.fakeWorldClinit.getMethod(), this.fakeWorldClinit.getContext());
            this.registerNode(key, this.fakeWorldClinit);
            CallSiteReference callSiteReference = CallSiteReference.make(1, this.fakeWorldClinit.getMethod().getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
            callSiteReference = ((AbstractRootMethod)this.fakeRoot.getMethod()).addInvocation(null, callSiteReference).getCallSite();
            this.fakeRoot.addTarget(callSiteReference, this.fakeWorldClinit);
        }
    }

    protected abstract CGNode makeFakeRootNode() throws CancelException;

    protected abstract CGNode makeFakeWorldClinitNode() throws CancelException;

    public abstract CGNode findOrCreateNode(IMethod var1, Context var2) throws CancelException;

    protected void registerNode(Key key, CGNode cGNode) {
        this.nodes.put(key, cGNode);
        this.addNode(cGNode);
        Set<CGNode> set = this.findOrCreateMr2Nodes(key.m);
        set.add(cGNode);
    }

    private Set<CGNode> findOrCreateMr2Nodes(IMethod iMethod) {
        Set<CGNode> set = this.mr2Nodes.get(iMethod.getReference());
        if (set == null) {
            set = HashSetFactory.make(3);
            this.mr2Nodes.put(iMethod.getReference(), set);
        }
        return set;
    }

    protected NodeImpl getNode(Key key) {
        return (NodeImpl)this.nodes.get(key);
    }

    @Override
    public CGNode getFakeRootNode() {
        return this.fakeRoot;
    }

    public CGNode getFakeWorldClinitNode() {
        return this.fakeWorldClinit;
    }

    public void registerEntrypoint(CGNode cGNode) {
        this.entrypointNodes.add(cGNode);
    }

    @Override
    public Collection<CGNode> getEntrypointNodes() {
        return this.entrypointNodes;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator<CGNode> iterator = DFS.iterateDiscoverTime(this, new NonNullSingletonIterator<CGNode>(this.getFakeRootNode()));
        while (iterator.hasNext()) {
            CGNode cGNode = iterator.next();
            stringBuffer.append(cGNode + "\n");
            if (cGNode.getMethod() == null) continue;
            Iterator<CallSiteReference> iterator2 = cGNode.iterateCallSites();
            while (iterator2.hasNext()) {
                CallSiteReference callSiteReference = iterator2.next();
                Iterator<CGNode> iterator3 = this.getPossibleTargets(cGNode, callSiteReference).iterator();
                if (iterator3.hasNext()) {
                    stringBuffer.append(" - " + callSiteReference + "\n");
                }
                while (iterator3.hasNext()) {
                    CGNode cGNode2 = iterator3.next();
                    stringBuffer.append("     -> " + cGNode2 + "\n");
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void removeNodeAndEdges(CGNode cGNode) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public CGNode getNode(IMethod iMethod, Context context) {
        Key key = new Key(iMethod, context);
        return this.getNode(key);
    }

    @Override
    public Set<CGNode> getNodes(MethodReference methodReference) {
        IMethod iMethod = this.getClassHierarchy().resolveMethod(methodReference);
        if (iMethod == null) {
            return Collections.emptySet();
        }
        Set<CGNode> set = this.mr2Nodes.get(iMethod.getReference());
        Set set2 = Collections.emptySet();
        return set == null ? set2 : set;
    }

    protected SSAContextInterpreter getInterpreter(CGNode cGNode) {
        if (this.interpreter == null) {
            throw new IllegalStateException("must register an interpreter for this call graph");
        }
        return this.interpreter;
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    @Override
    public Iterator<CGNode> iterator() {
        return this.nodes.values().iterator();
    }

    @Override
    public boolean containsNode(CGNode cGNode) {
        if (cGNode == null) {
            throw new IllegalArgumentException("N is null");
        }
        return this.getNode(cGNode.getMethod(), cGNode.getContext()) != null;
    }

    public void setInterpreter(SSAContextInterpreter sSAContextInterpreter) {
        this.interpreter = sSAContextInterpreter;
    }

    @Override
    protected NodeManager<CGNode> getNodeManager() {
        return this.nodeManager;
    }

    public void summarizeByPackage() {
        HashMap<String, Integer> hashMap = HashMapFactory.make();
        block0: for (CGNode object : this) {
            String string = String.valueOf(object.getMethod().getDeclaringClass().getName().toString()) + "/" + object.getMethod().getName() + "/" + object.getContext().getClass().toString();
            if (object.getContext() instanceof ReceiverInstanceContext) {
                string = String.valueOf(string) + "/" + ((ReceiverInstanceContext)object.getContext()).getReceiver().getConcreteType().getName();
            } else if (object.getContext() instanceof JavaTypeContext) {
                string = String.valueOf(string) + "/" + ((JavaTypeContext)object.getContext()).getType().getTypeReference().getName();
            }
            while (true) {
                if (hashMap.containsKey(string)) {
                    hashMap.put(string, 1 + (Integer)hashMap.get(string));
                } else {
                    hashMap.put(string, 1);
                }
                if (string.indexOf(47) < 0) continue block0;
                string = string.substring(0, string.lastIndexOf(47));
            }
        }
        System.err.println("dump of CG");
        for (Map.Entry entry : hashMap.entrySet()) {
            System.err.println(String.valueOf((Integer)entry.getValue()) + " " + (String)entry.getKey());
        }
    }

    protected static final class Key {
        private final IMethod m;
        private final Context C;

        public Key(IMethod iMethod, Context context) {
            assert (iMethod != null) : "null method";
            assert (context != null) : "null context";
            this.m = iMethod;
            this.C = context;
        }

        public int hashCode() {
            return 17 * this.m.hashCode() + this.C.hashCode();
        }

        public boolean equals(Object object) {
            assert (object instanceof Key);
            Key key = (Key)object;
            return this.m.equals(key.m) && this.C.equals(key.C);
        }

        public String toString() {
            return "{" + this.m + "," + this.C + "}";
        }
    }

    public abstract class NodeImpl
    extends NodeWithNumber
    implements CGNode {
        protected final IMethod method;
        private final Context context;

        protected NodeImpl(IMethod iMethod, Context context) {
            this.method = iMethod;
            this.context = context;
            if (iMethod != null && !iMethod.isSynthetic() && iMethod.isAbstract()) assert (!iMethod.isAbstract()) : "Abstract method " + iMethod;
            assert (context != null);
        }

        public IMethod getMethod() {
            return this.method;
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public String toString() {
            return "Node: " + this.method.toString() + " Context: " + this.context.toString();
        }

        public Context getContext() {
            return this.context;
        }

        public abstract boolean addTarget(CallSiteReference var1, CGNode var2);

        public IClassHierarchy getClassHierarchy() {
            return this.method.getClassHierarchy();
        }
    }
}

