/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

public final class ConcreteTypeKey
implements InstanceKey {
    private final IClass type;

    public ConcreteTypeKey(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (iClass.isInterface()) {
            Assertions.UNREACHABLE("unexpected interface: " + iClass);
        }
        this.type = iClass;
    }

    public boolean equals(Object object) {
        if (object instanceof ConcreteTypeKey) {
            ConcreteTypeKey concreteTypeKey = (ConcreteTypeKey)object;
            return this.type.equals(concreteTypeKey.type);
        }
        return false;
    }

    public int hashCode() {
        return 461 * this.type.hashCode();
    }

    public String toString() {
        return "[" + this.type + "]";
    }

    public IClass getType() {
        return this.type;
    }

    public IClass getConcreteType() {
        return this.type;
    }

    public static InstanceKey[] getInstanceKeysForPEI(SSAInstruction sSAInstruction, IR iR, IClassHierarchy iClassHierarchy) {
        if (sSAInstruction == null) {
            throw new IllegalArgumentException("pei is null");
        }
        Collection<TypeReference> collection = sSAInstruction.getExceptionTypes();
        if (collection == null) {
            return null;
        }
        InstanceKey[] instanceKeyArray = new InstanceKey[collection.size()];
        int n = 0;
        for (TypeReference typeReference : collection) {
            assert (typeReference != null);
            IClass iClass = iClassHierarchy.lookupClass(typeReference);
            instanceKeyArray[n++] = new ConcreteTypeKey(iClass);
        }
        return instanceKeyArray;
    }
}

