/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;

public class ContainerUtil {
    private static final TypeName FreezableListName = TypeName.string2TypeName("Lcom/sun/corba/se/internal/ior/FreezableList");
    public static final TypeReference FreezableList = TypeReference.findOrCreate(ClassLoaderReference.Primordial, FreezableListName);
    private static final TypeName JarAttributesName = TypeName.string2TypeName("Ljava/util/jar/Attributes");
    public static final TypeReference JarAttributes = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JarAttributesName);
    private static final Collection<TypeReference> miscContainers = HashSetFactory.make();

    static {
        miscContainers.add(FreezableList);
        miscContainers.add(JarAttributes);
    }

    public static boolean isContainer(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (ClassLoaderReference.Primordial.equals(iClass.getClassLoader().getReference()) && TypeReference.JavaUtilCollection.getName().getPackage().equals(iClass.getReference().getName().getPackage())) {
            IClass iClass2 = iClass.getClassHierarchy().lookupClass(TypeReference.JavaUtilCollection);
            IClass iClass3 = iClass.getClassHierarchy().lookupClass(TypeReference.JavaUtilMap);
            if (iClass.isInterface()) {
                assert (iClass2 != null);
                assert (iClass3 != null);
                Collection<IClass> collection = iClass.getAllImplementedInterfaces();
                if (collection.contains(iClass2) || collection.contains(iClass3)) {
                    return true;
                }
            } else if (iClass.getClassHierarchy().implementsInterface(iClass, iClass2) || iClass.getClassHierarchy().implementsInterface(iClass, iClass3)) {
                return true;
            }
        }
        if (miscContainers.contains(iClass.getReference())) {
            return true;
        }
        return iClass.isArrayClass() && ((ArrayClass)iClass).getElementClass() != null && ((ArrayClass)iClass).getElementClass().getReference().isReferenceType();
    }
}

