/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.analysis.reflection.IllegalArgumentExceptionContext;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticClass;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AssignOperator;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.IPointerOperator;
import com.ibm.wala.ipa.callgraph.propagation.IPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.UnarySideEffect;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropagationCallGraphBuilder
implements CallGraphBuilder {
    private static final boolean DEBUG_ALL = false;
    static final boolean DEBUG_ASSIGN = false;
    private static final boolean DEBUG_ARRAY_LOAD = false;
    private static final boolean DEBUG_ARRAY_STORE = false;
    private static final boolean DEBUG_FILTER = false;
    protected static final boolean DEBUG_GENERAL = false;
    private static final boolean DEBUG_GET = false;
    private static final boolean DEBUG_PUT = false;
    private static final boolean DEBUG_ENTRYPOINTS = false;
    protected final PointerKeyFactory pointerKeyFactory;
    private final IClass JAVA_LANG_OBJECT;
    protected final IClassHierarchy cha;
    protected final AnalysisOptions options;
    private final AnalysisCache analysisCache;
    private final Set<CGNode> alreadyVisited = HashSetFactory.make();
    private Set<CGNode> discoveredNodes = HashSetFactory.make();
    protected final Set<CallSiteReference> entrypointCallSites = HashSetFactory.make();
    protected PropagationSystem system;
    private IPointsToSolver solver;
    protected final ExplicitCallGraph callGraph;
    protected static final AssignOperator assignOperator = new AssignOperator();
    public final FilterOperator filterOperator = new FilterOperator();
    protected final InverseFilterOperator inverseFilterOperator = new InverseFilterOperator();
    private SSAContextInterpreter contextInterpreter;
    protected ContextSelector contextSelector;
    protected InstanceKeyFactory instanceKeyFactory;
    private final boolean rememberGetPutHistory = true;

    protected PropagationCallGraphBuilder(IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache, PointerKeyFactory pointerKeyFactory) {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("cha is null");
        }
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        assert (analysisCache != null);
        this.cha = iClassHierarchy;
        this.options = analysisOptions;
        this.analysisCache = analysisCache;
        assert (pointerKeyFactory != null);
        this.pointerKeyFactory = pointerKeyFactory;
        this.callGraph = this.createEmptyCallGraph(iClassHierarchy, analysisOptions);
        try {
            this.callGraph.init();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        this.callGraph.setInterpreter(this.contextInterpreter);
        this.JAVA_LANG_OBJECT = iClassHierarchy.lookupClass(TypeReference.JavaLangObject);
    }

    protected ExplicitCallGraph createEmptyCallGraph(IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions) {
        return new ExplicitCallGraph(iClassHierarchy, analysisOptions, this.getAnalysisCache());
    }

    protected boolean isJavaLangObject(IClass iClass) {
        return iClass.getReference().equals(TypeReference.JavaLangObject);
    }

    public CallGraph makeCallGraph(AnalysisOptions analysisOptions) throws IllegalArgumentException, CancelException {
        return this.makeCallGraph(analysisOptions, null);
    }

    @Override
    public CallGraph makeCallGraph(AnalysisOptions analysisOptions, IProgressMonitor iProgressMonitor) throws IllegalArgumentException, CallGraphBuilderCancelException {
        if (analysisOptions == null) {
            throw new IllegalArgumentException("options is null");
        }
        this.system = this.makeSystem(analysisOptions);
        this.system.setMinEquationsForTopSort(analysisOptions.getMinEquationsForTopSort());
        this.system.setTopologicalGrowthFactor(analysisOptions.getTopologicalGrowthFactor());
        this.system.setMaxEvalBetweenTopo(analysisOptions.getMaxEvalBetweenTopo());
        this.discoveredNodes = HashSetFactory.make();
        this.discoveredNodes.add(this.callGraph.getFakeRootNode());
        for (Entrypoint object : analysisOptions.getEntrypoints()) {
            SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = object.addCall((AbstractRootMethod)this.callGraph.getFakeRootNode().getMethod());
            if (sSAAbstractInvokeInstruction == null) {
                Warnings.add(EntrypointResolutionWarning.create(object));
                continue;
            }
            this.entrypointCallSites.add(sSAAbstractInvokeInstruction.getCallSite());
        }
        this.customInit();
        this.solver = this.makeSolver();
        try {
            this.solver.solve(iProgressMonitor);
        }
        catch (CancelException cancelException) {
            CallGraphBuilderCancelException callGraphBuilderCancelException = CallGraphBuilderCancelException.createCallGraphBuilderCancelException(cancelException, (CallGraph)this.callGraph, this.system.extractPointerAnalysis(this));
            throw callGraphBuilderCancelException;
        }
        return this.callGraph;
    }

    protected PropagationSystem makeSystem(AnalysisOptions analysisOptions) {
        return new PropagationSystem(this.callGraph, this.pointerKeyFactory, this.instanceKeyFactory);
    }

    protected abstract IPointsToSolver makeSolver();

    protected void customInit() {
    }

    protected abstract boolean addConstraintsFromNode(CGNode var1);

    protected boolean addConstraintsFromNewNodes() {
        boolean bl = false;
        while (!this.discoveredNodes.isEmpty()) {
            Iterator<CGNode> iterator = this.discoveredNodes.iterator();
            this.discoveredNodes = HashSetFactory.make();
            while (iterator.hasNext()) {
                CGNode cGNode = iterator.next();
                bl |= this.addConstraintsFromNode(cGNode);
            }
        }
        return bl;
    }

    public PointerKey getPointerKeyForLocal(CGNode cGNode, int n) {
        return this.pointerKeyFactory.getPointerKeyForLocal(cGNode, n);
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode cGNode, int n, FilteredPointerKey.TypeFilter typeFilter) {
        assert (typeFilter != null);
        return this.pointerKeyFactory.getFilteredPointerKeyForLocal(cGNode, n, typeFilter);
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode cGNode, int n, IClass iClass) {
        return this.getFilteredPointerKeyForLocal(cGNode, n, new FilteredPointerKey.SingleClassFilter(iClass));
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode cGNode, int n, InstanceKey instanceKey) {
        return this.getFilteredPointerKeyForLocal(cGNode, n, new FilteredPointerKey.SingleInstanceFilter(instanceKey));
    }

    public PointerKey getPointerKeyForReturnValue(CGNode cGNode) {
        return this.pointerKeyFactory.getPointerKeyForReturnValue(cGNode);
    }

    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode cGNode) {
        return this.pointerKeyFactory.getPointerKeyForExceptionalReturnValue(cGNode);
    }

    public PointerKey getPointerKeyForStaticField(IField iField) {
        assert (iField != null) : "null FieldReference";
        return this.pointerKeyFactory.getPointerKeyForStaticField(iField);
    }

    public PointerKey getPointerKeyForInstanceField(InstanceKey instanceKey, IField iField) {
        if (iField == null) {
            throw new IllegalArgumentException("field is null");
        }
        if (instanceKey == null) {
            throw new IllegalArgumentException("I is null");
        }
        IClass iClass = iField.getDeclaringClass();
        IClass iClass2 = instanceKey.getConcreteType();
        if (!(iClass2 instanceof SyntheticClass) && !this.getClassHierarchy().isSubclassOf(iClass2, iClass)) {
            return null;
        }
        return this.pointerKeyFactory.getPointerKeyForInstanceField(instanceKey, iField);
    }

    public PointerKey getPointerKeyForArrayContents(InstanceKey instanceKey) {
        if (instanceKey == null) {
            throw new IllegalArgumentException("I is null");
        }
        IClass iClass = instanceKey.getConcreteType();
        if (!iClass.isArrayClass()) assert (false) : "illegal arguments: " + instanceKey;
        return this.pointerKeyFactory.getPointerKeyForArrayContents(instanceKey);
    }

    protected void assignInstanceToCatch(PointerKey pointerKey, Set<IClass> set, InstanceKey instanceKey) {
        if (PropagationCallGraphBuilder.catches(set, instanceKey.getConcreteType(), this.cha)) {
            this.system.newConstraint(pointerKey, instanceKey);
        }
    }

    protected void addAssignmentsForCatchPointerKey(PointerKey pointerKey, Set<IClass> set, PointerKey pointerKey2) {
        for (IClass iClass : set) {
            if (iClass.getReference().equals(iClass.getClassLoader().getLanguage().getThrowableType())) {
                this.system.newConstraint(pointerKey, assignOperator, pointerKey2);
                continue;
            }
            TypedPointerKey typedPointerKey = TypedPointerKey.make(pointerKey, iClass);
            this.system.newConstraint((PointerKey)typedPointerKey, this.filterOperator, pointerKey2);
            this.system.newConstraint(pointerKey, assignOperator, (PointerKey)typedPointerKey);
        }
    }

    public static boolean catches(Set<IClass> set, IClass iClass, IClassHierarchy iClassHierarchy) {
        IClass iClass22;
        if (set == null) {
            throw new IllegalArgumentException("catchClasses is null");
        }
        if (set.size() == 1 && (iClass22 = set.iterator().next()) != null && iClass22.getReference().equals(TypeReference.JavaLangThread)) {
            return true;
        }
        for (IClass iClass22 : set) {
            if (iClass22 == null || !iClassHierarchy.isAssignableFrom(iClass22, iClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean representsNullType(InstanceKey instanceKey) throws IllegalArgumentException {
        if (instanceKey == null) {
            throw new IllegalArgumentException("key == null");
        }
        IClass iClass = instanceKey.getConcreteType();
        Language language = iClass.getClassLoader().getLanguage();
        return language.isNullType(iClass.getReference());
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public AnalysisOptions getOptions() {
        return this.options;
    }

    public IClass getJavaLangObject() {
        return this.JAVA_LANG_OBJECT;
    }

    public ExplicitCallGraph getCallGraph() {
        return this.callGraph;
    }

    public void setContextInterpreter(SSAContextInterpreter sSAContextInterpreter) {
        this.contextInterpreter = sSAContextInterpreter;
        this.callGraph.setInterpreter(sSAContextInterpreter);
    }

    @Override
    public PointerAnalysis getPointerAnalysis() {
        return this.system.extractPointerAnalysis(this);
    }

    public PropagationSystem getPropagationSystem() {
        return this.system;
    }

    public PointerKeyFactory getPointerKeyFactory() {
        return this.pointerKeyFactory;
    }

    public RTAContextInterpreter getContextInterpreter() {
        return this.contextInterpreter;
    }

    public CGNode getTargetForCall(CGNode cGNode, CallSiteReference callSiteReference, InstanceKey instanceKey) {
        IClass iClass = instanceKey != null ? instanceKey.getConcreteType() : null;
        IMethod iMethod = this.options.getMethodTargetSelector().getCalleeTarget(cGNode, callSiteReference, iClass);
        if (iMethod == null || iMethod.isAbstract()) {
            return null;
        }
        Context context = this.contextSelector.getCalleeTarget(cGNode, callSiteReference, iMethod, instanceKey);
        if (context instanceof IllegalArgumentExceptionContext) {
            return null;
        }
        try {
            return this.getCallGraph().findOrCreateNode(iMethod, context);
        }
        catch (CancelException cancelException) {
            return null;
        }
    }

    public ContextSelector getContextSelector() {
        return this.contextSelector;
    }

    public void setContextSelector(ContextSelector contextSelector) {
        this.contextSelector = contextSelector;
    }

    public InstanceKeyFactory getInstanceKeys() {
        return this.instanceKeyFactory;
    }

    public void setInstanceKeys(InstanceKeyFactory instanceKeyFactory) {
        this.instanceKeyFactory = instanceKeyFactory;
    }

    public InstanceKey getInstanceKeyForAllocation(CGNode cGNode, NewSiteReference newSiteReference) {
        return this.instanceKeyFactory.getInstanceKeyForAllocation(cGNode, newSiteReference);
    }

    public InstanceKey getInstanceKeyForMultiNewArray(CGNode cGNode, NewSiteReference newSiteReference, int n) {
        return this.instanceKeyFactory.getInstanceKeyForMultiNewArray(cGNode, newSiteReference, n);
    }

    public <T> InstanceKey getInstanceKeyForConstant(TypeReference typeReference, T t) {
        return this.instanceKeyFactory.getInstanceKeyForConstant(typeReference, t);
    }

    public InstanceKey getInstanceKeyForClassObject(TypeReference typeReference) {
        return this.instanceKeyFactory.getInstanceKeyForClassObject(typeReference);
    }

    public boolean haveAlreadyVisited(CGNode cGNode) {
        return this.alreadyVisited.contains(cGNode);
    }

    protected void markAlreadyVisited(CGNode cGNode) {
        this.alreadyVisited.add(cGNode);
    }

    public void markDiscovered(CGNode cGNode) {
        this.discoveredNodes.add(cGNode);
    }

    protected void markChanged(CGNode cGNode) {
        this.alreadyVisited.remove(cGNode);
        this.discoveredNodes.add(cGNode);
    }

    protected boolean wasChanged(CGNode cGNode) {
        return this.discoveredNodes.contains(cGNode) && !this.alreadyVisited.contains(cGNode);
    }

    protected MutableIntSet getMutableInstanceKeysForClass(IClass iClass) {
        return this.system.cloneInstanceKeysForClass(iClass);
    }

    protected IntSet getInstanceKeysForClass(IClass iClass) {
        return this.system.getInstanceKeysForClass(iClass);
    }

    protected IntSet filterForClass(IntSet intSet, IClass iClass) {
        MutableIntSet mutableIntSet = null;
        if (iClass.getReference().equals(TypeReference.JavaLangObject)) {
            return intSet;
        }
        mutableIntSet = this.getMutableInstanceKeysForClass(iClass);
        boolean bl = false;
        mutableIntSet.intersectWith(intSet);
        return mutableIntSet;
    }

    protected IPointsToSolver getSolver() {
        return this.solver;
    }

    public void addConstraintsFromChangedNode(CGNode cGNode) {
        this.unconditionallyAddConstraintsFromNode(cGNode);
    }

    protected abstract boolean unconditionallyAddConstraintsFromNode(CGNode var1);

    @Override
    public AnalysisCache getAnalysisCache() {
        return this.analysisCache;
    }

    public final class ArrayLoadOperator
    extends UnarySideEffect
    implements IPointerOperator {
        protected final MutableIntSet priorInstances;

        public String toString() {
            return "ArrayLoad";
        }

        public ArrayLoadOperator(PointsToSetVariable pointsToSetVariable) {
            super(pointsToSetVariable);
            this.priorInstances = IntSetUtil.make();
            PropagationCallGraphBuilder.this.system.registerFixedSet(pointsToSetVariable, this);
        }

        public byte evaluate(PointsToSetVariable pointsToSetVariable) {
            if (pointsToSetVariable.size() == 0) {
                return 0;
            }
            final PointerKey pointerKey = pointsToSetVariable.getPointerKey();
            PointsToSetVariable pointsToSetVariable2 = this.getFixedSet();
            final PointerKey pointerKey2 = pointsToSetVariable2.getPointerKey();
            final MutableBoolean mutableBoolean = new MutableBoolean();
            IntSetAction intSetAction = new IntSetAction(){

                public void act(int n) {
                    InstanceKey instanceKey = ((ArrayLoadOperator)ArrayLoadOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(n);
                    if (!instanceKey.getConcreteType().isArrayClass()) {
                        return;
                    }
                    TypeReference typeReference = instanceKey.getConcreteType().getReference().getArrayElementType();
                    if (typeReference.isPrimitiveType()) {
                        return;
                    }
                    PointerKey pointerKey3 = PropagationCallGraphBuilder.this.getPointerKeyForArrayContents(instanceKey);
                    if (pointerKey3 == null) {
                        return;
                    }
                    mutableBoolean.b |= ((ArrayLoadOperator)ArrayLoadOperator.this).PropagationCallGraphBuilder.this.system.newFieldRead(pointerKey2, assignOperator, pointerKey3, pointerKey);
                }
            };
            if (this.priorInstances != null) {
                pointsToSetVariable.getValue().foreachExcluding(this.priorInstances, intSetAction);
                this.priorInstances.addAll(pointsToSetVariable.getValue());
            } else {
                pointsToSetVariable.getValue().foreach(intSetAction);
            }
            int n = mutableBoolean.b ? 4 : 0;
            return (byte)(0 | n);
        }

        public int hashCode() {
            return 9871 + super.hashCode();
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        protected boolean isLoadOperator() {
            return true;
        }

        public boolean isComplex() {
            return true;
        }
    }

    public final class ArrayStoreOperator
    extends UnarySideEffect
    implements IPointerOperator {
        public String toString() {
            return "ArrayStore";
        }

        public ArrayStoreOperator(PointsToSetVariable pointsToSetVariable) {
            super(pointsToSetVariable);
            PropagationCallGraphBuilder.this.system.registerFixedSet(pointsToSetVariable, this);
        }

        public byte evaluate(PointsToSetVariable pointsToSetVariable) {
            if (pointsToSetVariable.size() == 0) {
                return 0;
            }
            PointerKey pointerKey = pointsToSetVariable.getPointerKey();
            PointsToSetVariable pointsToSetVariable2 = this.getFixedSet();
            PointerKey pointerKey2 = pointsToSetVariable2.getPointerKey();
            List<InstanceKey> list = PropagationCallGraphBuilder.this.system.getInstances(pointsToSetVariable.getValue());
            boolean bl = false;
            for (InstanceKey instanceKey : list) {
                TypeReference typeReference;
                if (!instanceKey.getConcreteType().isArrayClass() || (typeReference = instanceKey.getConcreteType().getReference().getArrayElementType()).isPrimitiveType()) continue;
                IClass iClass = PropagationCallGraphBuilder.this.getClassHierarchy().lookupClass(typeReference);
                if (iClass == null) assert (false) : "null type for " + typeReference + " " + instanceKey.getConcreteType();
                PointerKey pointerKey3 = PropagationCallGraphBuilder.this.getPointerKeyForArrayContents(instanceKey);
                if (PropagationCallGraphBuilder.this.isJavaLangObject(iClass)) {
                    bl |= PropagationCallGraphBuilder.this.system.newFieldWrite(pointerKey3, assignOperator, pointerKey2, pointerKey);
                    continue;
                }
                bl |= PropagationCallGraphBuilder.this.system.newFieldWrite(pointerKey3, PropagationCallGraphBuilder.this.filterOperator, pointerKey2, pointerKey);
            }
            int n = bl ? 4 : 0;
            return (byte)(0 | n);
        }

        public int hashCode() {
            return 9859 + super.hashCode();
        }

        public boolean isComplex() {
            return true;
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        protected boolean isLoadOperator() {
            return false;
        }
    }

    private static class EntrypointResolutionWarning
    extends Warning {
        final Entrypoint entrypoint;

        EntrypointResolutionWarning(Entrypoint entrypoint) {
            super((byte)2);
            this.entrypoint = entrypoint;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.entrypoint;
        }

        public static EntrypointResolutionWarning create(Entrypoint entrypoint) {
            return new EntrypointResolutionWarning(entrypoint);
        }
    }

    private static class ExceptionLookupFailure
    extends Warning {
        final TypeReference t;

        ExceptionLookupFailure(TypeReference typeReference) {
            super((byte)2);
            this.t = typeReference;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.t;
        }

        public static ExceptionLookupFailure create(TypeReference typeReference) {
            return new ExceptionLookupFailure(typeReference);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FilterOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        protected FilterOperator() {
        }

        @Override
        public byte evaluate(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            FilteredPointerKey filteredPointerKey = (FilteredPointerKey)pointsToSetVariable.getPointerKey();
            if (pointsToSetVariable2.size() == 0) {
                return 0;
            }
            boolean bl = false;
            FilteredPointerKey.TypeFilter typeFilter = filteredPointerKey.getTypeFilter();
            bl = typeFilter.addFiltered(PropagationCallGraphBuilder.this.system, pointsToSetVariable, pointsToSetVariable2);
            return bl ? (byte)1 : 0;
        }

        @Override
        public boolean isComplex() {
            return false;
        }

        @Override
        public String toString() {
            return "Filter ";
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        public int hashCode() {
            return 88651;
        }
    }

    public class GetFieldOperator
    extends UnarySideEffect
    implements IPointerOperator {
        private final IField field;
        protected final MutableIntSet priorInstances;

        public GetFieldOperator(IField iField, PointsToSetVariable pointsToSetVariable) {
            super(pointsToSetVariable);
            this.priorInstances = IntSetUtil.make();
            this.field = iField;
            PropagationCallGraphBuilder.this.system.registerFixedSet(pointsToSetVariable, this);
        }

        public String toString() {
            return "GetField " + this.getField() + "," + this.getFixedSet().getPointerKey();
        }

        public byte evaluate(PointsToSetVariable pointsToSetVariable) {
            PointsToSetVariable pointsToSetVariable2 = pointsToSetVariable;
            if (pointsToSetVariable2.size() == 0) {
                return 0;
            }
            final PointerKey pointerKey = pointsToSetVariable2.getPointerKey();
            PointsToSetVariable pointsToSetVariable3 = this.getFixedSet();
            final PointerKey pointerKey2 = pointsToSetVariable3.getPointerKey();
            IntSet intSet = this.filterInstances(pointsToSetVariable2.getValue());
            final MutableBoolean mutableBoolean = new MutableBoolean();
            IntSetAction intSetAction = new IntSetAction(){

                public void act(int n) {
                    PointerKey pointerKey3;
                    InstanceKey instanceKey = ((GetFieldOperator)GetFieldOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(n);
                    if (!PropagationCallGraphBuilder.representsNullType(instanceKey) && (pointerKey3 = PropagationCallGraphBuilder.this.getPointerKeyForInstanceField(instanceKey, GetFieldOperator.this.getField())) != null) {
                        mutableBoolean.b |= ((GetFieldOperator)GetFieldOperator.this).PropagationCallGraphBuilder.this.system.newFieldRead(pointerKey2, assignOperator, pointerKey3, pointerKey);
                    }
                }
            };
            if (this.priorInstances != null) {
                intSet.foreachExcluding(this.priorInstances, intSetAction);
                this.priorInstances.addAll(intSet);
            } else {
                intSet.foreach(intSetAction);
            }
            int n = mutableBoolean.b ? 4 : 0;
            return (byte)(0 | n);
        }

        protected IntSet filterInstances(IntSet intSet) {
            return intSet;
        }

        public int hashCode() {
            return 9857 * this.getField().hashCode() + this.getFixedSet().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof GetFieldOperator) {
                GetFieldOperator getFieldOperator = (GetFieldOperator)object;
                return this.getField().equals(getFieldOperator.getField()) && this.getFixedSet().equals(getFieldOperator.getFixedSet());
            }
            return false;
        }

        protected IField getField() {
            return this.field;
        }

        protected boolean isLoadOperator() {
            return true;
        }

        public boolean isComplex() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class InstanceArrayStoreOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        private final InstanceKey instance;
        protected final MutableIntSet priorInstances = IntSetUtil.make();

        @Override
        public String toString() {
            return "InstanceArrayStore ";
        }

        public InstanceArrayStoreOperator(InstanceKey instanceKey) {
            this.instance = instanceKey;
        }

        @Override
        public byte evaluate(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            PointsToSetVariable pointsToSetVariable3 = pointsToSetVariable2;
            if (pointsToSetVariable3.size() == 0) {
                return 0;
            }
            MutableIntSet mutableIntSet = pointsToSetVariable3.getValue();
            final MutableBoolean mutableBoolean = new MutableBoolean();
            IntSetAction intSetAction = new IntSetAction(){

                public void act(int n) {
                    InstanceKey instanceKey = ((InstanceArrayStoreOperator)InstanceArrayStoreOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(n);
                    if (!instanceKey.getConcreteType().isArrayClass()) {
                        return;
                    }
                    TypeReference typeReference = instanceKey.getConcreteType().getReference().getArrayElementType();
                    if (typeReference.isPrimitiveType()) {
                        return;
                    }
                    IClass iClass = PropagationCallGraphBuilder.this.getClassHierarchy().lookupClass(typeReference);
                    if (iClass == null && !$assertionsDisabled) {
                        throw new AssertionError((Object)("null type for " + typeReference + " " + instanceKey.getConcreteType()));
                    }
                    PointerKey pointerKey = PropagationCallGraphBuilder.this.getPointerKeyForArrayContents(instanceKey);
                    if (iClass.isInterface()) {
                        if (PropagationCallGraphBuilder.this.getClassHierarchy().implementsInterface(InstanceArrayStoreOperator.this.instance.getConcreteType(), iClass)) {
                            mutableBoolean.b |= ((InstanceArrayStoreOperator)InstanceArrayStoreOperator.this).PropagationCallGraphBuilder.this.system.newConstraint(pointerKey, InstanceArrayStoreOperator.this.instance);
                        }
                    } else if (PropagationCallGraphBuilder.this.getClassHierarchy().isSubclassOf(InstanceArrayStoreOperator.this.instance.getConcreteType(), iClass)) {
                        mutableBoolean.b |= ((InstanceArrayStoreOperator)InstanceArrayStoreOperator.this).PropagationCallGraphBuilder.this.system.newConstraint(pointerKey, InstanceArrayStoreOperator.this.instance);
                    }
                }
            };
            if (this.priorInstances != null) {
                mutableIntSet.foreachExcluding(this.priorInstances, intSetAction);
                this.priorInstances.addAll(mutableIntSet);
            } else {
                mutableIntSet.foreach(intSetAction);
            }
            int n = mutableBoolean.b ? 4 : 0;
            return (byte)(0 | n);
        }

        @Override
        public int hashCode() {
            return 9839 * this.instance.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof InstanceArrayStoreOperator) {
                InstanceArrayStoreOperator instanceArrayStoreOperator = (InstanceArrayStoreOperator)object;
                return this.instance.equals(instanceArrayStoreOperator.instance);
            }
            return false;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class InstancePutFieldOperator
    extends UnaryOperator<PointsToSetVariable>
    implements IPointerOperator {
        private final IField field;
        private final InstanceKey instance;
        protected final MutableIntSet priorInstances = IntSetUtil.make();

        @Override
        public String toString() {
            return "InstancePutField" + this.field;
        }

        public InstancePutFieldOperator(IField iField, InstanceKey instanceKey) {
            this.field = iField;
            this.instance = instanceKey;
        }

        @Override
        public byte evaluate(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            PointsToSetVariable pointsToSetVariable3 = pointsToSetVariable2;
            if (pointsToSetVariable3.size() == 0) {
                return 0;
            }
            MutableIntSet mutableIntSet = pointsToSetVariable3.getValue();
            final MutableBoolean mutableBoolean = new MutableBoolean();
            IntSetAction intSetAction = new IntSetAction(){

                public void act(int n) {
                    PointerKey pointerKey;
                    InstanceKey instanceKey = ((InstancePutFieldOperator)InstancePutFieldOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(n);
                    if (!PropagationCallGraphBuilder.representsNullType(instanceKey) && (pointerKey = PropagationCallGraphBuilder.this.getPointerKeyForInstanceField(instanceKey, InstancePutFieldOperator.this.field)) != null) {
                        mutableBoolean.b |= ((InstancePutFieldOperator)InstancePutFieldOperator.this).PropagationCallGraphBuilder.this.system.newConstraint(pointerKey, InstancePutFieldOperator.this.instance);
                    }
                }
            };
            if (this.priorInstances != null) {
                mutableIntSet.foreachExcluding(this.priorInstances, intSetAction);
                this.priorInstances.addAll(mutableIntSet);
            } else {
                mutableIntSet.foreach(intSetAction);
            }
            int n = mutableBoolean.b ? 4 : 0;
            return (byte)(0 | n);
        }

        @Override
        public int hashCode() {
            return this.field.hashCode() + 9839 * this.instance.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof InstancePutFieldOperator) {
                InstancePutFieldOperator instancePutFieldOperator = (InstancePutFieldOperator)object;
                return this.field.equals(instancePutFieldOperator.field) && this.instance.equals(instancePutFieldOperator.instance);
            }
            return false;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    protected class InverseFilterOperator
    extends FilterOperator {
        public String toString() {
            return "InverseFilter";
        }

        public boolean isComplex() {
            return false;
        }

        public byte evaluate(PointsToSetVariable pointsToSetVariable, PointsToSetVariable pointsToSetVariable2) {
            FilteredPointerKey filteredPointerKey = (FilteredPointerKey)pointsToSetVariable.getPointerKey();
            FilteredPointerKey.TypeFilter typeFilter = filteredPointerKey.getTypeFilter();
            boolean bl = false;
            if (pointsToSetVariable2.size() == 0) {
                return 0;
            }
            boolean bl2 = typeFilter.addInverseFiltered(PropagationCallGraphBuilder.this.system, pointsToSetVariable, pointsToSetVariable2);
            return bl2 ? (byte)1 : 0;
        }
    }

    protected static class MutableBoolean {
        boolean b = false;

        protected MutableBoolean() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PutFieldOperator
    extends UnarySideEffect
    implements IPointerOperator {
        private final IField field;
        protected final MutableIntSet priorInstances;

        @Override
        public String toString() {
            return "PutField" + this.getField();
        }

        public PutFieldOperator(IField iField, PointsToSetVariable pointsToSetVariable) {
            super(pointsToSetVariable);
            this.priorInstances = IntSetUtil.make();
            this.field = iField;
            PropagationCallGraphBuilder.this.system.registerFixedSet(pointsToSetVariable, this);
        }

        @Override
        public boolean isComplex() {
            return true;
        }

        @Override
        public byte evaluate(PointsToSetVariable pointsToSetVariable) {
            if (pointsToSetVariable.size() == 0) {
                return 0;
            }
            final PointerKey pointerKey = pointsToSetVariable.getPointerKey();
            PointsToSetVariable pointsToSetVariable2 = this.getFixedSet();
            final PointerKey pointerKey2 = pointsToSetVariable2.getPointerKey();
            IntSet intSet = pointsToSetVariable.getValue();
            intSet = this.filterInstances(intSet);
            final UnaryOperator<PointsToSetVariable> unaryOperator = this.getPutAssignmentOperator();
            if (unaryOperator == null) {
                Assertions.UNREACHABLE();
            }
            final MutableBoolean mutableBoolean = new MutableBoolean();
            IntSetAction intSetAction = new IntSetAction(){

                public void act(int n) {
                    PointerKey pointerKey3;
                    InstanceKey instanceKey = ((PutFieldOperator)PutFieldOperator.this).PropagationCallGraphBuilder.this.system.getInstanceKey(n);
                    if (!PropagationCallGraphBuilder.representsNullType(instanceKey) && (pointerKey3 = PropagationCallGraphBuilder.this.getPointerKeyForInstanceField(instanceKey, PutFieldOperator.this.getField())) != null) {
                        mutableBoolean.b |= ((PutFieldOperator)PutFieldOperator.this).PropagationCallGraphBuilder.this.system.newFieldWrite(pointerKey3, unaryOperator, pointerKey2, pointerKey);
                    }
                }
            };
            if (this.priorInstances != null) {
                intSet.foreachExcluding(this.priorInstances, intSetAction);
                this.priorInstances.addAll(intSet);
            } else {
                intSet.foreach(intSetAction);
            }
            int n = mutableBoolean.b ? 4 : 0;
            return (byte)(0 | n);
        }

        protected IntSet filterInstances(IntSet intSet) {
            return intSet;
        }

        @Override
        public int hashCode() {
            return 9857 * this.getField().hashCode() + this.getFixedSet().hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                PutFieldOperator putFieldOperator = (PutFieldOperator)object;
                return this.getField().equals(putFieldOperator.getField()) && this.getFixedSet().equals(putFieldOperator.getFixedSet());
            }
            return false;
        }

        public UnaryOperator<PointsToSetVariable> getPutAssignmentOperator() {
            return assignOperator;
        }

        protected IField getField() {
            return this.field;
        }

        @Override
        protected boolean isLoadOperator() {
            return false;
        }
    }

    public static final class TypedPointerKey
    implements FilteredPointerKey {
        private final IClass type;
        private final PointerKey base;

        static TypedPointerKey make(PointerKey pointerKey, IClass iClass) {
            assert (iClass != null);
            return new TypedPointerKey(pointerKey, iClass);
        }

        private TypedPointerKey(PointerKey pointerKey, IClass iClass) {
            this.type = iClass;
            this.base = pointerKey;
            assert (iClass != null);
            assert (!(iClass instanceof FilteredPointerKey));
        }

        public FilteredPointerKey.TypeFilter getTypeFilter() {
            return new FilteredPointerKey.SingleClassFilter(this.type);
        }

        public boolean equals(Object object) {
            if (object instanceof TypedPointerKey) {
                TypedPointerKey typedPointerKey = (TypedPointerKey)object;
                return this.type.equals(typedPointerKey.type) && this.base.equals(typedPointerKey.base);
            }
            return false;
        }

        public int hashCode() {
            return 67931 * this.base.hashCode() + this.type.hashCode();
        }

        public String toString() {
            return "{ " + this.base + " type: " + this.type + "}";
        }

        public PointerKey getBase() {
            return this.base;
        }
    }
}

