/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKeyWithFilter;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;

public class DefaultPointerKeyFactory
implements PointerKeyFactory {
    public PointerKey getPointerKeyForLocal(CGNode cGNode, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("illegal value number: " + n + " in " + cGNode);
        }
        return new LocalPointerKey(cGNode, n);
    }

    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode cGNode, int n, FilteredPointerKey.TypeFilter typeFilter) {
        if (typeFilter == null) {
            throw new IllegalArgumentException("null filter");
        }
        assert (n > 0) : "illegal value number: " + n + " in " + cGNode;
        return new LocalPointerKeyWithFilter(cGNode, n, typeFilter);
    }

    public PointerKey getPointerKeyForReturnValue(CGNode cGNode) {
        return new ReturnValueKey(cGNode);
    }

    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode cGNode) {
        return new ExceptionReturnValueKey(cGNode);
    }

    public PointerKey getPointerKeyForStaticField(IField iField) {
        if (iField == null) {
            throw new IllegalArgumentException("null f");
        }
        return new StaticFieldKey(iField);
    }

    public PointerKey getPointerKeyForInstanceField(InstanceKey instanceKey, IField iField) {
        if (iField == null) {
            throw new IllegalArgumentException("field is null");
        }
        return new InstanceFieldKey(instanceKey, iField);
    }

    public PointerKey getPointerKeyForArrayContents(InstanceKey instanceKey) {
        return new ArrayContentsKey(instanceKey);
    }
}

