/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cfg.EdgeFilter;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrunedCFG<I, T extends IBasicBlock<I>>
extends AbstractNumberedGraph<T>
implements ControlFlowGraph<I, T> {
    private final ControlFlowGraph<I, T> cfg;
    private final FilteredNodes<T> nodes;
    private final FilteredCFGEdges<I, T> edges;

    public static <I, T extends IBasicBlock<I>> PrunedCFG<I, T> make(ControlFlowGraph<I, T> controlFlowGraph, EdgeFilter<T> edgeFilter) {
        if (controlFlowGraph == null) {
            throw new IllegalArgumentException("cfg is null");
        }
        return new PrunedCFG<I, T>(controlFlowGraph, edgeFilter);
    }

    private PrunedCFG(final ControlFlowGraph<I, T> controlFlowGraph, EdgeFilter<T> edgeFilter) {
        this.cfg = controlFlowGraph;
        AbstractNumberedGraph abstractNumberedGraph = new AbstractNumberedGraph<T>(edgeFilter){
            private final EdgeManager<T> edges;
            {
                this.edges = new FilteredCFGEdges(controlFlowGraph2, controlFlowGraph2, edgeFilter);
            }

            @Override
            protected NodeManager<T> getNodeManager() {
                return controlFlowGraph;
            }

            @Override
            protected EdgeManager<T> getEdgeManager() {
                return this.edges;
            }
        };
        Set<T> set = DFS.getReachableNodes(abstractNumberedGraph, Collections.singleton(controlFlowGraph.entry()));
        Set set2 = DFS.getReachableNodes(GraphInverter.invert(abstractNumberedGraph), Collections.singleton(controlFlowGraph.exit()));
        set.retainAll(set2);
        this.nodes = new FilteredNodes(controlFlowGraph, set);
        this.edges = new FilteredCFGEdges<I, T>(controlFlowGraph, this.nodes, edgeFilter);
    }

    @Override
    protected NodeManager<T> getNodeManager() {
        return this.nodes;
    }

    @Override
    protected EdgeManager<T> getEdgeManager() {
        return this.edges;
    }

    @Override
    public List<T> getExceptionalSuccessors(T t) {
        ArrayList<IBasicBlock> arrayList = new ArrayList<IBasicBlock>();
        Iterator<T> iterator = this.edges.getExceptionalSuccessors(t);
        while (iterator.hasNext()) {
            arrayList.add((IBasicBlock)iterator.next());
        }
        return arrayList;
    }

    @Override
    public Collection<T> getNormalSuccessors(T t) {
        return Iterator2Collection.toSet(this.edges.getNormalSuccessors(t));
    }

    @Override
    public Collection<T> getExceptionalPredecessors(T t) {
        return Iterator2Collection.toSet(this.edges.getExceptionalPredecessors(t));
    }

    @Override
    public Collection<T> getNormalPredecessors(T t) {
        return Iterator2Collection.toSet(this.edges.getNormalPredecessors(t));
    }

    @Override
    public T entry() {
        return this.cfg.entry();
    }

    @Override
    public T exit() {
        return this.cfg.exit();
    }

    @Override
    public T getBlockForInstruction(int n) {
        return this.cfg.getBlockForInstruction(n);
    }

    @Override
    public I[] getInstructions() {
        return this.cfg.getInstructions();
    }

    @Override
    public int getProgramCounter(int n) {
        return this.cfg.getProgramCounter(n);
    }

    @Override
    public IMethod getMethod() {
        return this.cfg.getMethod();
    }

    @Override
    public BitVector getCatchBlocks() {
        BitVector bitVector = new BitVector();
        BitVector bitVector2 = this.cfg.getCatchBlocks();
        int n = 0;
        while ((n = bitVector2.nextSetBit(n)) != -1) {
            if (!this.nodes.containsNode((IBasicBlock)this.getNode(n))) continue;
            bitVector.set(n);
        }
        return bitVector;
    }

    public IntSet getPhiIndices(T t) {
        assert (this.containsNode(t));
        assert (this.cfg.containsNode(t));
        int n = 0;
        MutableIntSet mutableIntSet = IntSetUtil.make();
        Iterator<T> iterator = this.cfg.getPredNodes(t);
        while (iterator.hasNext()) {
            if (this.nodes.containsNode((IBasicBlock)iterator.next())) {
                mutableIntSet.add(n);
            }
            ++n;
        }
        return mutableIntSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredCFGEdges<I, T extends IBasicBlock<I>>
    implements NumberedEdgeManager<T> {
        private final ControlFlowGraph<I, T> cfg;
        private final NumberedNodeManager<T> currentCFGNodes;
        private final EdgeFilter<T> filter;

        FilteredCFGEdges(ControlFlowGraph<I, T> controlFlowGraph, NumberedNodeManager<T> numberedNodeManager, EdgeFilter<T> edgeFilter) {
            this.cfg = controlFlowGraph;
            this.filter = edgeFilter;
            this.currentCFGNodes = numberedNodeManager;
        }

        public Iterator<T> getExceptionalSuccessors(T t) {
            return new FilterIterator(this.cfg.getExceptionalSuccessors(t).iterator(), new Filter<T>((IBasicBlock)t){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                @Override
                public boolean accepts(T t) {
                    return FilteredCFGEdges.this.currentCFGNodes.containsNode(t) && FilteredCFGEdges.this.filter.hasExceptionalEdge(this.val$N, t);
                }
            });
        }

        public Iterator<T> getNormalSuccessors(T t) {
            return new FilterIterator(this.cfg.getNormalSuccessors(t).iterator(), new Filter<T>((IBasicBlock)t){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                @Override
                public boolean accepts(T t) {
                    return FilteredCFGEdges.this.currentCFGNodes.containsNode(t) && FilteredCFGEdges.this.filter.hasNormalEdge(this.val$N, t);
                }
            });
        }

        public Iterator<T> getExceptionalPredecessors(T t) {
            return new FilterIterator(this.cfg.getExceptionalPredecessors(t).iterator(), new Filter<T>((IBasicBlock)t){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                @Override
                public boolean accepts(T t) {
                    return FilteredCFGEdges.this.currentCFGNodes.containsNode(t) && FilteredCFGEdges.this.filter.hasExceptionalEdge(t, this.val$N);
                }
            });
        }

        public Iterator<T> getNormalPredecessors(T t) {
            return new FilterIterator(this.cfg.getNormalPredecessors(t).iterator(), new Filter<T>((IBasicBlock)t){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                @Override
                public boolean accepts(T t) {
                    return FilteredCFGEdges.this.currentCFGNodes.containsNode(t) && FilteredCFGEdges.this.filter.hasNormalEdge(t, this.val$N);
                }
            });
        }

        @Override
        public Iterator<T> getSuccNodes(T t) {
            return new FilterIterator(this.cfg.getSuccNodes(t), new Filter<T>((IBasicBlock)t){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                @Override
                public boolean accepts(T t) {
                    return FilteredCFGEdges.this.currentCFGNodes.containsNode(t) && (FilteredCFGEdges.this.filter.hasNormalEdge(this.val$N, t) || FilteredCFGEdges.this.filter.hasExceptionalEdge(this.val$N, t));
                }
            });
        }

        @Override
        public int getSuccNodeCount(T t) {
            return Iterator2Collection.toSet(this.getSuccNodes(t)).size();
        }

        @Override
        public IntSet getSuccNodeNumbers(T t) {
            MutableIntSet mutableIntSet = IntSetUtil.make();
            Iterator<T> iterator = this.getSuccNodes(t);
            while (iterator.hasNext()) {
                mutableIntSet.add(((IBasicBlock)iterator.next()).getNumber());
            }
            return mutableIntSet;
        }

        @Override
        public Iterator<T> getPredNodes(T t) {
            return new FilterIterator(this.cfg.getPredNodes(t), new Filter<T>((IBasicBlock)t){
                private final /* synthetic */ IBasicBlock val$N;
                {
                    this.val$N = iBasicBlock;
                }

                @Override
                public boolean accepts(T t) {
                    return FilteredCFGEdges.this.currentCFGNodes.containsNode(t) && (FilteredCFGEdges.this.filter.hasNormalEdge(t, this.val$N) || FilteredCFGEdges.this.filter.hasExceptionalEdge(t, this.val$N));
                }
            });
        }

        @Override
        public int getPredNodeCount(T t) {
            return Iterator2Collection.toSet(this.getPredNodes(t)).size();
        }

        @Override
        public IntSet getPredNodeNumbers(T t) {
            MutableIntSet mutableIntSet = IntSetUtil.make();
            Iterator<T> iterator = this.getPredNodes(t);
            while (iterator.hasNext()) {
                mutableIntSet.add(((IBasicBlock)iterator.next()).getNumber());
            }
            return mutableIntSet;
        }

        @Override
        public boolean hasEdge(T t, T t2) {
            Iterator<T> iterator = this.getSuccNodes(t);
            while (iterator.hasNext()) {
                if (!iterator.next().equals(t2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addEdge(T t, T t2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeEdge(T t, T t2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAllIncidentEdges(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeIncomingEdges(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeOutgoingEdges(T t) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredNodes<T extends IBasicBlock>
    implements NumberedNodeManager<T> {
        private final NumberedNodeManager<T> nodes;
        private final Set subset;

        FilteredNodes(NumberedNodeManager<T> numberedNodeManager, Set set) {
            this.nodes = numberedNodeManager;
            this.subset = set;
        }

        @Override
        public int getNumber(T t) {
            if (this.subset.contains(t)) {
                return this.nodes.getNumber(t);
            }
            return -1;
        }

        @Override
        public T getNode(int n) {
            IBasicBlock iBasicBlock = (IBasicBlock)this.nodes.getNode(n);
            if (this.subset.contains(iBasicBlock)) {
                return (T)iBasicBlock;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int getMaxNumber() {
            int n = -1;
            for (IBasicBlock iBasicBlock : this.nodes) {
                if (!this.subset.contains(iBasicBlock) || this.getNumber((T)iBasicBlock) <= n) continue;
                n = this.getNumber((T)iBasicBlock);
            }
            return n;
        }

        private Iterator<T> filterNodes(Iterator iterator) {
            return new FilterIterator(iterator, new Filter(){

                public boolean accepts(Object object) {
                    return FilteredNodes.this.subset.contains(object);
                }
            });
        }

        @Override
        public Iterator<T> iterateNodes(IntSet intSet) {
            return this.filterNodes(this.nodes.iterateNodes(intSet));
        }

        @Override
        public Iterator<T> iterator() {
            return this.filterNodes(this.nodes.iterator());
        }

        @Override
        public int getNumberOfNodes() {
            return this.subset.size();
        }

        @Override
        public void addNode(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeNode(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsNode(T t) {
            return this.subset.contains(t);
        }
    }
}

