/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.ipa.callgraph.propagation.AbstractFieldPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.AbstractPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapExclusions {
    private static final boolean VERBOSE = false;
    private static final Collection<TypeReference> considered = HashSetFactory.make();
    private final SetOfClasses set;

    public HeapExclusions(SetOfClasses setOfClasses) {
        this.set = setOfClasses;
    }

    public Set<PointerKey> filter(Collection<PointerKey> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet<PointerKey> hashSet = HashSetFactory.make();
        for (PointerKey pointerKey : collection) {
            AbstractPointerKey abstractPointerKey;
            if (pointerKey instanceof AbstractFieldPointerKey) {
                abstractPointerKey = (AbstractFieldPointerKey)pointerKey;
                if (((AbstractFieldPointerKey)abstractPointerKey).getInstanceKey().getConcreteType() == null || this.set.contains(((AbstractFieldPointerKey)abstractPointerKey).getInstanceKey().getConcreteType().getReference())) continue;
                hashSet.add(pointerKey);
                continue;
            }
            if (pointerKey instanceof StaticFieldKey) {
                abstractPointerKey = (StaticFieldKey)pointerKey;
                if (this.set.contains(((StaticFieldKey)abstractPointerKey).getField().getDeclaringClass().getReference())) continue;
                hashSet.add(pointerKey);
                continue;
            }
            Assertions.UNREACHABLE(collection.getClass().toString());
        }
        return hashSet;
    }

    private static void verboseAction(PointerKey pointerKey) {
        StaticFieldKey staticFieldKey;
        TypeReference typeReference;
        if (pointerKey instanceof AbstractFieldPointerKey) {
            TypeReference typeReference2;
            AbstractFieldPointerKey abstractFieldPointerKey = (AbstractFieldPointerKey)pointerKey;
            if (abstractFieldPointerKey.getInstanceKey().getConcreteType() != null && !considered.contains(typeReference2 = abstractFieldPointerKey.getInstanceKey().getConcreteType().getReference())) {
                considered.add(typeReference2);
                System.err.println("Considered " + typeReference2);
            }
        } else if (pointerKey instanceof StaticFieldKey && !considered.contains(typeReference = (staticFieldKey = (StaticFieldKey)pointerKey).getField().getDeclaringClass().getReference())) {
            considered.add(typeReference);
            System.err.println("Considered " + typeReference);
        }
    }

    public boolean excludes(PointerKey pointerKey) {
        TypeReference typeReference = HeapExclusions.getType(pointerKey);
        return typeReference == null ? false : this.set.contains(typeReference);
    }

    public static TypeReference getType(PointerKey pointerKey) {
        if (pointerKey instanceof AbstractFieldPointerKey) {
            AbstractFieldPointerKey abstractFieldPointerKey = (AbstractFieldPointerKey)pointerKey;
            if (abstractFieldPointerKey.getInstanceKey().getConcreteType() != null) {
                return abstractFieldPointerKey.getInstanceKey().getConcreteType().getReference();
            }
        } else if (pointerKey instanceof StaticFieldKey) {
            StaticFieldKey staticFieldKey = (StaticFieldKey)pointerKey;
            return staticFieldKey.getField().getDeclaringClass().getReference();
        }
        return null;
    }
}

