/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCallee;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.ParamCallee;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDG
extends AbstractNumberedGraph<Statement>
implements ISDG {
    private static final boolean DEBUG_LAZY = false;
    private final Nodes nodeMgr = new Nodes();
    private final Edges edgeMgr = new Edges();
    private final CallGraph cg;
    private final PointerAnalysis pa;
    private final Map<CGNode, PDG> pdgMap = HashMapFactory.make();
    private final Slicer.DataDependenceOptions dOptions;
    private final Slicer.ControlDependenceOptions cOptions;
    private final Map<CGNode, OrdinalSet<PointerKey>> mod;
    private final Map<CGNode, OrdinalSet<PointerKey>> ref;
    private final Collection<CGNode> statementsAdded = HashSetFactory.make();
    private final HeapExclusions heapExclude;
    private final ModRef modRef;
    private boolean eagerComputed = false;

    public SDG(CallGraph callGraph, PointerAnalysis pointerAnalysis, Slicer.DataDependenceOptions dataDependenceOptions, Slicer.ControlDependenceOptions controlDependenceOptions) {
        this(callGraph, pointerAnalysis, ModRef.make(), dataDependenceOptions, controlDependenceOptions, null);
    }

    public SDG(CallGraph callGraph, PointerAnalysis pointerAnalysis, ModRef modRef, Slicer.DataDependenceOptions dataDependenceOptions, Slicer.ControlDependenceOptions controlDependenceOptions) {
        this(callGraph, pointerAnalysis, modRef, dataDependenceOptions, controlDependenceOptions, null);
    }

    public SDG(CallGraph callGraph, PointerAnalysis pointerAnalysis, ModRef modRef, Slicer.DataDependenceOptions dataDependenceOptions, Slicer.ControlDependenceOptions controlDependenceOptions, HeapExclusions heapExclusions) throws IllegalArgumentException {
        if (dataDependenceOptions == null) {
            throw new IllegalArgumentException("dOptions must not be null");
        }
        this.modRef = modRef;
        this.cg = callGraph;
        this.pa = pointerAnalysis;
        this.mod = dataDependenceOptions.isIgnoreHeap() ? null : modRef.computeMod(callGraph, pointerAnalysis, heapExclusions);
        this.ref = dataDependenceOptions.isIgnoreHeap() ? null : modRef.computeRef(callGraph, pointerAnalysis, heapExclusions);
        this.dOptions = dataDependenceOptions;
        this.cOptions = controlDependenceOptions;
        this.heapExclude = heapExclusions;
    }

    @Override
    public String toString() {
        this.eagerConstruction();
        return super.toString();
    }

    private void eagerConstruction() {
        if (!this.eagerComputed) {
            this.eagerComputed = true;
            this.computeAllPDGs();
            for (PDG pDG : this.pdgMap.values()) {
                this.addPDGStatementNodes(pDG.getCallGraphNode());
            }
        }
    }

    private void addPDGStatementNodes(CGNode cGNode) {
        if (!this.statementsAdded.contains(cGNode)) {
            this.statementsAdded.add(cGNode);
            PDG pDG = this.getPDG(cGNode);
            Iterator<Statement> iterator = pDG.iterator();
            while (iterator.hasNext()) {
                this.addNode(iterator.next());
            }
        }
    }

    private void computeAllPDGs() {
        for (CGNode cGNode : this.cg) {
            this.getPDG(cGNode);
        }
    }

    @Override
    public Iterator<? extends Statement> iterateLazyNodes() {
        return this.nodeMgr.iterateLazyNodes();
    }

    @Override
    protected EdgeManager<Statement> getEdgeManager() {
        return this.edgeMgr;
    }

    @Override
    public NodeManager<Statement> getNodeManager() {
        return this.nodeMgr;
    }

    @Override
    public PDG getPDG(CGNode cGNode) {
        PDG pDG = this.pdgMap.get(cGNode);
        if (pDG == null) {
            pDG = new PDG(cGNode, this.pa, this.mod, this.ref, this.dOptions, this.cOptions, this.heapExclude, this.cg, this.modRef);
            this.pdgMap.put(cGNode, pDG);
        }
        return pDG;
    }

    @Override
    public Slicer.ControlDependenceOptions getCOptions() {
        return this.cOptions;
    }

    public Slicer.DataDependenceOptions getDOptions() {
        return this.dOptions;
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cg.getClassHierarchy();
    }

    public PointerAnalysis getPointerAnalysis() {
        return this.pa;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Edges
    implements NumberedEdgeManager<Statement> {
        private Edges() {
        }

        @Override
        public void addEdge(Statement statement, Statement statement2) {
            Assertions.UNREACHABLE();
        }

        @Override
        public int getPredNodeCount(Statement statement) {
            return IteratorUtil.count(this.getPredNodes(statement));
        }

        @Override
        public Iterator<Statement> getPredNodes(Statement statement) {
            if (SDG.this.dOptions.isIgnoreExceptions()) {
                assert (!statement.getKind().equals((Object)Statement.Kind.EXC_RET_CALLEE));
                assert (!statement.getKind().equals((Object)Statement.Kind.EXC_RET_CALLER));
            }
            SDG.this.addPDGStatementNodes(statement.getNode());
            switch (statement.getKind()) {
                case NORMAL: 
                case PHI: 
                case PI: 
                case CATCH: 
                case PARAM_CALLER: 
                case NORMAL_RET_CALLEE: 
                case EXC_RET_CALLEE: 
                case HEAP_PARAM_CALLER: 
                case HEAP_RET_CALLEE: 
                case METHOD_EXIT: {
                    return SDG.this.getPDG(statement.getNode()).getPredNodes(statement);
                }
                case EXC_RET_CALLER: {
                    ExceptionalReturnCaller exceptionalReturnCaller = (ExceptionalReturnCaller)statement;
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = exceptionalReturnCaller.getInstruction();
                    Iterator2Set<Statement> iterator2Set = Iterator2Collection.toSet(SDG.this.getPDG(statement.getNode()).getPredNodes(statement));
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode cGNode : SDG.this.cg.getPossibleTargets(statement.getNode(), sSAAbstractInvokeInstruction.getCallSite())) {
                            ExceptionalReturnCallee exceptionalReturnCallee = new ExceptionalReturnCallee(cGNode);
                            SDG.this.addNode(exceptionalReturnCallee);
                            iterator2Set.add(exceptionalReturnCallee);
                        }
                    }
                    return iterator2Set.iterator();
                }
                case NORMAL_RET_CALLER: {
                    NormalReturnCaller normalReturnCaller = (NormalReturnCaller)statement;
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = normalReturnCaller.getInstruction();
                    Iterator2Set<Statement> iterator2Set = Iterator2Collection.toSet(SDG.this.getPDG(statement.getNode()).getPredNodes(statement));
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode cGNode : SDG.this.cg.getPossibleTargets(statement.getNode(), sSAAbstractInvokeInstruction.getCallSite())) {
                            NormalReturnCallee normalReturnCallee = new NormalReturnCallee(cGNode);
                            SDG.this.addNode(normalReturnCallee);
                            iterator2Set.add(normalReturnCallee);
                        }
                    }
                    return iterator2Set.iterator();
                }
                case HEAP_RET_CALLER: {
                    HeapStatement.HeapReturnCaller heapReturnCaller = (HeapStatement.HeapReturnCaller)statement;
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = heapReturnCaller.getCall();
                    Iterator2Set<Statement> iterator2Set = Iterator2Collection.toSet(SDG.this.getPDG(statement.getNode()).getPredNodes(statement));
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode cGNode : SDG.this.cg.getPossibleTargets(statement.getNode(), sSAAbstractInvokeInstruction.getCallSite())) {
                            if (!((OrdinalSet)SDG.this.mod.get(cGNode)).contains(heapReturnCaller.getLocation())) continue;
                            HeapStatement.HeapReturnCallee heapReturnCallee = new HeapStatement.HeapReturnCallee(cGNode, heapReturnCaller.getLocation());
                            SDG.this.addNode(heapReturnCallee);
                            iterator2Set.add(heapReturnCallee);
                        }
                    }
                    return iterator2Set.iterator();
                }
                case PARAM_CALLEE: {
                    ParamCallee paramCallee = (ParamCallee)statement;
                    int n = paramCallee.getValueNumber() - 1;
                    HashSet hashSet = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        if (SDG.this.dOptions.isTerminateAtCast() && !paramCallee.getNode().getMethod().isStatic() && paramCallee.getValueNumber() == 1) {
                            return EmptyIterator.instance();
                        }
                        if (SDG.this.dOptions.isTerminateAtCast() && this.isUninformativeForReflection(paramCallee.getNode())) {
                            return EmptyIterator.instance();
                        }
                        Iterator<CGNode> iterator = SDG.this.cg.getPredNodes(statement.getNode());
                        while (iterator.hasNext()) {
                            CGNode cGNode = iterator.next();
                            Iterator<CallSiteReference> iterator2 = SDG.this.cg.getPossibleSites(cGNode, statement.getNode());
                            while (iterator2.hasNext()) {
                                CallSiteReference callSiteReference = iterator2.next();
                                IR iR = cGNode.getIR();
                                IntSet intSet = iR.getCallInstructionIndices(callSiteReference);
                                IntIterator intIterator = intSet.intIterator();
                                while (intIterator.hasNext()) {
                                    int n2 = intIterator.next();
                                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = (SSAAbstractInvokeInstruction)iR.getInstructions()[n2];
                                    int n3 = sSAAbstractInvokeInstruction.getUse(n);
                                    ParamCaller paramCaller = new ParamCaller(cGNode, n2, n3);
                                    SDG.this.addNode(paramCaller);
                                    hashSet.add(paramCaller);
                                }
                            }
                        }
                    }
                    return hashSet.iterator();
                }
                case HEAP_PARAM_CALLEE: {
                    HeapStatement.HeapParamCallee heapParamCallee = (HeapStatement.HeapParamCallee)statement;
                    HashSet hashSet = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        Iterator<CGNode> iterator = SDG.this.cg.getPredNodes(statement.getNode());
                        while (iterator.hasNext()) {
                            CGNode cGNode = iterator.next();
                            Iterator<CallSiteReference> iterator3 = SDG.this.cg.getPossibleSites(cGNode, statement.getNode());
                            while (iterator3.hasNext()) {
                                CallSiteReference callSiteReference = iterator3.next();
                                IR iR = cGNode.getIR();
                                IntSet intSet = iR.getCallInstructionIndices(callSiteReference);
                                IntIterator intIterator = intSet.intIterator();
                                while (intIterator.hasNext()) {
                                    int n = intIterator.next();
                                    HeapStatement.HeapParamCaller heapParamCaller = new HeapStatement.HeapParamCaller(cGNode, n, heapParamCallee.getLocation());
                                    SDG.this.addNode(heapParamCaller);
                                    hashSet.add(heapParamCaller);
                                }
                            }
                        }
                    }
                    return hashSet.iterator();
                }
                case METHOD_ENTRY: {
                    HashSet hashSet = HashSetFactory.make(5);
                    if (!SDG.this.cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                        Iterator<CGNode> iterator = SDG.this.cg.getPredNodes(statement.getNode());
                        while (iterator.hasNext()) {
                            CGNode cGNode = iterator.next();
                            Iterator<CallSiteReference> iterator4 = SDG.this.cg.getPossibleSites(cGNode, statement.getNode());
                            while (iterator4.hasNext()) {
                                CallSiteReference callSiteReference = iterator4.next();
                                IR iR = cGNode.getIR();
                                IntSet intSet = iR.getCallInstructionIndices(callSiteReference);
                                IntIterator intIterator = intSet.intIterator();
                                while (intIterator.hasNext()) {
                                    int n = intIterator.next();
                                    NormalStatement normalStatement = new NormalStatement(cGNode, n);
                                    SDG.this.addNode(normalStatement);
                                    hashSet.add(normalStatement);
                                }
                            }
                        }
                    }
                    return hashSet.iterator();
                }
            }
            Assertions.UNREACHABLE(statement.getKind().toString());
            return null;
        }

        @Override
        public int getSuccNodeCount(Statement statement) {
            return IteratorUtil.count(this.getSuccNodes(statement));
        }

        @Override
        public Iterator<Statement> getSuccNodes(Statement statement) {
            if (SDG.this.dOptions.isTerminateAtCast() && this.isUninformativeForReflection(statement.getNode())) {
                return EmptyIterator.instance();
            }
            SDG.this.addPDGStatementNodes(statement.getNode());
            switch (statement.getKind()) {
                case NORMAL: {
                    if (SDG.this.cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                        return SDG.this.getPDG(statement.getNode()).getSuccNodes(statement);
                    }
                    NormalStatement normalStatement = (NormalStatement)statement;
                    if (normalStatement.getInstruction() instanceof SSAAbstractInvokeInstruction) {
                        HashSet hashSet = HashSetFactory.make();
                        SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = (SSAAbstractInvokeInstruction)normalStatement.getInstruction();
                        for (CGNode cGNode : SDG.this.cg.getPossibleTargets(statement.getNode(), sSAAbstractInvokeInstruction.getCallSite())) {
                            MethodEntryStatement methodEntryStatement = new MethodEntryStatement(cGNode);
                            SDG.this.addNode(methodEntryStatement);
                            hashSet.add(methodEntryStatement);
                        }
                        return new CompoundIterator<Statement>(hashSet.iterator(), SDG.this.getPDG(statement.getNode()).getSuccNodes(statement));
                    }
                    return SDG.this.getPDG(statement.getNode()).getSuccNodes(statement);
                }
                case PHI: 
                case PI: 
                case CATCH: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case EXC_RET_CALLER: 
                case HEAP_PARAM_CALLEE: 
                case HEAP_RET_CALLER: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    return SDG.this.getPDG(statement.getNode()).getSuccNodes(statement);
                }
                case EXC_RET_CALLEE: {
                    HashSet hashSet = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        Iterator<CGNode> iterator = SDG.this.cg.getPredNodes(statement.getNode());
                        while (iterator.hasNext()) {
                            CGNode cGNode = iterator.next();
                            Iterator<CallSiteReference> iterator2 = SDG.this.cg.getPossibleSites(cGNode, statement.getNode());
                            while (iterator2.hasNext()) {
                                CallSiteReference callSiteReference = iterator2.next();
                                IR iR = cGNode.getIR();
                                IntSet intSet = iR.getCallInstructionIndices(callSiteReference);
                                IntIterator intIterator = intSet.intIterator();
                                while (intIterator.hasNext()) {
                                    int n = intIterator.next();
                                    ExceptionalReturnCaller exceptionalReturnCaller = new ExceptionalReturnCaller(cGNode, n);
                                    SDG.this.addNode(exceptionalReturnCaller);
                                    hashSet.add(exceptionalReturnCaller);
                                }
                            }
                        }
                    }
                    return hashSet.iterator();
                }
                case NORMAL_RET_CALLEE: {
                    HashSet hashSet = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        Iterator<CGNode> iterator = SDG.this.cg.getPredNodes(statement.getNode());
                        while (iterator.hasNext()) {
                            CGNode cGNode = iterator.next();
                            Iterator<CallSiteReference> iterator3 = SDG.this.cg.getPossibleSites(cGNode, statement.getNode());
                            while (iterator3.hasNext()) {
                                CallSiteReference callSiteReference = iterator3.next();
                                IR iR = cGNode.getIR();
                                IntSet intSet = iR.getCallInstructionIndices(callSiteReference);
                                IntIterator intIterator = intSet.intIterator();
                                while (intIterator.hasNext()) {
                                    int n = intIterator.next();
                                    NormalReturnCaller normalReturnCaller = new NormalReturnCaller(cGNode, n);
                                    SDG.this.addNode(normalReturnCaller);
                                    hashSet.add(normalReturnCaller);
                                }
                            }
                        }
                    }
                    return hashSet.iterator();
                }
                case HEAP_RET_CALLEE: {
                    HeapStatement.HeapReturnCallee heapReturnCallee = (HeapStatement.HeapReturnCallee)statement;
                    HashSet hashSet = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        Iterator<CGNode> iterator = SDG.this.cg.getPredNodes(statement.getNode());
                        while (iterator.hasNext()) {
                            CGNode cGNode = iterator.next();
                            Iterator<CallSiteReference> iterator4 = SDG.this.cg.getPossibleSites(cGNode, statement.getNode());
                            while (iterator4.hasNext()) {
                                CallSiteReference callSiteReference = iterator4.next();
                                IR iR = cGNode.getIR();
                                IntSet intSet = iR.getCallInstructionIndices(callSiteReference);
                                IntIterator intIterator = intSet.intIterator();
                                while (intIterator.hasNext()) {
                                    int n = intIterator.next();
                                    HeapStatement.HeapReturnCaller heapReturnCaller = new HeapStatement.HeapReturnCaller(cGNode, n, heapReturnCallee.getLocation());
                                    SDG.this.addNode(heapReturnCaller);
                                    hashSet.add(heapReturnCaller);
                                }
                            }
                        }
                    }
                    return hashSet.iterator();
                }
                case PARAM_CALLER: {
                    ParamCaller paramCaller = (ParamCaller)statement;
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = paramCaller.getInstruction();
                    HashSet hashSet = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode cGNode : SDG.this.cg.getPossibleTargets(statement.getNode(), sSAAbstractInvokeInstruction.getCallSite())) {
                            int n = 0;
                            while (n < cGNode.getMethod().getNumberOfParameters()) {
                                if (!(SDG.this.dOptions.isTerminateAtCast() && sSAAbstractInvokeInstruction.isDispatch() && paramCaller.getValueNumber() == sSAAbstractInvokeInstruction.getReceiver() || SDG.this.dOptions.isTerminateAtCast() && this.isUninformativeForReflection(cGNode) || sSAAbstractInvokeInstruction.getUse(n) != paramCaller.getValueNumber())) {
                                    ParamCallee paramCallee = new ParamCallee(cGNode, n + 1);
                                    SDG.this.addNode(paramCallee);
                                    hashSet.add(paramCallee);
                                }
                                ++n;
                            }
                        }
                    }
                    return hashSet.iterator();
                }
                case HEAP_PARAM_CALLER: {
                    HeapStatement.HeapParamCaller heapParamCaller = (HeapStatement.HeapParamCaller)statement;
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = heapParamCaller.getCall();
                    HashSet hashSet = HashSetFactory.make(5);
                    if (!SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        for (CGNode cGNode : SDG.this.cg.getPossibleTargets(statement.getNode(), sSAAbstractInvokeInstruction.getCallSite())) {
                            if (!((OrdinalSet)SDG.this.ref.get(cGNode)).contains(heapParamCaller.getLocation())) continue;
                            HeapStatement.HeapParamCallee heapParamCallee = new HeapStatement.HeapParamCallee(cGNode, heapParamCaller.getLocation());
                            SDG.this.addNode(heapParamCallee);
                            hashSet.add(heapParamCallee);
                        }
                    }
                    return hashSet.iterator();
                }
            }
            Assertions.UNREACHABLE(statement.getKind().toString());
            return null;
        }

        private boolean isUninformativeForReflection(CGNode cGNode) {
            if (cGNode.getMethod().getDeclaringClass().getReference().equals(TypeReference.JavaLangReflectMethod)) {
                return true;
            }
            if (cGNode.getMethod().getDeclaringClass().getReference().equals(TypeReference.JavaLangReflectConstructor)) {
                return true;
            }
            return cGNode.getMethod().getSelector().equals(MethodReference.equalsSelector);
        }

        @Override
        public boolean hasEdge(Statement statement, Statement statement2) {
            SDG.this.addPDGStatementNodes(statement.getNode());
            SDG.this.addPDGStatementNodes(statement2.getNode());
            switch (statement.getKind()) {
                case NORMAL: {
                    if (SDG.this.cOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                        return SDG.this.getPDG(statement.getNode()).hasEdge(statement, statement2);
                    }
                    NormalStatement normalStatement = (NormalStatement)statement;
                    if (statement2 instanceof MethodEntryStatement) {
                        if (normalStatement.getInstruction() instanceof SSAAbstractInvokeInstruction) {
                            SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = (SSAAbstractInvokeInstruction)normalStatement.getInstruction();
                            return SDG.this.cg.getPossibleTargets(statement.getNode(), sSAAbstractInvokeInstruction.getCallSite()).contains(statement2.getNode());
                        }
                        return false;
                    }
                    return SDG.this.getPDG(statement.getNode()).hasEdge(statement, statement2);
                }
                case PHI: 
                case PI: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case EXC_RET_CALLER: 
                case HEAP_PARAM_CALLEE: 
                case HEAP_RET_CALLER: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    return SDG.this.getPDG(statement.getNode()).hasEdge(statement, statement2);
                }
                case EXC_RET_CALLEE: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (statement2.getKind().equals((Object)Statement.Kind.EXC_RET_CALLER)) {
                        ExceptionalReturnCaller exceptionalReturnCaller = (ExceptionalReturnCaller)statement2;
                        return SDG.this.cg.getPossibleTargets(exceptionalReturnCaller.getNode(), exceptionalReturnCaller.getInstruction().getCallSite()).contains(statement.getNode());
                    }
                    return false;
                }
                case NORMAL_RET_CALLEE: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (statement2.getKind().equals((Object)Statement.Kind.NORMAL_RET_CALLER)) {
                        NormalReturnCaller normalReturnCaller = (NormalReturnCaller)statement2;
                        return SDG.this.cg.getPossibleTargets(normalReturnCaller.getNode(), normalReturnCaller.getInstruction().getCallSite()).contains(statement.getNode());
                    }
                    return false;
                }
                case HEAP_RET_CALLEE: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (statement2.getKind().equals((Object)Statement.Kind.HEAP_RET_CALLER)) {
                        HeapStatement.HeapReturnCaller heapReturnCaller = (HeapStatement.HeapReturnCaller)statement2;
                        HeapStatement heapStatement = (HeapStatement)statement;
                        return heapStatement.getLocation().equals(heapReturnCaller.getLocation()) && SDG.this.cg.getPossibleTargets(heapReturnCaller.getNode(), heapReturnCaller.getCall().getCallSite()).contains(statement.getNode());
                    }
                    return false;
                }
                case PARAM_CALLER: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (statement2.getKind().equals((Object)Statement.Kind.PARAM_CALLEE)) {
                        ParamCallee paramCallee = (ParamCallee)statement2;
                        ParamCaller paramCaller = (ParamCaller)statement;
                        SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = paramCaller.getInstruction();
                        CGNode cGNode = paramCallee.getNode();
                        if (!SDG.this.cg.getPossibleTargets(paramCaller.getNode(), sSAAbstractInvokeInstruction.getCallSite()).contains(cGNode)) {
                            return false;
                        }
                        if (SDG.this.dOptions.isTerminateAtCast() && sSAAbstractInvokeInstruction.isDispatch() && paramCaller.getValueNumber() == sSAAbstractInvokeInstruction.getReceiver()) {
                            return false;
                        }
                        if (SDG.this.dOptions.isTerminateAtCast() && this.isUninformativeForReflection(cGNode)) {
                            return false;
                        }
                        int n = 0;
                        while (n < cGNode.getMethod().getNumberOfParameters()) {
                            if (sSAAbstractInvokeInstruction.getUse(n) == paramCaller.getValueNumber() && paramCallee.getValueNumber() == n + 1) {
                                return true;
                            }
                            ++n;
                        }
                        return false;
                    }
                    return false;
                }
                case HEAP_PARAM_CALLER: {
                    if (SDG.this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
                        return false;
                    }
                    if (statement2.getKind().equals((Object)Statement.Kind.HEAP_PARAM_CALLEE)) {
                        HeapStatement.HeapParamCallee heapParamCallee = (HeapStatement.HeapParamCallee)statement2;
                        HeapStatement.HeapParamCaller heapParamCaller = (HeapStatement.HeapParamCaller)statement;
                        return heapParamCaller.getLocation().equals(heapParamCallee.getLocation()) && SDG.this.cg.getPossibleTargets(heapParamCaller.getNode(), heapParamCaller.getCall().getCallSite()).contains(heapParamCallee.getNode());
                    }
                    return false;
                }
            }
            Assertions.UNREACHABLE((Object)statement.getKind());
            return false;
        }

        @Override
        public void removeAllIncidentEdges(Statement statement) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeEdge(Statement statement, Statement statement2) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeIncomingEdges(Statement statement) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeOutgoingEdges(Statement statement) {
            Assertions.UNREACHABLE();
        }

        @Override
        public IntSet getPredNodeNumbers(Statement statement) {
            MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
            Iterator<Statement> iterator = this.getPredNodes(statement);
            while (iterator.hasNext()) {
                Statement statement2 = iterator.next();
                mutableSparseIntSet.add(SDG.this.getNumber(statement2));
            }
            return mutableSparseIntSet;
        }

        @Override
        public IntSet getSuccNodeNumbers(Statement statement) {
            MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
            Iterator<Statement> iterator = this.getSuccNodes(statement);
            while (iterator.hasNext()) {
                Statement statement2 = iterator.next();
                mutableSparseIntSet.add(SDG.this.getNumber(statement2));
            }
            return mutableSparseIntSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Nodes
    extends SlowNumberedNodeManager<Statement> {
        private Nodes() {
        }

        @Override
        public boolean containsNode(Statement statement) {
            if (super.containsNode(statement)) {
                return true;
            }
            SDG.this.eagerConstruction();
            return super.containsNode(statement);
        }

        @Override
        public int getMaxNumber() {
            SDG.this.eagerConstruction();
            return super.getMaxNumber();
        }

        @Override
        public Statement getNode(int n) {
            Statement statement = this.getNodeLazy(n);
            if (statement != null) {
                return statement;
            }
            SDG.this.eagerConstruction();
            return (Statement)super.getNode(n);
        }

        @Override
        public int getNumber(Statement statement) {
            CGNode cGNode = statement.getNode();
            SDG.this.addPDGStatementNodes(cGNode);
            return super.getNumber(statement);
        }

        @Override
        public Iterator<Statement> iterateNodes(IntSet intSet) {
            Assertions.UNREACHABLE();
            return super.iterateNodes(intSet);
        }

        @Override
        public Iterator<Statement> iterator() {
            SDG.this.eagerConstruction();
            return super.iterator();
        }

        Iterator<? extends Statement> iterateLazyNodes() {
            return super.iterator();
        }

        public Statement getNodeLazy(int n) {
            return (Statement)super.getNode(n);
        }

        @Override
        public int getNumberOfNodes() {
            SDG.this.eagerConstruction();
            return super.getNumberOfNodes();
        }
    }
}

