/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ClassTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.BypassSyntheticClass;
import com.ibm.wala.ipa.summaries.BypassSyntheticClassLoader;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BypassClassTargetSelector
implements ClassTargetSelector {
    private static final boolean DEBUG = false;
    private final Set<TypeReference> allocatableTypes;
    private final IClassHierarchy cha;
    private final ClassTargetSelector parent;
    private final BypassSyntheticClassLoader bypassLoader;

    public BypassClassTargetSelector(ClassTargetSelector classTargetSelector, Set<TypeReference> set, IClassHierarchy iClassHierarchy, IClassLoader iClassLoader) throws IllegalArgumentException {
        if (iClassLoader == null) {
            throw new IllegalArgumentException("bypassLoader == null");
        }
        if (!(iClassLoader instanceof BypassSyntheticClassLoader)) assert (false) : "unexpected bypass loader: " + iClassLoader.getClass();
        this.allocatableTypes = set;
        this.bypassLoader = (BypassSyntheticClassLoader)iClassLoader;
        this.parent = classTargetSelector;
        this.cha = iClassHierarchy;
    }

    @Override
    public IClass getAllocatedTarget(CGNode cGNode, NewSiteReference newSiteReference) {
        if (newSiteReference == null) {
            throw new IllegalArgumentException("site is null");
        }
        TypeReference typeReference = newSiteReference.getDeclaredType();
        IClass iClass = this.cha.lookupClass(typeReference);
        if (iClass == null) {
            return this.parent.getAllocatedTarget(cGNode, newSiteReference);
        }
        TypeReference typeReference2 = iClass.getReference();
        if (this.allocatableTypes.contains(typeReference2)) {
            if (iClass.isAbstract() || iClass.isInterface()) {
                TypeName typeName = BypassSyntheticClass.getName(typeReference2);
                IClass iClass2 = this.bypassLoader.lookupClass(typeName);
                if (iClass2 != null) {
                    return iClass2;
                }
                BypassSyntheticClass bypassSyntheticClass = new BypassSyntheticClass(iClass, this.bypassLoader, this.cha);
                this.bypassLoader.registerClass(typeName, bypassSyntheticClass);
                return bypassSyntheticClass;
            }
            return iClass;
        }
        return this.parent.getAllocatedTarget(cGNode, newSiteReference);
    }
}

