/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.ClassHierarchyMethodTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BypassMethodTargetSelector
implements MethodTargetSelector {
    static final boolean DEBUG = false;
    private final Map<MethodReference, MethodSummary> methodSummaries;
    private final Set<Atom> ignoredPackages;
    protected final IClassHierarchy cha;
    protected final MethodTargetSelector parent;
    private final ClassHierarchyMethodTargetSelector chaMethodTargetSelector;
    private final HashMap<MethodReference, SummarizedMethod> syntheticMethods = HashMapFactory.make();

    public BypassMethodTargetSelector(MethodTargetSelector methodTargetSelector, Map<MethodReference, MethodSummary> map, Set<Atom> set, IClassHierarchy iClassHierarchy) {
        this.methodSummaries = map;
        this.ignoredPackages = set;
        this.parent = methodTargetSelector;
        this.cha = iClassHierarchy;
        this.chaMethodTargetSelector = new ClassHierarchyMethodTargetSelector(iClassHierarchy);
    }

    @Override
    public IMethod getCalleeTarget(CGNode cGNode, CallSiteReference callSiteReference, IClass iClass) {
        IMethod iMethod;
        if (callSiteReference == null) {
            throw new IllegalArgumentException("site is null");
        }
        MethodReference methodReference = callSiteReference.getDeclaredTarget();
        IMethod iMethod2 = this.chaMethodTargetSelector.getCalleeTarget(cGNode, callSiteReference, iClass);
        IMethod iMethod3 = iMethod = iMethod2 == null ? this.findOrCreateSyntheticMethod(methodReference, callSiteReference.isStatic()) : this.findOrCreateSyntheticMethod(iMethod2, callSiteReference.isStatic());
        if (iMethod != null) {
            return iMethod;
        }
        if (this.canIgnore(callSiteReference.getDeclaredTarget())) {
            return this.findOrCreateSyntheticMethod(callSiteReference.getDeclaredTarget(), callSiteReference.isStatic());
        }
        if (this.parent instanceof ClassHierarchyMethodTargetSelector) {
            return iMethod2;
        }
        iMethod = this.parent.getCalleeTarget(cGNode, callSiteReference, iClass);
        if (iMethod != null) {
            SyntheticMethod syntheticMethod = this.findOrCreateSyntheticMethod(iMethod, callSiteReference.isStatic());
            return syntheticMethod == null ? iMethod : syntheticMethod;
        }
        return iMethod;
    }

    protected SyntheticMethod findOrCreateSyntheticMethod(MethodReference methodReference, boolean bl) {
        IClass iClass;
        TypeReference typeReference;
        if (this.syntheticMethods.containsKey(methodReference)) {
            return this.syntheticMethods.get(methodReference);
        }
        MethodSummary methodSummary = null;
        if (this.canIgnore(methodReference)) {
            typeReference = methodReference.getDeclaringClass();
            iClass = this.cha.lookupClass(typeReference);
            if (iClass == null) {
                this.syntheticMethods.put(methodReference, null);
                return null;
            }
            methodSummary = this.generateNoOp(methodReference, bl);
        } else {
            methodSummary = this.findSummary(methodReference);
        }
        if (methodSummary != null) {
            typeReference = methodReference.getDeclaringClass();
            iClass = this.cha.lookupClass(typeReference);
            if (iClass == null) {
                this.syntheticMethods.put(methodReference, null);
                return null;
            }
            SummarizedMethod summarizedMethod = new SummarizedMethod(methodReference, methodSummary, iClass);
            this.syntheticMethods.put(methodReference, summarizedMethod);
            return summarizedMethod;
        }
        this.syntheticMethods.put(methodReference, null);
        return null;
    }

    protected SyntheticMethod findOrCreateSyntheticMethod(IMethod iMethod, boolean bl) {
        MethodReference methodReference = iMethod.getReference();
        if (this.syntheticMethods.containsKey(methodReference)) {
            return this.syntheticMethods.get(methodReference);
        }
        MethodSummary methodSummary = null;
        methodSummary = this.canIgnore(methodReference) ? this.generateNoOp(methodReference, bl) : this.findSummary(methodReference);
        if (methodSummary != null) {
            SummarizedMethod summarizedMethod = new SummarizedMethod(methodReference, methodSummary, iMethod.getDeclaringClass());
            this.syntheticMethods.put(methodReference, summarizedMethod);
            return summarizedMethod;
        }
        this.syntheticMethods.put(methodReference, null);
        return null;
    }

    public static MethodSummary generateStandardNoOp(Language language, MethodReference methodReference, boolean bl) {
        return new NoOpSummary(language, methodReference, bl);
    }

    public MethodSummary generateNoOp(MethodReference methodReference, boolean bl) {
        Language language = this.cha.resolveMethod(methodReference).getDeclaringClass().getClassLoader().getLanguage();
        return new NoOpSummary(language, methodReference, bl);
    }

    protected boolean canIgnore(MemberReference memberReference) {
        TypeReference typeReference = memberReference.getDeclaringClass();
        TypeName typeName = typeReference.getName();
        Atom atom = typeName.getPackage();
        return this.ignoredPackages.contains(atom);
    }

    private MethodSummary findSummary(MemberReference memberReference) {
        return this.methodSummaries.get(memberReference);
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    private static class NoOpSummary
    extends MethodSummary {
        private final Language l;

        public NoOpSummary(Language language, MethodReference methodReference, boolean bl) {
            super(methodReference);
            this.setStatic(bl);
            this.l = language;
        }

        public SSAInstruction[] getStatements() {
            if (this.getReturnType().equals(TypeReference.Void)) {
                return NO_STATEMENTS;
            }
            int n = this.getNumberOfParameters() + 1;
            SSAInstruction[] sSAInstructionArray = new SSAInstruction[1];
            SSAInstructionFactory sSAInstructionFactory = this.l.instructionFactory();
            sSAInstructionArray[0] = sSAInstructionFactory.ReturnInstruction(n, this.getReturnType().isPrimitiveType());
            return sSAInstructionArray;
        }
    }
}

