/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BypassSyntheticClassLoader
implements IClassLoader {
    private final ClassLoaderReference me;
    private final IClassLoader parent;
    private final IClassHierarchy cha;
    private final HashMap<TypeName, IClass> syntheticClasses = HashMapFactory.make();

    public BypassSyntheticClassLoader(ClassLoaderReference classLoaderReference, IClassLoader iClassLoader, SetOfClasses setOfClasses, IClassHierarchy iClassHierarchy) {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("null cha");
        }
        this.me = classLoaderReference;
        this.cha = iClassHierarchy;
        this.parent = iClassLoader;
    }

    public String toString() {
        return this.me.getName().toString();
    }

    @Override
    public IClass lookupClass(TypeName typeName) {
        IClass iClass = this.parent.lookupClass(typeName);
        if (iClass == null) {
            IClass iClass2 = this.syntheticClasses.get(typeName);
            return iClass2;
        }
        return iClass;
    }

    public void registerClass(TypeName typeName, IClass iClass) {
        this.cha.addClass(iClass);
        this.syntheticClasses.put(typeName, iClass);
    }

    @Override
    public ClassLoaderReference getReference() {
        return this.me;
    }

    @Override
    public Iterator<IClass> iterateAllClasses() {
        return this.syntheticClasses.values().iterator();
    }

    @Override
    public int getNumberOfClasses() {
        return this.syntheticClasses.size();
    }

    @Override
    public Atom getName() {
        return this.me.getName();
    }

    @Override
    public Language getLanguage() {
        return Language.JAVA;
    }

    @Override
    public int getNumberOfMethods() {
        return 0;
    }

    @Override
    public String getSourceFileName(IClass iClass) {
        return null;
    }

    @Override
    public IClassLoader getParent() {
        return this.parent;
    }

    @Override
    public void init(List<Module> list) throws IOException {
    }

    @Override
    public void removeAll(Collection<IClass> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("toRemove is null");
        }
        for (IClass iClass : collection) {
            this.syntheticClasses.remove(iClass.getName());
        }
    }

    @Override
    public InputStream getSource(IClass iClass) {
        return null;
    }

    @Override
    public SSAInstructionFactory getInstructionFactory() {
        return this.getLanguage().instructionFactory();
    }

    @Override
    public InputStream getSource(IMethod iMethod, int n) {
        return null;
    }

    @Override
    public String getSourceFileName(IMethod iMethod, int n) {
        return null;
    }
}

