/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MethodBypass {
    static final boolean DEBUG = false;
    private final Map methodSummaries;
    private final Set allocatable;
    private final IClassHierarchy cha;
    private final HashMap<MethodReference, SummarizedMethod> syntheticMethods = HashMapFactory.make();
    private final HashSet<MethodReference> considered = HashSetFactory.make();

    public MethodBypass(Map map, Set set, IClassHierarchy iClassHierarchy) {
        this.methodSummaries = map;
        this.allocatable = set;
        this.cha = iClassHierarchy;
    }

    private SyntheticMethod getBypass(MethodReference methodReference) {
        SyntheticMethod syntheticMethod = this.findOrCreateSyntheticMethod(methodReference);
        if (syntheticMethod != null) {
            return syntheticMethod;
        }
        methodReference = this.resolveTarget(methodReference);
        return this.findOrCreateSyntheticMethod(methodReference);
    }

    private SyntheticMethod findOrCreateSyntheticMethod(MethodReference methodReference) {
        if (this.considered.contains(methodReference)) {
            return this.syntheticMethods.get(methodReference);
        }
        this.considered.add(methodReference);
        MethodSummary methodSummary = this.findSummary(methodReference);
        if (methodSummary != null) {
            TypeReference typeReference = methodReference.getDeclaringClass();
            IClass iClass = this.cha.lookupClass(typeReference);
            assert (iClass != null) : "null class for " + typeReference;
            SummarizedMethod summarizedMethod = new SummarizedMethod(methodReference, methodSummary, iClass);
            this.syntheticMethods.put(methodReference, summarizedMethod);
            return summarizedMethod;
        }
        return null;
    }

    private MethodSummary findSummary(MemberReference memberReference) {
        MethodSummary methodSummary = (MethodSummary)this.methodSummaries.get(memberReference);
        if (methodSummary != null) {
            return methodSummary;
        }
        TypeReference typeReference = memberReference.getDeclaringClass();
        methodSummary = (MethodSummary)this.methodSummaries.get(typeReference);
        if (methodSummary != null) {
            return methodSummary;
        }
        if (typeReference.isArrayType()) {
            return null;
        }
        Atom atom = this.extractPackage(typeReference);
        methodSummary = (MethodSummary)this.methodSummaries.get(atom);
        if (methodSummary != null) {
            return methodSummary;
        }
        return methodSummary;
    }

    public SyntheticMethod getBypass(IMethod iMethod) {
        if (iMethod == null) {
            throw new IllegalArgumentException("target is null");
        }
        return this.getBypass(iMethod.getReference());
    }

    private Atom extractPackage(TypeReference typeReference) {
        String string = typeReference.getName().toString();
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return null;
        }
        string = string.substring(0, n);
        return Atom.findOrCreateAsciiAtom(string);
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    protected MethodReference resolveTarget(MethodReference methodReference) {
        IMethod iMethod = this.getClassHierarchy().resolveMethod(methodReference);
        if (iMethod != null) {
            methodReference = iMethod.getReference();
        }
        return methodReference;
    }

    public boolean isAllocatable(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (!iClass.isAbstract() && !iClass.isInterface()) {
            return true;
        }
        return this.allocatable.contains(iClass.getReference());
    }
}

