/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSummary {
    protected static final SSAInstruction[] NO_STATEMENTS = new SSAInstruction[0];
    private final MethodReference method;
    private ArrayList<SSAInstruction> statements;
    private Map<Integer, ConstantValue> constantValues;
    private int nextProgramCounter = 0;
    private String poison;
    private byte poisonLevel;
    private boolean isStatic = false;
    private boolean isFactory = false;

    public MethodSummary(MethodReference methodReference) {
        if (methodReference == null) {
            throw new IllegalArgumentException("null method");
        }
        this.method = methodReference;
    }

    public void addStatement(SSAInstruction sSAInstruction) {
        if (this.statements == null) {
            this.statements = new ArrayList();
        }
        this.statements.add(sSAInstruction);
    }

    public void addConstant(Integer n, ConstantValue constantValue) {
        if (this.constantValues == null) {
            this.constantValues = HashMapFactory.make(5);
        }
        this.constantValues.put(n, constantValue);
    }

    public MemberReference getMethod() {
        return this.method;
    }

    public boolean isNative() {
        return false;
    }

    public void addPoison(String string) {
        this.poison = string;
    }

    public boolean hasPoison() {
        return this.poison != null;
    }

    public String getPoison() {
        return this.poison;
    }

    public void setPoisonLevel(byte by) {
        this.poisonLevel = by;
        assert (by == 0 || by == 1 || by == 2);
    }

    public byte getPoisonLevel() {
        return this.poisonLevel;
    }

    public SSAInstruction[] getStatements() {
        if (this.statements == null) {
            return NO_STATEMENTS;
        }
        SSAInstruction[] sSAInstructionArray = new SSAInstruction[this.statements.size()];
        Iterator<SSAInstruction> iterator = this.statements.iterator();
        int n = 0;
        while (n < sSAInstructionArray.length) {
            sSAInstructionArray[n] = iterator.next();
            ++n;
        }
        return sSAInstructionArray;
    }

    public Map<Integer, ConstantValue> getConstants() {
        return this.constantValues;
    }

    public int getNumberOfParameters() {
        return this.isStatic() ? this.method.getNumberOfParameters() : this.method.getNumberOfParameters() + 1;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean bl) {
        this.isStatic = bl;
    }

    public TypeReference getReturnType() {
        return this.method.getReturnType();
    }

    public String toString() {
        return "[Summary: " + this.method + "]";
    }

    public TypeReference getParameterType(int n) {
        if (this.isStatic()) {
            return this.method.getParameterType(n);
        }
        if (n == 0) {
            return this.method.getDeclaringClass();
        }
        return this.method.getParameterType(n - 1);
    }

    public int getNextProgramCounter() {
        return this.nextProgramCounter++;
    }

    public void setFactory(boolean bl) {
        this.isFactory = bl;
    }

    public boolean isFactory() {
        return this.isFactory;
    }
}

