/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAIndirectionData;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IR {
    private final IMethod method;
    private final SSAOptions options;
    private final SSACFG cfg;
    private final SSAInstruction[] instructions;
    private final SymbolTable symbolTable;
    private final BasicNaturalRelation callSiteMapping = new BasicNaturalRelation();
    private final Map<NewSiteReference, Integer> newSiteMapping = HashMapFactory.make();
    private final Map<ProgramCounter, Integer> peiMapping = HashMapFactory.make();
    private Map<SSAInstruction, ISSABasicBlock> instruction2Block;

    protected abstract SSA2LocalMap getLocalMap();

    protected abstract <T extends SSAIndirectionData.Name> SSAIndirectionData<T> getIndirectionData();

    protected IR(IMethod iMethod, SSAInstruction[] sSAInstructionArray, SymbolTable symbolTable, SSACFG sSACFG, SSAOptions sSAOptions) {
        if (iMethod == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.method = iMethod;
        this.instructions = sSAInstructionArray;
        this.symbolTable = symbolTable;
        this.cfg = sSACFG;
        this.options = sSAOptions;
    }

    protected void setupLocationMap() {
        int n = 0;
        while (n < this.instructions.length) {
            SSAInstruction sSAInstruction = this.instructions[n];
            if (sSAInstruction != null) {
                if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                    this.callSiteMapping.add(((SSAAbstractInvokeInstruction)sSAInstruction).getCallSite().getProgramCounter(), n);
                }
                if (sSAInstruction instanceof SSANewInstruction) {
                    this.newSiteMapping.put(((SSANewInstruction)sSAInstruction).getNewSite(), new Integer(n));
                }
                if (sSAInstruction.isPEI()) {
                    this.peiMapping.put(new ProgramCounter(this.cfg.getProgramCounter(n)), new Integer(n));
                }
            }
            ++n;
        }
    }

    protected abstract String instructionPosition(int var1);

    public String toString() {
        Collection collection = null;
        if (this.getIndirectionData() != null) {
            collection = this.getIndirectionData().getNames();
        }
        StringBuffer stringBuffer = new StringBuffer(this.method.toString());
        stringBuffer.append("\nCFG:\n");
        stringBuffer.append(this.cfg.toString());
        stringBuffer.append("Instructions:\n");
        int n = 0;
        while (n <= this.cfg.getMaxNumber()) {
            Object object;
            SSACFG.BasicBlock basicBlock = this.cfg.getNode(n);
            int n2 = basicBlock.getFirstInstructionIndex();
            int n3 = basicBlock.getLastInstructionIndex();
            stringBuffer.append("BB").append(basicBlock.getNumber());
            if (basicBlock instanceof SSACFG.ExceptionHandlerBasicBlock) {
                stringBuffer.append("<Handler>");
            }
            stringBuffer.append("\n");
            Object object2 = basicBlock.iteratePhis();
            while (object2.hasNext()) {
                object = object2.next();
                if (object == null) continue;
                stringBuffer.append("           " + ((SSAPhiInstruction)object).toString(this.symbolTable)).append("\n");
            }
            if (basicBlock instanceof SSACFG.ExceptionHandlerBasicBlock) {
                object2 = (SSACFG.ExceptionHandlerBasicBlock)basicBlock;
                object = ((SSACFG.ExceptionHandlerBasicBlock)object2).getCatchInstruction();
                if (object != null) {
                    stringBuffer.append("           " + ((SSAGetCaughtExceptionInstruction)object).toString(this.symbolTable)).append("\n");
                } else {
                    stringBuffer.append("            No catch instruction. Unreachable?\n");
                }
            }
            int n4 = n2;
            while (n4 <= n3) {
                if (this.instructions[n4] != null) {
                    if (collection != null) {
                        boolean bl = false;
                        for (SSAIndirectionData.Name name : collection) {
                            if (this.getIndirectionData().getUse(n4, name) == -1) continue;
                            stringBuffer.append(" " + name + " -> " + this.getIndirectionData().getUse(n4, name));
                            bl = true;
                        }
                        if (bl) {
                            stringBuffer.append("\n");
                        }
                    }
                    object = new StringBuffer(String.valueOf(n4) + "   " + this.instructions[n4].toString(this.symbolTable));
                    StringStuff.padWithSpaces((StringBuffer)object, 45);
                    stringBuffer.append((StringBuffer)object);
                    stringBuffer.append(this.instructionPosition(n4));
                    stringBuffer.append("\n");
                    if (collection != null) {
                        boolean bl = false;
                        for (Object object3 : collection) {
                            if (this.getIndirectionData().getDef(n4, object3) == -1) continue;
                            stringBuffer.append(" " + object3 + " <- " + this.getIndirectionData().getDef(n4, object3));
                            bl = true;
                        }
                        if (bl) {
                            stringBuffer.append("\n");
                        }
                    }
                }
                ++n4;
            }
            object2 = basicBlock.iteratePis();
            while (object2.hasNext()) {
                object = object2.next();
                if (object == null) continue;
                stringBuffer.append("           " + ((SSAPiInstruction)object).toString(this.symbolTable)).append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public SSAInstruction[] getInstructions() {
        return this.instructions;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public SSACFG getControlFlowGraph() {
        return this.cfg;
    }

    public Iterator<? extends SSAInstruction> iteratePhis() {
        return new TwoLevelIterator(){

            @Override
            Iterator<? extends SSAInstruction> getBlockIterator(SSACFG.BasicBlock basicBlock) {
                return basicBlock.iteratePhis();
            }
        };
    }

    public Iterator<? extends SSAInstruction> iteratePis() {
        return new TwoLevelIterator(){

            @Override
            Iterator<? extends SSAInstruction> getBlockIterator(SSACFG.BasicBlock basicBlock) {
                return basicBlock.iteratePis();
            }
        };
    }

    public int[] getParameterValueNumbers() {
        return this.symbolTable.getParameterValueNumbers();
    }

    public int getParameter(int n) {
        return this.symbolTable.getParameter(n);
    }

    public TypeReference getParameterType(int n) {
        return this.method.getParameterType(n);
    }

    public int getNumberOfParameters() {
        return this.method.getNumberOfParameters();
    }

    public IMethod getMethod() {
        return this.method;
    }

    public Iterator<SSAInstruction> iterateCatchInstructions() {
        return new CatchIterator();
    }

    public void visitNormalInstructions(SSAInstruction.Visitor visitor) {
        Iterator<SSAInstruction> iterator = this.iterateNormalInstructions();
        while (iterator.hasNext()) {
            iterator.next().visit(visitor);
        }
    }

    public void visitAllInstructions(SSAInstruction.Visitor visitor) {
        Iterator<SSAInstruction> iterator = this.iterateAllInstructions();
        while (iterator.hasNext()) {
            iterator.next().visit(visitor);
        }
    }

    public Iterator<SSAInstruction> iterateNormalInstructions() {
        return new NormalIterator();
    }

    public Iterator<SSAInstruction> iterateAllInstructions() {
        return new CompoundIterator<SSAInstruction>(this.iterateNormalInstructions(), new CompoundIterator<SSAInstruction>(this.iterateCatchInstructions(), new CompoundIterator<SSAInstruction>(this.iteratePhis(), this.iteratePis())));
    }

    public SSACFG.BasicBlock getExitBlock() {
        return this.cfg.exit();
    }

    public SSAAbstractInvokeInstruction[] getCalls(CallSiteReference callSiteReference) {
        if (callSiteReference == null) {
            throw new IllegalArgumentException("site is null");
        }
        IntSet intSet = this.callSiteMapping.getRelated(callSiteReference.getProgramCounter());
        if (intSet == null) {
            throw new IllegalArgumentException("no calls at site's pc");
        }
        SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = new SSAAbstractInvokeInstruction[intSet.size()];
        int n = 0;
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            sSAAbstractInvokeInstructionArray[n++] = (SSAAbstractInvokeInstruction)this.instructions[n2];
        }
        return sSAAbstractInvokeInstructionArray;
    }

    public IntSet getCallInstructionIndices(CallSiteReference callSiteReference) {
        if (callSiteReference == null) {
            throw new IllegalArgumentException("site is null");
        }
        return this.callSiteMapping.getRelated(callSiteReference.getProgramCounter());
    }

    public SSANewInstruction getNew(NewSiteReference newSiteReference) {
        Integer n = this.newSiteMapping.get(newSiteReference);
        return (SSANewInstruction)this.instructions[n];
    }

    public int getNewInstructionIndex(NewSiteReference newSiteReference) {
        Integer n = this.newSiteMapping.get(newSiteReference);
        return n;
    }

    public SSAInstruction getPEI(ProgramCounter programCounter) {
        Integer n = this.peiMapping.get(programCounter);
        return this.instructions[n];
    }

    public Iterator<NewSiteReference> iterateNewSites() {
        return this.newSiteMapping.keySet().iterator();
    }

    public Iterator<CallSiteReference> iterateCallSites() {
        return new Iterator<CallSiteReference>(){
            private final int limit;
            private int i;
            {
                this.limit = IR.this.callSiteMapping.maxKeyValue();
                this.i = -1;
                this.advance();
            }

            private void advance() {
                while (IR.this.callSiteMapping.getRelatedCount(++this.i) == 0 && this.i <= this.limit) {
                }
            }

            @Override
            public boolean hasNext() {
                return this.i <= this.limit;
            }

            @Override
            public CallSiteReference next() {
                int n = IR.this.callSiteMapping.getRelated(this.i).max();
                this.advance();
                return ((SSAAbstractInvokeInstruction)IR.this.instructions[n]).getCallSite();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ISSABasicBlock[] getBasicBlocksForCall(CallSiteReference callSiteReference) {
        if (callSiteReference == null) {
            throw new IllegalArgumentException("site is null");
        }
        IntSet intSet = this.callSiteMapping.getRelated(callSiteReference.getProgramCounter());
        if (intSet == null) {
            throw new IllegalArgumentException("invalid site: " + callSiteReference);
        }
        ISSABasicBlock[] iSSABasicBlockArray = new ISSABasicBlock[intSet.size()];
        int n = 0;
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            iSSABasicBlockArray[n++] = this.getControlFlowGraph().getBlockForInstruction(n2);
        }
        return iSSABasicBlockArray;
    }

    public ISSABasicBlock getBasicBlockForInstruction(SSAInstruction sSAInstruction) {
        if (this.instruction2Block == null) {
            this.mapInstructions2Blocks();
        }
        return this.instruction2Block.get(sSAInstruction);
    }

    private void mapInstructions2Blocks() {
        this.instruction2Block = HashMapFactory.make();
        for (ISSABasicBlock iSSABasicBlock : this.cfg) {
            for (SSAInstruction sSAInstruction : iSSABasicBlock) {
                this.instruction2Block.put(sSAInstruction, iSSABasicBlock);
            }
        }
    }

    public boolean isEmptyIR() {
        if (this.instructions == null) {
            return true;
        }
        int n = 0;
        while (n < this.instructions.length) {
            if (this.instructions[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String[] getLocalNames(int n, int n2) {
        if (this.getLocalMap() == null) {
            return new String[0];
        }
        return this.getLocalMap().getLocalNames(n, n2);
    }

    public ISSABasicBlock getBasicBlockForCatch(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
        if (sSAGetCaughtExceptionInstruction == null) {
            throw new IllegalArgumentException("instruction is null");
        }
        int n = sSAGetCaughtExceptionInstruction.getBasicBlockNumber();
        return this.cfg.getBasicBlock(n);
    }

    public SSAOptions getOptions() {
        return this.options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CatchIterator
    implements Iterator<SSAInstruction> {
        private int currentBlockIndex = 0;

        private boolean hasCatch(Object object) {
            return object instanceof SSACFG.ExceptionHandlerBasicBlock && ((SSACFG.ExceptionHandlerBasicBlock)object).getCatchInstruction() != null;
        }

        CatchIterator() {
            if (!this.hasCatch(IR.this.cfg.getNode(0))) {
                this.advanceBlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentBlockIndex != -1;
        }

        @Override
        public SSAInstruction next() {
            SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)IR.this.cfg.getNode(this.currentBlockIndex);
            SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction = exceptionHandlerBasicBlock.getCatchInstruction();
            this.advanceBlock();
            return sSAGetCaughtExceptionInstruction;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        private void advanceBlock() {
            int n = this.currentBlockIndex + 1;
            while (n < IR.this.cfg.getMaxNumber()) {
                if (this.hasCatch(IR.this.cfg.getNode(n))) {
                    this.currentBlockIndex = n;
                    return;
                }
                ++n;
            }
            this.currentBlockIndex = -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NormalIterator
    implements Iterator<SSAInstruction> {
        int nextIndex = -1;
        final SSAInstruction[] instructions;

        NormalIterator() {
            this.instructions = IR.this.getInstructions();
            this.advanceIndex(0);
        }

        private void advanceIndex(int n) {
            int n2 = n;
            while (n2 < this.instructions.length) {
                if (this.instructions[n2] != null) {
                    this.nextIndex = n2;
                    return;
                }
                ++n2;
            }
            this.nextIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != -1;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        @Override
        public SSAInstruction next() {
            SSAInstruction sSAInstruction = this.instructions[this.nextIndex];
            this.advanceIndex(this.nextIndex + 1);
            return sSAInstruction;
        }
    }

    public static interface SSA2LocalMap {
        public String[] getLocalNames(int var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class TwoLevelIterator
    implements Iterator<SSAInstruction> {
        private Iterator<? extends SSAInstruction> currentBlockIterator;
        private int currentBlockIndex = 0;

        abstract Iterator<? extends SSAInstruction> getBlockIterator(SSACFG.BasicBlock var1);

        TwoLevelIterator() {
            this.currentBlockIterator = IR.this.cfg.getNode(0).iteratePhis();
            if (!this.currentBlockIterator.hasNext()) {
                this.advanceBlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentBlockIndex != -1;
        }

        @Override
        public SSAInstruction next() {
            SSAInstruction sSAInstruction = this.currentBlockIterator.next();
            if (!this.currentBlockIterator.hasNext()) {
                this.advanceBlock();
            }
            return sSAInstruction;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        private void advanceBlock() {
            int n = this.currentBlockIndex + 1;
            while (n <= IR.this.cfg.getMaxNumber()) {
                Iterator<? extends SSAInstruction> iterator = this.getBlockIterator(IR.this.cfg.getNode(n));
                if (iterator.hasNext()) {
                    this.currentBlockIndex = n;
                    this.currentBlockIterator = iterator;
                    return;
                }
                ++n;
            }
            this.currentBlockIterator = null;
            this.currentBlockIndex = -1;
        }
    }
}

