/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.IVisitorWithAddresses;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public class SSAAddressOfInstruction
extends SSAInstruction {
    private final int lval;
    private final int addressVal;
    private final int indexVal;
    private final FieldReference field;
    private final TypeReference pointeeType;

    public SSAAddressOfInstruction(int n, int n2, TypeReference typeReference) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid local address load of " + n2);
        }
        this.lval = n;
        this.addressVal = n2;
        this.indexVal = -1;
        this.field = null;
        this.pointeeType = typeReference;
    }

    public SSAAddressOfInstruction(int n, int n2, int n3, TypeReference typeReference) {
        this.lval = n;
        this.addressVal = n2;
        this.indexVal = n3;
        this.field = null;
        this.pointeeType = typeReference;
    }

    public SSAAddressOfInstruction(int n, int n2, FieldReference fieldReference, TypeReference typeReference) {
        this.lval = n;
        this.addressVal = n2;
        this.indexVal = -1;
        this.field = fieldReference;
        this.pointeeType = typeReference;
    }

    public TypeReference getType() {
        return this.pointeeType;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        Assertions.UNREACHABLE("not yet implemented.  to be nuked");
        return null;
    }

    public int hashCode() {
        return this.lval * 99701 + this.addressVal;
    }

    public boolean isFallThrough() {
        return true;
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.lval)) + " (" + this.pointeeType.getName() + ") " + " = &" + this.getValueString(symbolTable, this.addressVal) + (this.indexVal != -1 ? "[" + this.getValueString(symbolTable, this.indexVal) + "]" : (this.field != null ? "." + this.field.getName().toString() : ""));
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        assert (iVisitor instanceof IVisitorWithAddresses) : "expected an instance of IVisitorWithAddresses";
        ((IVisitorWithAddresses)iVisitor).visitAddressOf(this);
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getDef(int n) {
        assert (n == 0);
        return this.lval;
    }

    public int getDef() {
        return this.lval;
    }

    public int getNumberOfUses() {
        return this.indexVal == -1 ? 1 : 2;
    }

    public int getUse(int n) {
        assert (n == 0 || n == 1 && this.indexVal != -1);
        if (n == 0) {
            return this.addressVal;
        }
        return this.indexVal;
    }
}

