/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSAArrayLoadInstruction
extends SSAArrayReferenceInstruction {
    private final int result;

    protected SSAArrayLoadInstruction(int n, int n2, int n3, TypeReference typeReference) {
        super(n2, n3, typeReference);
        this.result = n;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) throws IllegalArgumentException {
        if (nArray != null && nArray.length == 0) {
            throw new IllegalArgumentException("defs.length == 0");
        }
        if (nArray2 != null && nArray2.length < 2) {
            throw new IllegalArgumentException("uses.length < 2");
        }
        return sSAInstructionFactory.ArrayLoadInstruction(nArray == null ? this.result : nArray[0], nArray2 == null ? this.getArrayRef() : nArray2[0], nArray2 == null ? this.getIndex() : nArray2[1], this.getElementType());
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = arrayload " + this.getValueString(symbolTable, this.getArrayRef()) + "[" + this.getValueString(symbolTable, this.getIndex()) + "]";
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitArrayLoad(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("illegal i: " + n);
        }
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int hashCode() {
        return 6311 * this.result ^ 2371 * this.getArrayRef() + this.getIndex();
    }
}

