/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.analysis.stackMachine.AbstractIntStackMachine;
import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadIndirectInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreIndirectInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.ITypeTestInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.IndirectionData;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.PhiValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPiNodePolicy;
import com.ibm.wala.ssa.ShrikeIndirectionData;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.shrike.ShrikeUtil;

public class SSABuilder
extends AbstractIntStackMachine {
    private final IBytecodeMethod method;
    private final SymbolTable symbolTable;
    private final SSA2LocalMap localMap;
    private final SSAInstructionFactory insts;
    private final IndirectionData bytecodeIndirections;
    private final ShrikeIndirectionData ssaIndirections;

    public static SSABuilder make(IBytecodeMethod iBytecodeMethod, SSACFG sSACFG, ShrikeCFG shrikeCFG, SSAInstruction[] sSAInstructionArray, SymbolTable symbolTable, boolean bl, SSAPiNodePolicy sSAPiNodePolicy) throws IllegalArgumentException {
        if (shrikeCFG == null) {
            throw new IllegalArgumentException("scfg == null");
        }
        return new SSABuilder(iBytecodeMethod, sSACFG, shrikeCFG, sSAInstructionArray, symbolTable, bl, sSAPiNodePolicy);
    }

    private SSABuilder(IBytecodeMethod iBytecodeMethod, SSACFG sSACFG, ShrikeCFG shrikeCFG, SSAInstruction[] sSAInstructionArray, SymbolTable symbolTable, boolean bl, SSAPiNodePolicy sSAPiNodePolicy) {
        super(shrikeCFG);
        this.localMap = bl ? new SSA2LocalMap(shrikeCFG, sSAInstructionArray.length, sSACFG.getNumberOfNodes(), this.maxLocals) : null;
        this.init(new SymbolTableMeeter(symbolTable, sSACFG, sSAInstructionArray, shrikeCFG), new SymbolicPropagator(shrikeCFG, sSAInstructionArray, symbolTable, this.localMap, sSACFG, sSAPiNodePolicy));
        this.method = iBytecodeMethod;
        this.symbolTable = symbolTable;
        this.insts = iBytecodeMethod.getDeclaringClass().getClassLoader().getInstructionFactory();
        this.bytecodeIndirections = iBytecodeMethod.getIndirectionData();
        this.ssaIndirections = new ShrikeIndirectionData(sSAInstructionArray.length);
        assert (sSACFG != null) : "Null CFG";
    }

    protected void initializeVariables() {
        AbstractIntStackMachine.MachineState machineState = this.getEntryState();
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.method.getNumberOfParameters()) {
            ++n2;
            TypeReference typeReference = this.method.getParameterType(n3);
            if (typeReference != null) {
                int n4 = this.symbolTable.getParameter(n++);
                machineState.setLocal(n2, n4);
                if (typeReference.equals(TypeReference.Double) || typeReference.equals(TypeReference.Long)) {
                    ++n2;
                }
            }
            ++n3;
        }
        machineState.push(this.symbolTable.newSymbol());
    }

    public void build() {
        this.solve();
        if (this.localMap != null) {
            this.localMap.finishLocalMap(this);
        }
    }

    public SSA2LocalMap getLocalMap() {
        return this.localMap;
    }

    public ShrikeIndirectionData getIndirectionData() {
        return this.ssaIndirections;
    }

    private static class SSA2LocalMap
    implements IR.SSA2LocalMap {
        private final ShrikeCFG shrikeCFG;
        private final IntPair[] localStoreMap;
        private final int[][] block2LocalState;
        private final int maxLocals;

        SSA2LocalMap(ShrikeCFG shrikeCFG, int n, int n2, int n3) {
            this.shrikeCFG = shrikeCFG;
            this.localStoreMap = new IntPair[n];
            this.block2LocalState = new int[n2][];
            this.maxLocals = n3;
        }

        void startRange(int n, int n2, int n3) {
            int n4 = this.shrikeCFG.getMethod().getMaxLocals();
            if (n2 >= n4) assert (false) : "invalid local " + n2 + ">" + n4;
            this.localStoreMap[n] = new IntPair(n3, n2);
        }

        private void finishLocalMap(SSABuilder sSABuilder) {
            for (ShrikeCFG.BasicBlock basicBlock : this.shrikeCFG) {
                AbstractIntStackMachine.MachineState machineState = sSABuilder.getIn(basicBlock);
                int n = basicBlock.getNumber();
                this.block2LocalState[n] = machineState.getLocals();
            }
        }

        public String[] getLocalNames(int n, int n2) {
            int[] nArray;
            block6: {
                block5: {
                    if (this.shrikeCFG.getMethod().hasLocalVariableTable()) break block5;
                    return null;
                }
                nArray = this.findLocalsForValueNumber(n, n2);
                if (nArray != null) break block6;
                return null;
            }
            try {
                IBytecodeMethod iBytecodeMethod = this.shrikeCFG.getMethod();
                String[] stringArray = new String[nArray.length];
                int n3 = 0;
                while (n3 < nArray.length) {
                    stringArray[n3] = iBytecodeMethod.getLocalVariableName(iBytecodeMethod.getBytecodeIndex(n), nArray[n3]);
                    ++n3;
                }
                return stringArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }

        private int[] findLocalsForValueNumber(int n, int n2) {
            ShrikeCFG.BasicBlock basicBlock = this.shrikeCFG.getBlockForInstruction(n);
            int n3 = basicBlock.getFirstInstructionIndex();
            int[] nArray = this.block2LocalState[basicBlock.getNumber()];
            if (nArray == null) {
                nArray = this.allocateNewLocalsArray();
            }
            int n4 = n3;
            while (n4 <= n) {
                if (this.localStoreMap[n4] != null) {
                    IntPair intPair = this.localStoreMap[n4];
                    nArray[intPair.getY()] = intPair.getX();
                }
                ++n4;
            }
            return this.extractIndices(nArray, n2);
        }

        public int[] allocateNewLocalsArray() {
            int[] nArray = new int[this.maxLocals];
            int n = 0;
            while (n < this.maxLocals) {
                nArray[n] = -1;
                ++n;
            }
            return nArray;
        }

        private int[] extractIndices(int[] nArray, int n) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == n) {
                    ++n2;
                }
                ++n3;
            }
            if (n2 == 0) {
                return null;
            }
            int[] nArray2 = new int[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < nArray.length) {
                if (nArray[n5] == n) {
                    nArray2[n4++] = n5;
                }
                ++n5;
            }
            return nArray2;
        }
    }

    private class SymbolTableMeeter
    implements AbstractIntStackMachine.Meeter {
        final SSACFG cfg;
        final SSAInstruction[] instructions;
        final SymbolTable symbolTable;
        final ShrikeCFG shrikeCFG;

        SymbolTableMeeter(SymbolTable symbolTable, SSACFG sSACFG, SSAInstruction[] sSAInstructionArray, ShrikeCFG shrikeCFG) {
            this.cfg = sSACFG;
            this.instructions = sSAInstructionArray;
            this.symbolTable = symbolTable;
            this.shrikeCFG = shrikeCFG;
        }

        public int meetStack(int n, int[] nArray, ShrikeCFG.BasicBlock basicBlock) {
            int n2;
            assert (basicBlock != null) : "null basic block";
            if (basicBlock.isExitBlock()) {
                return -1;
            }
            if (this.allTheSame(nArray)) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (nArray[n3] != -1) {
                        return nArray[n3];
                    }
                    ++n3;
                }
                return -1;
            }
            SSACFG.BasicBlock basicBlock2 = this.cfg.getNode(this.shrikeCFG.getNumber(basicBlock));
            SSAPhiInstruction sSAPhiInstruction = basicBlock2.getPhiForStackSlot(n);
            if (sSAPhiInstruction == null) {
                n2 = this.symbolTable.newPhi(nArray);
                PhiValue phiValue = this.symbolTable.getPhiValue(n2);
                sSAPhiInstruction = phiValue.getPhiInstruction();
                basicBlock2.addPhiForStackSlot(n, sSAPhiInstruction);
            } else {
                n2 = sSAPhiInstruction.getDef();
                sSAPhiInstruction.setValues((int[])nArray.clone());
            }
            return n2;
        }

        public int meetLocal(int n, int[] nArray, ShrikeCFG.BasicBlock basicBlock) {
            int n2;
            if (this.allTheSame(nArray)) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (nArray[n3] != -1) {
                        return nArray[n3];
                    }
                    ++n3;
                }
                return -1;
            }
            SSACFG.BasicBlock basicBlock2 = this.cfg.getNode(this.shrikeCFG.getNumber(basicBlock));
            if (basicBlock.isExitBlock()) {
                return -1;
            }
            SSAPhiInstruction sSAPhiInstruction = basicBlock2.getPhiForLocal(n);
            if (sSAPhiInstruction == null) {
                n2 = this.symbolTable.newPhi(nArray);
                PhiValue phiValue = this.symbolTable.getPhiValue(n2);
                sSAPhiInstruction = phiValue.getPhiInstruction();
                basicBlock2.addPhiForLocal(n, sSAPhiInstruction);
            } else {
                n2 = sSAPhiInstruction.getDef();
                sSAPhiInstruction.setValues((int[])nArray.clone());
            }
            return n2;
        }

        private boolean allTheSame(int[] nArray) {
            int n = -1;
            int n2 = 0;
            n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] != -1) {
                    n = nArray[n2];
                    break;
                }
                ++n2;
            }
            ++n2;
            while (n2 < nArray.length) {
                if (nArray[n2] != n && nArray[n2] != -1) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public int meetStackAtCatchBlock(ShrikeCFG.BasicBlock basicBlock) {
            int n;
            int n2 = this.shrikeCFG.getNumber(basicBlock);
            SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)this.cfg.getNode(n2);
            SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction = exceptionHandlerBasicBlock.getCatchInstruction();
            if (sSAGetCaughtExceptionInstruction == null) {
                n = this.symbolTable.newSymbol();
                sSAGetCaughtExceptionInstruction = SSABuilder.this.insts.GetCaughtExceptionInstruction(n2, n);
                exceptionHandlerBasicBlock.setCatchInstruction(sSAGetCaughtExceptionInstruction);
            } else {
                n = sSAGetCaughtExceptionInstruction.getException();
            }
            return n;
        }
    }

    private class SymbolicPropagator
    extends AbstractIntStackMachine.BasicStackFlowProvider {
        final SSAInstruction[] instructions;
        final SymbolTable symbolTable;
        final ShrikeCFG shrikeCFG;
        final SSACFG cfg;
        final ClassLoaderReference loader;
        private SSAInstruction[] creators;
        final SSA2LocalMap localMap;
        final SSAPiNodePolicy piNodePolicy;

        public SymbolicPropagator(ShrikeCFG shrikeCFG, SSAInstruction[] sSAInstructionArray, SymbolTable symbolTable, SSA2LocalMap sSA2LocalMap, SSACFG sSACFG, SSAPiNodePolicy sSAPiNodePolicy) {
            super(shrikeCFG);
            this.piNodePolicy = sSAPiNodePolicy;
            this.cfg = sSACFG;
            this.creators = new SSAInstruction[0];
            this.shrikeCFG = shrikeCFG;
            this.instructions = sSAInstructionArray;
            this.symbolTable = symbolTable;
            this.loader = shrikeCFG.getMethod().getDeclaringClass().getClassLoader().getReference();
            this.localMap = sSA2LocalMap;
            this.init(new NodeVisitor(), new EdgeVisitor());
        }

        public boolean needsEdgeFlow() {
            return this.piNodePolicy != null;
        }

        private void emitInstruction(SSAInstruction sSAInstruction) {
            this.instructions[this.getCurrentInstructionIndex()] = sSAInstruction;
            int n = 0;
            while (n < sSAInstruction.getNumberOfDefs()) {
                if (this.creators.length < sSAInstruction.getDef(n) + 1) {
                    SSAInstruction[] sSAInstructionArray = new SSAInstruction[2 * sSAInstruction.getDef(n)];
                    System.arraycopy(this.creators, 0, sSAInstructionArray, 0, this.creators.length);
                    this.creators = sSAInstructionArray;
                }
                assert (sSAInstruction.getDef(n) != -1) : "invalid def " + n + " for " + sSAInstruction;
                this.creators[sSAInstruction.getDef((int)n)] = sSAInstruction;
                ++n;
            }
        }

        private SSAInstruction getCurrentInstruction() {
            return this.instructions[this.getCurrentInstructionIndex()];
        }

        private int reuseOrCreateDef() {
            if (this.getCurrentInstruction() == null) {
                return this.symbolTable.newSymbol();
            }
            return this.getCurrentInstruction().getDef();
        }

        private int reuseOrCreateException() {
            if (this.getCurrentInstruction() != null) assert (this.getCurrentInstruction() instanceof SSAInvokeInstruction);
            if (this.getCurrentInstruction() == null) {
                return this.symbolTable.newSymbol();
            }
            SSAInvokeInstruction sSAInvokeInstruction = (SSAInvokeInstruction)this.getCurrentInstruction();
            return sSAInvokeInstruction.getException();
        }

        private void reuseOrCreatePi(SSAInstruction sSAInstruction, int n) {
            int n2 = this.getCurrentInstructionIndex();
            SSACFG.BasicBlock basicBlock = this.cfg.getBlockForInstruction(n2);
            ShrikeCFG.BasicBlock basicBlock2 = this.getCurrentSuccessor();
            int n3 = this.shrikeCFG.getNumber(basicBlock2);
            SSAPiInstruction sSAPiInstruction = basicBlock.getPiForRefAndPath(n, basicBlock2);
            if (sSAPiInstruction == null) {
                sSAPiInstruction = SSABuilder.this.insts.PiInstruction(this.symbolTable.newSymbol(), n, basicBlock.getNumber(), n3, sSAInstruction);
                basicBlock.addPiForRefAndPath(n, basicBlock2, sSAPiInstruction);
            }
            this.workingState.replaceValue(n, sSAPiInstruction.getDef());
        }

        private void maybeInsertPi(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction) {
            Pair<Integer, SSAInstruction> pair;
            if (this.piNodePolicy != null && (pair = this.piNodePolicy.getPi(sSAAbstractInvokeInstruction, this.symbolTable)) != null) {
                this.reuseOrCreatePi((SSAInstruction)pair.snd, (Integer)pair.fst);
            }
        }

        private void maybeInsertPi(SSAConditionalBranchInstruction sSAConditionalBranchInstruction) {
            Pair<Integer, SSAInstruction> pair;
            if (this.piNodePolicy != null && (pair = this.piNodePolicy.getPi(sSAConditionalBranchInstruction, this.getDef(sSAConditionalBranchInstruction.getUse(0)), this.getDef(sSAConditionalBranchInstruction.getUse(1)), this.symbolTable)) != null) {
                this.reuseOrCreatePi((SSAInstruction)pair.snd, (Integer)pair.fst);
            }
        }

        private SSAInstruction getDef(int n) {
            if (n < this.creators.length) {
                return this.creators[n];
            }
            return null;
        }

        public IInstruction[] getInstructions() {
            try {
                return this.shrikeCFG.getMethod().getInstructions();
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }

        class EdgeVisitor
        extends IInstruction.Visitor {
            EdgeVisitor() {
            }

            public void visitInvoke(IInvokeInstruction iInvokeInstruction) {
                SymbolicPropagator.this.maybeInsertPi((SSAAbstractInvokeInstruction)SymbolicPropagator.this.getCurrentInstruction());
            }

            public void visitConditionalBranch(IConditionalBranchInstruction iConditionalBranchInstruction) {
                SymbolicPropagator.this.maybeInsertPi((SSAConditionalBranchInstruction)SymbolicPropagator.this.getCurrentInstruction());
            }
        }

        class NodeVisitor
        extends AbstractIntStackMachine.BasicStackFlowProvider.BasicStackMachineVisitor {
            private Dominators<ISSABasicBlock> dom = null;

            NodeVisitor() {
            }

            public void visitArrayLength(ArrayLengthInstruction arrayLengthInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(n2);
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ArrayLengthInstruction(n2, n));
            }

            public void visitArrayLoad(IArrayLoadInstruction iArrayLoadInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.workingState.pop();
                int n3 = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(n3);
                TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, iArrayLoadInstruction.getType());
                if (iArrayLoadInstruction.isAddressOf()) {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.AddressOfInstruction(n3, n2, n, typeReference));
                } else {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ArrayLoadInstruction(n3, n2, n, typeReference));
                }
            }

            public void visitArrayStore(IArrayStoreInstruction iArrayStoreInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.workingState.pop();
                int n3 = SymbolicPropagator.this.workingState.pop();
                TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, iArrayStoreInstruction.getType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ArrayStoreInstruction(n3, n2, n, typeReference));
            }

            public void visitBinaryOp(IBinaryOpInstruction iBinaryOpInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.workingState.pop();
                int n3 = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(n3);
                boolean bl = iBinaryOpInstruction.getType().equals("D") || iBinaryOpInstruction.getType().equals("F");
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.BinaryOpInstruction(iBinaryOpInstruction.getOperator(), iBinaryOpInstruction.throwsExceptionOnOverflow(), iBinaryOpInstruction.isUnsigned(), n3, n2, n, !bl));
            }

            public void visitCheckCast(ITypeTestInstruction iTypeTestInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(n2);
                if (!iTypeTestInstruction.firstClassTypes()) {
                    String[] stringArray = iTypeTestInstruction.getTypes();
                    TypeReference[] typeReferenceArray = new TypeReference[stringArray.length];
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        typeReferenceArray[n3] = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, stringArray[n3]);
                        ++n3;
                    }
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.CheckCastInstruction(n2, n, typeReferenceArray));
                }
            }

            public void visitComparison(IComparisonInstruction iComparisonInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.workingState.pop();
                int n3 = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(n3);
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ComparisonInstruction(iComparisonInstruction.getOperator(), n3, n2, n));
            }

            public void visitConditionalBranch(IConditionalBranchInstruction iConditionalBranchInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.workingState.pop();
                TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, iConditionalBranchInstruction.getType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ConditionalBranchInstruction(iConditionalBranchInstruction.getOperator(), typeReference, n2, n));
            }

            public void visitConstant(ConstantInstruction constantInstruction) {
                Language language = SymbolicPropagator.this.cfg.getMethod().getDeclaringClass().getClassLoader().getLanguage();
                TypeReference typeReference = language.getConstantType(constantInstruction.getValue());
                int n = 0;
                if (language.isNullType(typeReference)) {
                    n = SymbolicPropagator.this.symbolTable.getNullConstant();
                } else if (language.isIntType(typeReference)) {
                    Integer n2 = (Integer)constantInstruction.getValue();
                    n = SymbolicPropagator.this.symbolTable.getConstant(n2);
                } else if (language.isLongType(typeReference)) {
                    Long l = (Long)constantInstruction.getValue();
                    n = SymbolicPropagator.this.symbolTable.getConstant(l);
                } else if (language.isFloatType(typeReference)) {
                    Float f = (Float)constantInstruction.getValue();
                    n = SymbolicPropagator.this.symbolTable.getConstant(f.floatValue());
                } else if (language.isDoubleType(typeReference)) {
                    Double d = (Double)constantInstruction.getValue();
                    n = SymbolicPropagator.this.symbolTable.getConstant(d);
                } else if (language.isStringType(typeReference)) {
                    String string = (String)constantInstruction.getValue();
                    n = SymbolicPropagator.this.symbolTable.getConstant(string);
                } else if (language.isMetadataType(typeReference)) {
                    Object object = language.getMetadataToken(constantInstruction.getValue());
                    n = SymbolicPropagator.this.reuseOrCreateDef();
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.LoadMetadataInstruction(n, typeReference, object));
                } else {
                    Assertions.UNREACHABLE("unexpected " + typeReference);
                }
                SymbolicPropagator.this.workingState.push(n);
            }

            public void visitConversion(IConversionInstruction iConversionInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(n2);
                TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, iConversionInstruction.getFromType());
                TypeReference typeReference2 = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, iConversionInstruction.getToType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ConversionInstruction(n2, n, typeReference, typeReference2, iConversionInstruction.throwsExceptionOnOverflow()));
            }

            public void visitGet(IGetInstruction iGetInstruction) {
                int n = SymbolicPropagator.this.reuseOrCreateDef();
                FieldReference fieldReference = FieldReference.findOrCreate(SymbolicPropagator.this.loader, iGetInstruction.getClassType(), iGetInstruction.getFieldName(), iGetInstruction.getFieldType());
                if (iGetInstruction.isAddressOf()) {
                    int n2 = iGetInstruction.isStatic() ? -1 : SymbolicPropagator.this.workingState.pop();
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.AddressOfInstruction(n, n2, fieldReference, fieldReference.getFieldType()));
                } else if (iGetInstruction.isStatic()) {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.GetInstruction(n, fieldReference));
                } else {
                    int n3 = SymbolicPropagator.this.workingState.pop();
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.GetInstruction(n, n3, fieldReference));
                }
                SymbolicPropagator.this.workingState.push(n);
            }

            public void visitGoto(GotoInstruction gotoInstruction) {
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.GotoInstruction());
            }

            public void visitInstanceof(IInstanceofInstruction iInstanceofInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(n2);
                TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, iInstanceofInstruction.getType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.InstanceofInstruction(n2, n, typeReference));
            }

            public void visitInvoke(IInvokeInstruction iInvokeInstruction) {
                this.doIndirectReads(SSABuilder.this.bytecodeIndirections.indirectlyReadLocals(SymbolicPropagator.this.getCurrentInstructionIndex()));
                int n = iInvokeInstruction.getPoppedCount();
                int[] nArray = new int[n];
                int n2 = n - 1;
                while (n2 >= 0) {
                    nArray[n2] = SymbolicPropagator.this.workingState.pop();
                    --n2;
                }
                Language language = SymbolicPropagator.this.shrikeCFG.getMethod().getDeclaringClass().getClassLoader().getLanguage();
                MethodReference methodReference = MethodReference.findOrCreate(language, SymbolicPropagator.this.loader, iInvokeInstruction.getClassType(), iInvokeInstruction.getMethodName(), iInvokeInstruction.getMethodSignature());
                IInvokeInstruction.IDispatch iDispatch = iInvokeInstruction.getInvocationCode();
                CallSiteReference callSiteReference = CallSiteReference.make(SymbolicPropagator.this.getCurrentProgramCounter(), methodReference, iDispatch);
                int n3 = SymbolicPropagator.this.reuseOrCreateException();
                if (iInvokeInstruction.getPushedWordSize() > 0) {
                    int n4 = SymbolicPropagator.this.reuseOrCreateDef();
                    SymbolicPropagator.this.workingState.push(n4);
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.InvokeInstruction(n4, nArray, n3, callSiteReference));
                } else {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.InvokeInstruction(nArray, n3, callSiteReference));
                }
                this.doIndirectWrites(SSABuilder.this.bytecodeIndirections.indirectlyWrittenLocals(SymbolicPropagator.this.getCurrentInstructionIndex()), -1);
            }

            public void visitLocalLoad(ILoadInstruction iLoadInstruction) {
                if (iLoadInstruction.isAddressOf()) {
                    int n = SymbolicPropagator.this.reuseOrCreateDef();
                    int n2 = SymbolicPropagator.this.workingState.getLocal(iLoadInstruction.getVarIndex());
                    if (n2 == -1) {
                        this.doIndirectWrites(new int[]{iLoadInstruction.getVarIndex()}, -1);
                        n2 = SymbolicPropagator.this.workingState.getLocal(iLoadInstruction.getVarIndex());
                    }
                    TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, iLoadInstruction.getType());
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.AddressOfInstruction(n, n2, typeReference));
                    SymbolicPropagator.this.workingState.push(n);
                } else {
                    super.visitLocalLoad(iLoadInstruction);
                }
            }

            public void visitLocalStore(IStoreInstruction iStoreInstruction) {
                if (SymbolicPropagator.this.localMap != null) {
                    SymbolicPropagator.this.localMap.startRange(SymbolicPropagator.this.getCurrentInstructionIndex(), iStoreInstruction.getVarIndex(), SymbolicPropagator.this.workingState.peek());
                }
                super.visitLocalStore(iStoreInstruction);
            }

            public void visitMonitor(MonitorInstruction monitorInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.MonitorInstruction(n, monitorInstruction.isEnter()));
            }

            public void visitNew(NewInstruction newInstruction) {
                int n = SymbolicPropagator.this.reuseOrCreateDef();
                TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, newInstruction.getType());
                NewSiteReference newSiteReference = NewSiteReference.make(SymbolicPropagator.this.getCurrentProgramCounter(), typeReference);
                if (typeReference.isArrayType()) {
                    int[] nArray = new int[newInstruction.getArrayBoundsCount()];
                    int n2 = 0;
                    while (n2 < newInstruction.getArrayBoundsCount()) {
                        nArray[newInstruction.getArrayBoundsCount() - 1 - n2] = SymbolicPropagator.this.workingState.pop();
                        ++n2;
                    }
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.NewInstruction(n, newSiteReference, nArray));
                } else {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.NewInstruction(n, newSiteReference));
                    this.popN((IInstruction)newInstruction);
                }
                SymbolicPropagator.this.workingState.push(n);
            }

            public void visitPut(IPutInstruction iPutInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                if (iPutInstruction.isStatic()) {
                    FieldReference fieldReference = FieldReference.findOrCreate(SymbolicPropagator.this.loader, iPutInstruction.getClassType(), iPutInstruction.getFieldName(), iPutInstruction.getFieldType());
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.PutInstruction(n, fieldReference));
                } else {
                    int n2 = SymbolicPropagator.this.workingState.pop();
                    FieldReference fieldReference = FieldReference.findOrCreate(SymbolicPropagator.this.loader, iPutInstruction.getClassType(), iPutInstruction.getFieldName(), iPutInstruction.getFieldType());
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.PutInstruction(n2, n, fieldReference));
                }
            }

            public void visitReturn(ReturnInstruction returnInstruction) {
                if (returnInstruction.getPoppedCount() == 1) {
                    int n = SymbolicPropagator.this.workingState.pop();
                    TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, returnInstruction.getType());
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ReturnInstruction(n, typeReference.isPrimitiveType()));
                } else {
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ReturnInstruction());
                }
            }

            public void visitShift(IShiftInstruction iShiftInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.workingState.pop();
                int n3 = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(n3);
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.BinaryOpInstruction((IBinaryOpInstruction.IOperator)iShiftInstruction.getOperator(), false, iShiftInstruction.isUnsigned(), n3, n2, n, true));
            }

            public void visitSwitch(SwitchInstruction switchInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.SwitchInstruction(n, switchInstruction.getDefaultLabel(), switchInstruction.getCasesAndLabels()));
            }

            private int findRethrowException() {
                int n = SymbolicPropagator.this.getCurrentInstructionIndex();
                SSACFG.BasicBlock basicBlock = SymbolicPropagator.this.cfg.getBlockForInstruction(n);
                if (basicBlock.isCatchBlock()) {
                    SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)basicBlock;
                    SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction = exceptionHandlerBasicBlock.getCatchInstruction();
                    return sSAGetCaughtExceptionInstruction.getDef();
                }
                if (this.dom == null) {
                    this.dom = Dominators.make(SymbolicPropagator.this.cfg, SymbolicPropagator.this.cfg.entry());
                }
                ISSABasicBlock iSSABasicBlock = basicBlock;
                while (iSSABasicBlock != null) {
                    if (iSSABasicBlock.isCatchBlock()) {
                        SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)iSSABasicBlock;
                        SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction = exceptionHandlerBasicBlock.getCatchInstruction();
                        return sSAGetCaughtExceptionInstruction.getDef();
                    }
                    iSSABasicBlock = this.dom.getIdom(iSSABasicBlock);
                }
                return -1;
            }

            public void visitThrow(ThrowInstruction throwInstruction) {
                if (throwInstruction.isRethrow()) {
                    SymbolicPropagator.this.workingState.clearStack();
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ThrowInstruction(this.findRethrowException()));
                } else {
                    int n = SymbolicPropagator.this.workingState.pop();
                    SymbolicPropagator.this.workingState.clearStack();
                    SymbolicPropagator.this.workingState.push(n);
                    SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.ThrowInstruction(n));
                }
            }

            public void visitUnaryOp(IUnaryOpInstruction iUnaryOpInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.push(n2);
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.UnaryOpInstruction(iUnaryOpInstruction.getOperator(), n2, n));
            }

            private void doIndirectReads(int[] nArray) {
                int n = 0;
                while (n < nArray.length) {
                    SSABuilder.this.ssaIndirections.setUse(SymbolicPropagator.this.getCurrentInstructionIndex(), new ShrikeIndirectionData.ShrikeLocalName(nArray[n]), SymbolicPropagator.this.workingState.getLocal(nArray[n]));
                    ++n;
                }
            }

            public void visitLoadIndirect(ILoadIndirectInstruction iLoadIndirectInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.reuseOrCreateDef();
                this.doIndirectReads(SSABuilder.this.bytecodeIndirections.indirectlyReadLocals(SymbolicPropagator.this.getCurrentInstructionIndex()));
                TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, iLoadIndirectInstruction.getPushedType(null));
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.LoadIndirectInstruction(n2, typeReference, n));
                SymbolicPropagator.this.workingState.push(n2);
            }

            private void doIndirectWrites(int[] nArray, int n) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    ShrikeIndirectionData.ShrikeLocalName shrikeLocalName = new ShrikeIndirectionData.ShrikeLocalName(nArray[n2]);
                    int n3 = SymbolicPropagator.this.getCurrentInstructionIndex();
                    if (SSABuilder.this.ssaIndirections.getDef(n3, shrikeLocalName) == -1) {
                        SSABuilder.this.ssaIndirections.setDef(n3, shrikeLocalName, n == -1 ? SymbolicPropagator.this.symbolTable.newSymbol() : n);
                    }
                    SymbolicPropagator.this.workingState.setLocal(nArray[n2], SSABuilder.this.ssaIndirections.getDef(n3, shrikeLocalName));
                    ++n2;
                }
            }

            public void visitStoreIndirect(IStoreIndirectInstruction iStoreIndirectInstruction) {
                int n = SymbolicPropagator.this.workingState.pop();
                int n2 = SymbolicPropagator.this.workingState.pop();
                this.doIndirectWrites(SSABuilder.this.bytecodeIndirections.indirectlyWrittenLocals(SymbolicPropagator.this.getCurrentInstructionIndex()), n);
                TypeReference typeReference = ShrikeUtil.makeTypeReference(SymbolicPropagator.this.loader, iStoreIndirectInstruction.getType());
                SymbolicPropagator.this.emitInstruction(SSABuilder.this.insts.StoreIndirectInstruction(n2, n, typeReference));
            }
        }
    }
}

