/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSACheckCastInstruction
extends SSAInstruction {
    private final int result;
    private final int val;
    private final TypeReference[] declaredResultTypes;

    protected SSACheckCastInstruction(int n, int n2, TypeReference[] typeReferenceArray) {
        this.result = n;
        this.val = n2;
        this.declaredResultTypes = typeReferenceArray;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        if (nArray != null && nArray.length == 0) {
            throw new IllegalArgumentException("(defs != null) and (defs.length == 0)");
        }
        if (nArray2 != null && nArray2.length == 0) {
            throw new IllegalArgumentException("(uses != null) and (uses.length == 0)");
        }
        return sSAInstructionFactory.CheckCastInstruction(nArray == null ? this.result : nArray[0], nArray2 == null ? this.val : nArray2[0], this.declaredResultTypes);
    }

    public String toString(SymbolTable symbolTable) {
        String string = String.valueOf(this.getValueString(symbolTable, this.result)) + " = checkcast";
        TypeReference[] typeReferenceArray = this.declaredResultTypes;
        int n = this.declaredResultTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference typeReference = typeReferenceArray[n2];
            string = String.valueOf(string) + " " + typeReference;
            ++n2;
        }
        return String.valueOf(string) + this.getValueString(symbolTable, this.val);
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitCheckCast(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int n) {
        assert (n == 0);
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int n) {
        assert (n == 0);
        return this.val;
    }

    @Deprecated
    public TypeReference getDeclaredResultType() {
        assert (this.declaredResultTypes.length == 1);
        return this.declaredResultTypes[0];
    }

    public TypeReference[] getDeclaredResultTypes() {
        return this.declaredResultTypes;
    }

    public int getResult() {
        return this.result;
    }

    public int getVal() {
        return this.val;
    }

    public int hashCode() {
        return this.result * 7529 + this.val;
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isFallThrough() {
        return true;
    }

    public String toString() {
        String string = super.toString();
        TypeReference[] typeReferenceArray = this.declaredResultTypes;
        int n = this.declaredResultTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference typeReference = typeReferenceArray[n2];
            string = String.valueOf(string) + " " + typeReference;
            ++n2;
        }
        return string;
    }
}

