/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAGetCaughtExceptionInstruction
extends SSAInstruction {
    private final int exceptionValueNumber;
    private final int bbNumber;

    public SSAGetCaughtExceptionInstruction(int n, int n2) {
        this.exceptionValueNumber = n2;
        this.bbNumber = n;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        assert (nArray == null || nArray.length == 1);
        return sSAInstructionFactory.GetCaughtExceptionInstruction(this.bbNumber, nArray == null ? this.exceptionValueNumber : nArray[0]);
    }

    public String toString(SymbolTable symbolTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getValueString(symbolTable, this.exceptionValueNumber)).append(" = getCaughtException ");
        return stringBuffer.toString();
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitGetCaughtException(this);
    }

    public int getException() {
        return this.exceptionValueNumber;
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.exceptionValueNumber;
    }

    public int getDef(int n) {
        assert (n == 0);
        return this.exceptionValueNumber;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getBasicBlockNumber() {
        return this.bbNumber;
    }

    public int hashCode() {
        return 2243 * this.exceptionValueNumber;
    }

    public boolean isFallThrough() {
        return true;
    }
}

