/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public class SSAInstanceofInstruction
extends SSAInstruction {
    private final int result;
    private final int ref;
    private final TypeReference checkedType;

    public SSAInstanceofInstruction(int n, int n2, TypeReference typeReference) {
        this.result = n;
        this.ref = n2;
        this.checkedType = typeReference;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        if (nArray != null && nArray.length == 0) {
            throw new IllegalArgumentException("defs.length == 0");
        }
        if (nArray2 != null && nArray2.length == 0) {
            throw new IllegalArgumentException("uses.length == 0");
        }
        return sSAInstructionFactory.InstanceofInstruction(nArray == null || nArray.length == 0 ? this.result : nArray[0], nArray2 == null ? this.ref : nArray2[0], this.checkedType);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = instanceof " + this.getValueString(symbolTable, this.ref) + " " + this.checkedType;
    }

    public void visit(SSAInstruction.IVisitor iVisitor) throws NullPointerException {
        iVisitor.visitInstanceof(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int n) {
        assert (n == 0);
        return this.result;
    }

    public TypeReference getCheckedType() {
        return this.checkedType;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int n) {
        assert (n == 0);
        return this.ref;
    }

    public int hashCode() {
        return this.ref * 677 ^ this.result * 3803;
    }

    public boolean isFallThrough() {
        return true;
    }

    public int getRef() {
        return this.ref;
    }
}

