/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;

public abstract class SSANewInstruction
extends SSAInstruction {
    private final int result;
    private final NewSiteReference site;
    private final int[] params;

    protected SSANewInstruction(int n, NewSiteReference newSiteReference) throws IllegalArgumentException {
        if (newSiteReference == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        assert (!newSiteReference.getDeclaredType().isArrayType() || newSiteReference.getDeclaredType().getClassLoader().getLanguage() != ClassLoaderReference.Java);
        this.result = n;
        this.site = newSiteReference;
        this.params = null;
    }

    protected SSANewInstruction(int n, NewSiteReference newSiteReference, int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("params is null");
        }
        if (newSiteReference == null) {
            throw new IllegalArgumentException("site is null");
        }
        assert (newSiteReference.getDeclaredType().isArrayType() || newSiteReference.getDeclaredType().getClassLoader().getLanguage() != ClassLoaderReference.Java);
        this.result = n;
        this.site = newSiteReference;
        this.params = new int[nArray.length];
        System.arraycopy(nArray, 0, this.params, 0, nArray.length);
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        if (this.params == null) {
            return sSAInstructionFactory.NewInstruction(nArray == null ? this.result : nArray[0], this.site);
        }
        return sSAInstructionFactory.NewInstruction(nArray == null ? this.result : nArray[0], this.site, nArray2 == null ? this.params : nArray2);
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = new " + this.site.getDeclaredType() + "@" + this.site.getProgramCounter() + (this.params == null ? "" : this.array2String(this.params, symbolTable));
    }

    private String array2String(int[] nArray, SymbolTable symbolTable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(this.getValueString(symbolTable, nArray[n]));
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitNew(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int n) {
        assert (n == 0);
        return this.result;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public TypeReference getConcreteType() {
        return this.site.getDeclaredType();
    }

    public NewSiteReference getNewSite() {
        return this.site;
    }

    public int hashCode() {
        return this.result * 7529 + this.site.getDeclaredType().hashCode();
    }

    public int getNumberOfUses() {
        return this.params == null ? 0 : this.params.length;
    }

    public int getUse(int n) {
        assert (this.params != null) : "expected params but got null";
        assert (this.params.length > n) : "found too few parameters";
        return this.params[n];
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isFallThrough() {
        return true;
    }
}

