/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAReturnInstruction
extends SSAInstruction {
    private final int result;
    private final boolean isPrimitive;

    public SSAReturnInstruction(int n, boolean bl) {
        this.result = n;
        this.isPrimitive = bl;
    }

    public SSAReturnInstruction() {
        this.result = -1;
        this.isPrimitive = false;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        if (this.result == -1) {
            return sSAInstructionFactory.ReturnInstruction();
        }
        if (nArray2 != null && nArray2.length != 1) {
            throw new IllegalArgumentException("invalid uses.  must have exactly one use.");
        }
        return sSAInstructionFactory.ReturnInstruction(nArray2 == null ? this.result : nArray2[0], this.isPrimitive);
    }

    public String toString(SymbolTable symbolTable) {
        if (this.result == -1) {
            return "return";
        }
        return "return " + this.getValueString(symbolTable, this.result);
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitReturn(this);
    }

    public int getNumberOfUses() {
        return this.result == -1 ? 0 : 1;
    }

    public int getUse(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("illegal j: " + n);
        }
        return this.result;
    }

    public boolean returnsPrimitiveType() {
        return this.isPrimitive;
    }

    public int getResult() {
        return this.result;
    }

    public boolean returnsVoid() {
        return this.result == -1;
    }

    public int hashCode() {
        return this.result * 8933;
    }

    public boolean isFallThrough() {
        return false;
    }
}

