/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.PhiValue;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashMap;

public class SymbolTable
implements Cloneable {
    private static final int MAX_VALUE_NUMBER = 0x1FFFFFFF;
    private final int[] parameters;
    private HashMap<ConstantValue, Integer> constants = HashMapFactory.make(10);
    private Value[] values = new Value[5];
    private int nextFreeValueNumber = 1;
    private Object[] defaultValues;

    public SymbolTable(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal numberOfParameters: " + n);
        }
        this.parameters = new int[n];
        int n2 = 0;
        while (n2 < this.parameters.length) {
            this.parameters[n2] = this.getNewValueNumber();
            ++n2;
        }
    }

    public int newSymbol() {
        return this.getNewValueNumber();
    }

    int findOrCreateConstant(Object object) {
        ConstantValue constantValue = new ConstantValue(object);
        Integer n = this.constants.get(constantValue);
        if (n == null) {
            int n2 = this.getNewValueNumber();
            n = n2;
            this.constants.put(constantValue, n);
            assert (n2 < this.nextFreeValueNumber);
            this.values[n2] = constantValue;
        } else assert (this.values[n] instanceof ConstantValue);
        return n;
    }

    public void setConstantValue(int n, ConstantValue constantValue) {
        try {
            assert (n < this.nextFreeValueNumber);
            this.values[n] = constantValue;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid vn: " + n);
        }
    }

    public void setDefaultValue(int n, Object object) {
        assert (n < this.nextFreeValueNumber);
        if (this.defaultValues == null) {
            this.defaultValues = new Object[n * 2 + 1];
        }
        if (this.defaultValues.length <= n) {
            Object[] objectArray = this.defaultValues;
            this.defaultValues = new Object[n * 2 + 1];
            System.arraycopy(objectArray, 0, this.defaultValues, 0, objectArray.length);
        }
        this.defaultValues[n] = object;
    }

    public int getDefaultValue(int n) {
        return this.findOrCreateConstant(this.defaultValues[n]);
    }

    public int getNullConstant() {
        return this.findOrCreateConstant(null);
    }

    public int getConstant(boolean bl) {
        return this.findOrCreateConstant(bl);
    }

    public int getConstant(int n) {
        return this.findOrCreateConstant(n);
    }

    public int getConstant(long l) {
        return this.findOrCreateConstant(l);
    }

    public int getConstant(float f) {
        return this.findOrCreateConstant(new Float(f));
    }

    public int getConstant(double d) {
        return this.findOrCreateConstant(new Double(d));
    }

    public int getConstant(String string) {
        return this.findOrCreateConstant(string);
    }

    public int getParameter(int n) throws IllegalArgumentException {
        try {
            return this.parameters[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid i: " + n);
        }
    }

    private void expandForNewValueNumber(int n) {
        if (n >= this.values.length) {
            Value[] valueArray = this.values;
            this.values = new Value[2 * n];
            System.arraycopy(valueArray, 0, this.values, 0, valueArray.length);
        }
    }

    private int getNewValueNumber() {
        int n = this.nextFreeValueNumber++;
        this.expandForNewValueNumber(n);
        return n;
    }

    public void ensureSymbol(int n) {
        if (n < 0 || n > 0x1FFFFFFF) {
            throw new IllegalArgumentException("Illegal i: " + n);
        }
        try {
            if (n != -1 && (n >= this.values.length || this.values[n] == null)) {
                if (this.nextFreeValueNumber <= n) {
                    this.nextFreeValueNumber = n + 1;
                }
                this.expandForNewValueNumber(n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid i: " + n);
        }
    }

    public String getValueString(int n) {
        if (n < 0 || n > this.getMaxValueNumber() || this.values[n] == null || this.values[n] instanceof PhiValue) {
            return "v" + n;
        }
        return "v" + n + ":" + this.values[n].toString();
    }

    public boolean isConstant(int n) {
        try {
            return n < this.values.length && this.values[n] instanceof ConstantValue;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isZero(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).isZeroConstant();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isOne(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).isOneConstant();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isTrue(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).isTrueConstant();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isZeroOrFalse(int n) {
        return this.isZero(n) || this.isFalse(n);
    }

    public boolean isOneOrTrue(int n) {
        return this.isOne(n) || this.isTrue(n);
    }

    public boolean isFalse(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).isFalseConstant();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isBooleanOrZeroOneConstant(int n) {
        return this.isBooleanConstant(n) || this.isZero(n) || this.isOne(n);
    }

    public boolean isBooleanConstant(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).getValue() instanceof Boolean;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isIntegerConstant(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).getValue() instanceof Integer;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isLongConstant(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).getValue() instanceof Long;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isFloatConstant(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).getValue() instanceof Float;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isDoubleConstant(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).getValue() instanceof Double;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isNumberConstant(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).getValue() instanceof Number;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isStringConstant(int n) {
        try {
            return this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).getValue() instanceof String;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public boolean isNullConstant(int n) {
        try {
            return this.values.length > n && this.values[n] instanceof ConstantValue && ((ConstantValue)this.values[n]).getValue() == null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid v: " + n);
        }
    }

    public int newPhi(int[] nArray) throws IllegalArgumentException {
        if (nArray == null) {
            throw new IllegalArgumentException("rhs is null");
        }
        int n = this.getNewValueNumber();
        SSAPhiInstruction sSAPhiInstruction = new SSAPhiInstruction(n, (int[])nArray.clone());
        assert (n < this.nextFreeValueNumber);
        this.values[n] = new PhiValue(sSAPhiInstruction);
        return n;
    }

    public PhiValue getPhiValue(int n) {
        try {
            return (PhiValue)this.values[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid valueNumber: " + n);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("invalid valueNumber: " + n);
        }
    }

    public int getMaxValueNumber() {
        return this.nextFreeValueNumber - 1;
    }

    public int[] getParameterValueNumbers() {
        return this.parameters;
    }

    public int getNumberOfParameters() {
        return this.parameters.length;
    }

    public String getStringValue(int n) throws IllegalArgumentException {
        if (!this.isStringConstant(n)) {
            throw new IllegalArgumentException("not a string constant: value number " + n);
        }
        return (String)((ConstantValue)this.values[n]).getValue();
    }

    public float getFloatValue(int n) throws IllegalArgumentException {
        if (!this.isNumberConstant(n)) {
            throw new IllegalArgumentException("value number " + n + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[n]).getValue()).floatValue();
    }

    public double getDoubleValue(int n) throws IllegalArgumentException {
        if (!this.isNumberConstant(n)) {
            throw new IllegalArgumentException("value number " + n + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[n]).getValue()).doubleValue();
    }

    public int getIntValue(int n) throws IllegalArgumentException {
        if (!this.isNumberConstant(n)) {
            throw new IllegalArgumentException("value number " + n + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[n]).getValue()).intValue();
    }

    public long getLongValue(int n) throws IllegalArgumentException {
        if (!this.isNumberConstant(n)) {
            throw new IllegalArgumentException("value number " + n + " is not a numeric constant.");
        }
        return ((Number)((ConstantValue)this.values[n]).getValue()).longValue();
    }

    public Object getConstantValue(int n) throws IllegalArgumentException {
        if (!this.isConstant(n)) {
            throw new IllegalArgumentException("value number " + n + " is not a constant.");
        }
        Object object = ((ConstantValue)this.values[n]).getValue();
        if (object == null) {
            return null;
        }
        return object;
    }

    public Value getValue(int n) {
        if (n < 1 || n >= this.values.length) {
            throw new IllegalArgumentException("Invalid value number " + n);
        }
        return this.values[n];
    }

    public boolean isParameter(int n) {
        return n <= this.getNumberOfParameters();
    }

    public SymbolTable copy() {
        try {
            SymbolTable symbolTable = (SymbolTable)this.clone();
            symbolTable.values = (Value[])this.values.clone();
            if (this.defaultValues != null) {
                symbolTable.defaultValues = (Object[])this.defaultValues.clone();
            }
            symbolTable.constants = HashMapFactory.make(this.constants);
            return symbolTable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assertions.UNREACHABLE();
            return null;
        }
    }
}

