/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa.analysis;

import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixpoint.BooleanVariable;
import com.ibm.wala.fixpoint.UnaryOr;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DeadAssignmentElimination {
    private static final boolean DEBUG = false;

    public static void perform(IR iR) {
        if (iR == null) {
            throw new IllegalArgumentException("ir is null");
        }
        DefUse defUse = new DefUse(iR);
        DeadValueSystem deadValueSystem = new DeadValueSystem(iR, defUse);
        try {
            deadValueSystem.solve(null);
        }
        catch (CancelException cancelException) {
            throw new CancelRuntimeException(cancelException);
        }
        DeadAssignmentElimination.doTransformation(iR, deadValueSystem);
    }

    private static void doTransformation(IR iR, DeadValueSystem deadValueSystem) {
        SSACFG sSACFG = iR.getControlFlowGraph();
        for (SSACFG.BasicBlock basicBlock : sSACFG) {
            if (!basicBlock.hasPhi()) continue;
            HashSet<SSAPhiInstruction> hashSet = HashSetFactory.make(5);
            Iterator<SSAPhiInstruction> iterator = basicBlock.iteratePhis();
            while (iterator.hasNext()) {
                int n;
                SSAPhiInstruction sSAPhiInstruction = iterator.next();
                if (sSAPhiInstruction == null || !deadValueSystem.isDead(n = sSAPhiInstruction.getDef())) continue;
                hashSet.add(sSAPhiInstruction);
            }
            basicBlock.removePhis(hashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeadValueSystem
    extends DefaultFixedPointSolver<BooleanVariable> {
        private final Map<Integer, BooleanVariable> vars = HashMapFactory.make();
        private final HashSet<Integer> trivialDead = HashSetFactory.make();

        DeadValueSystem(IR iR, DefUse defUse) {
            SSAInstruction sSAInstruction;
            Object object;
            Iterator<Object> iterator = iR.iteratePhis();
            while (iterator.hasNext()) {
                SSAPhiInstruction object2 = (SSAPhiInstruction)iterator.next();
                if (object2 == null) continue;
                int n = object2.getDef();
                if (defUse.getNumberOfUses(n) == 0) {
                    this.trivialDead.add(new Integer(n));
                    continue;
                }
                boolean booleanVariable = true;
                object = defUse.getUses(n);
                while (object.hasNext()) {
                    sSAInstruction = object.next();
                    if (sSAInstruction instanceof SSAPhiInstruction) continue;
                    booleanVariable = false;
                    break;
                }
                if (!booleanVariable) continue;
                object = new BooleanVariable(false);
                this.vars.put(new Integer(n), (BooleanVariable)object);
            }
            for (Map.Entry entry : this.vars.entrySet()) {
                Integer n = (Integer)entry.getKey();
                BooleanVariable booleanVariable = (BooleanVariable)entry.getValue();
                object = defUse.getUses(n);
                while (object.hasNext()) {
                    sSAInstruction = (SSAPhiInstruction)object.next();
                    Integer n2 = new Integer(((SSAPhiInstruction)sSAInstruction).getDef());
                    if (this.trivialDead.contains(n2)) continue;
                    if (!this.vars.keySet().contains(n2)) {
                        booleanVariable.set(true);
                        continue;
                    }
                    BooleanVariable booleanVariable2 = this.vars.get(n2);
                    this.newStatement(booleanVariable, UnaryOr.instance(), booleanVariable2, true, false);
                }
            }
        }

        @Override
        protected void initializeVariables() {
        }

        @Override
        protected void initializeWorkList() {
            this.addAllStatementsToWorkList();
        }

        private boolean isDead(int n) {
            Integer n2 = n;
            if (this.trivialDead.contains(n2)) {
                return true;
            }
            BooleanVariable booleanVariable = this.vars.get(n2);
            if (booleanVariable == null) {
                return false;
            }
            return !booleanVariable.getValue();
        }
    }
}

