/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa.analysis;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedControlFlowGraph
implements ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> {
    private static final int ENTRY_INDEX = -1;
    private static final int EXIT_INDEX = -2;
    private final IR ir;
    private final SimpleVector<IExplodedBasicBlock> normalNodes = new SimpleVector();
    private final Collection<IExplodedBasicBlock> allNodes = HashSetFactory.make();
    private final IExplodedBasicBlock entry;
    private final IExplodedBasicBlock exit;

    private ExplodedControlFlowGraph(IR iR) {
        assert (iR != null);
        this.ir = iR;
        this.entry = new ExplodedBasicBlock(-1, null);
        this.exit = new ExplodedBasicBlock(-2, null);
        this.createNodes();
    }

    private void createNodes() {
        this.allNodes.add(this.entry);
        this.allNodes.add(this.exit);
        for (ISSABasicBlock iSSABasicBlock : this.ir.getControlFlowGraph()) {
            int n = iSSABasicBlock.getFirstInstructionIndex();
            while (n <= iSSABasicBlock.getLastInstructionIndex()) {
                ExplodedBasicBlock explodedBasicBlock = new ExplodedBasicBlock(n, iSSABasicBlock);
                this.normalNodes.set(n, explodedBasicBlock);
                this.allNodes.add(explodedBasicBlock);
                ++n;
            }
        }
    }

    public static ExplodedControlFlowGraph make(IR iR) {
        if (iR == null) {
            throw new IllegalArgumentException("ir == null");
        }
        return new ExplodedControlFlowGraph(iR);
    }

    @Override
    public IExplodedBasicBlock entry() {
        return this.entry;
    }

    @Override
    public IExplodedBasicBlock exit() {
        return this.exit;
    }

    @Override
    public IExplodedBasicBlock getBlockForInstruction(int n) {
        return this.normalNodes.get(n);
    }

    @Override
    public BitVector getCatchBlocks() {
        BitVector bitVector = this.ir.getControlFlowGraph().getCatchBlocks();
        BitVector bitVector2 = new BitVector();
        int n = 0;
        while (n <= bitVector.max()) {
            if (bitVector.get(n)) {
                bitVector2.set(n + 1);
            }
            ++n;
        }
        return bitVector2;
    }

    @Override
    public Collection<IExplodedBasicBlock> getExceptionalPredecessors(IExplodedBasicBlock iExplodedBasicBlock) {
        ExplodedBasicBlock explodedBasicBlock = (ExplodedBasicBlock)iExplodedBasicBlock;
        assert (explodedBasicBlock != null);
        if (explodedBasicBlock.equals(this.entry)) {
            return Collections.emptySet();
        }
        if (explodedBasicBlock.isExitBlock() || explodedBasicBlock.instructionIndex == explodedBasicBlock.original.getFirstInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> arrayList = new ArrayList<IExplodedBasicBlock>();
            for (ISSABasicBlock iSSABasicBlock : this.ir.getControlFlowGraph().getExceptionalPredecessors(explodedBasicBlock.original)) {
                assert (this.normalNodes.get(iSSABasicBlock.getLastInstructionIndex()) != null);
                arrayList.add(this.normalNodes.get(iSSABasicBlock.getLastInstructionIndex()));
            }
            return arrayList;
        }
        return Collections.emptySet();
    }

    @Override
    public List<IExplodedBasicBlock> getExceptionalSuccessors(IExplodedBasicBlock iExplodedBasicBlock) {
        ExplodedBasicBlock explodedBasicBlock = (ExplodedBasicBlock)iExplodedBasicBlock;
        assert (explodedBasicBlock != null);
        if (explodedBasicBlock.equals(this.exit)) {
            return Collections.emptyList();
        }
        if (explodedBasicBlock.isEntryBlock() || explodedBasicBlock.instructionIndex == explodedBasicBlock.original.getLastInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> arrayList = new ArrayList<IExplodedBasicBlock>();
            for (ISSABasicBlock iSSABasicBlock : this.ir.getControlFlowGraph().getExceptionalSuccessors(explodedBasicBlock.original)) {
                if (iSSABasicBlock.equals(this.ir.getControlFlowGraph().exit())) {
                    arrayList.add(this.exit());
                    continue;
                }
                assert (this.normalNodes.get(iSSABasicBlock.getFirstInstructionIndex()) != null);
                arrayList.add(this.normalNodes.get(iSSABasicBlock.getFirstInstructionIndex()));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public SSAInstruction[] getInstructions() {
        return this.ir.getInstructions();
    }

    @Override
    public IMethod getMethod() throws UnimplementedError {
        return this.ir.getMethod();
    }

    @Override
    public Collection<IExplodedBasicBlock> getNormalPredecessors(IExplodedBasicBlock iExplodedBasicBlock) {
        ExplodedBasicBlock explodedBasicBlock = (ExplodedBasicBlock)iExplodedBasicBlock;
        assert (explodedBasicBlock != null);
        if (explodedBasicBlock.equals(this.entry)) {
            return Collections.emptySet();
        }
        if (explodedBasicBlock.isExitBlock() || explodedBasicBlock.instructionIndex == explodedBasicBlock.original.getFirstInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> arrayList = new ArrayList<IExplodedBasicBlock>();
            for (ISSABasicBlock iSSABasicBlock : this.ir.getControlFlowGraph().getNormalPredecessors(explodedBasicBlock.original)) {
                if (iSSABasicBlock.equals(this.ir.getControlFlowGraph().entry())) {
                    if (iSSABasicBlock.getLastInstructionIndex() >= 0) {
                        assert (this.normalNodes.get(iSSABasicBlock.getLastInstructionIndex()) != null);
                        arrayList.add(this.normalNodes.get(iSSABasicBlock.getLastInstructionIndex()));
                        continue;
                    }
                    arrayList.add(this.entry());
                    continue;
                }
                assert (this.normalNodes.get(iSSABasicBlock.getLastInstructionIndex()) != null);
                arrayList.add(this.normalNodes.get(iSSABasicBlock.getLastInstructionIndex()));
            }
            return arrayList;
        }
        assert (this.normalNodes.get(explodedBasicBlock.instructionIndex - 1) != null);
        return Collections.singleton(this.normalNodes.get(explodedBasicBlock.instructionIndex - 1));
    }

    @Override
    public Collection<IExplodedBasicBlock> getNormalSuccessors(IExplodedBasicBlock iExplodedBasicBlock) {
        ExplodedBasicBlock explodedBasicBlock = (ExplodedBasicBlock)iExplodedBasicBlock;
        assert (explodedBasicBlock != null);
        if (explodedBasicBlock.equals(this.exit)) {
            return Collections.emptySet();
        }
        if (explodedBasicBlock.isEntryBlock()) {
            return Collections.singleton(this.normalNodes.get(0));
        }
        if (explodedBasicBlock.instructionIndex == explodedBasicBlock.original.getLastInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> arrayList = new ArrayList<IExplodedBasicBlock>();
            for (ISSABasicBlock iSSABasicBlock : this.ir.getControlFlowGraph().getNormalSuccessors(explodedBasicBlock.original)) {
                if (iSSABasicBlock.equals(this.ir.getControlFlowGraph().exit())) {
                    arrayList.add(this.exit());
                    continue;
                }
                assert (this.normalNodes.get(iSSABasicBlock.getFirstInstructionIndex()) != null);
                arrayList.add(this.normalNodes.get(iSSABasicBlock.getFirstInstructionIndex()));
            }
            return arrayList;
        }
        assert (this.normalNodes.get(explodedBasicBlock.instructionIndex + 1) != null);
        return Collections.singleton(this.normalNodes.get(explodedBasicBlock.instructionIndex + 1));
    }

    @Override
    public int getProgramCounter(int n) throws UnimplementedError {
        return this.ir.getControlFlowGraph().getProgramCounter(n);
    }

    @Override
    public void removeNodeAndEdges(IExplodedBasicBlock iExplodedBasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNode(IExplodedBasicBlock iExplodedBasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(IExplodedBasicBlock iExplodedBasicBlock) {
        return this.allNodes.contains(iExplodedBasicBlock);
    }

    @Override
    public int getNumberOfNodes() {
        return this.allNodes.size();
    }

    @Override
    public Iterator<IExplodedBasicBlock> iterator() {
        return this.allNodes.iterator();
    }

    @Override
    public void removeNode(IExplodedBasicBlock iExplodedBasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEdge(IExplodedBasicBlock iExplodedBasicBlock, IExplodedBasicBlock iExplodedBasicBlock2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPredNodeCount(IExplodedBasicBlock iExplodedBasicBlock) throws IllegalArgumentException {
        ExplodedBasicBlock explodedBasicBlock = (ExplodedBasicBlock)iExplodedBasicBlock;
        if (explodedBasicBlock == null) {
            throw new IllegalArgumentException("eb == null");
        }
        if (explodedBasicBlock.isEntryBlock()) {
            return 0;
        }
        if (explodedBasicBlock.isExitBlock()) {
            return this.ir.getControlFlowGraph().getPredNodeCount(this.ir.getControlFlowGraph().exit());
        }
        if (explodedBasicBlock.instructionIndex == explodedBasicBlock.original.getFirstInstructionIndex()) {
            if (explodedBasicBlock.original.isEntryBlock()) {
                return 1;
            }
            return this.ir.getControlFlowGraph().getPredNodeCount(explodedBasicBlock.original);
        }
        return 1;
    }

    @Override
    public Iterator<IExplodedBasicBlock> getPredNodes(IExplodedBasicBlock iExplodedBasicBlock) throws IllegalArgumentException {
        ISSABasicBlock iSSABasicBlock;
        ExplodedBasicBlock explodedBasicBlock = (ExplodedBasicBlock)iExplodedBasicBlock;
        if (explodedBasicBlock == null) {
            throw new IllegalArgumentException("eb == null");
        }
        if (explodedBasicBlock.isEntryBlock()) {
            return EmptyIterator.instance();
        }
        ISSABasicBlock iSSABasicBlock2 = iSSABasicBlock = explodedBasicBlock.isExitBlock() ? this.ir.getControlFlowGraph().exit() : explodedBasicBlock.original;
        if (explodedBasicBlock.isExitBlock() || explodedBasicBlock.instructionIndex == explodedBasicBlock.original.getFirstInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> arrayList = new ArrayList<IExplodedBasicBlock>();
            if (explodedBasicBlock.original != null && explodedBasicBlock.original.isEntryBlock()) {
                arrayList.add(this.entry);
            }
            Iterator<ISSABasicBlock> iterator = this.ir.getControlFlowGraph().getPredNodes(iSSABasicBlock);
            while (iterator.hasNext()) {
                ISSABasicBlock iSSABasicBlock3 = iterator.next();
                if (iSSABasicBlock3.isEntryBlock()) {
                    if (iSSABasicBlock3.getLastInstructionIndex() >= 0) {
                        arrayList.add(this.normalNodes.get(iSSABasicBlock3.getLastInstructionIndex()));
                        continue;
                    }
                    arrayList.add(this.entry);
                    continue;
                }
                assert (this.normalNodes.get(iSSABasicBlock3.getLastInstructionIndex()) != null);
                arrayList.add(this.normalNodes.get(iSSABasicBlock3.getLastInstructionIndex()));
            }
            return arrayList.iterator();
        }
        assert (this.normalNodes.get(explodedBasicBlock.instructionIndex - 1) != null);
        return NonNullSingletonIterator.make(this.normalNodes.get(explodedBasicBlock.instructionIndex - 1));
    }

    @Override
    public int getSuccNodeCount(IExplodedBasicBlock iExplodedBasicBlock) throws UnimplementedError {
        return Iterator2Collection.toSet(this.getSuccNodes(iExplodedBasicBlock)).size();
    }

    @Override
    public Iterator<IExplodedBasicBlock> getSuccNodes(IExplodedBasicBlock iExplodedBasicBlock) {
        ExplodedBasicBlock explodedBasicBlock = (ExplodedBasicBlock)iExplodedBasicBlock;
        assert (explodedBasicBlock != null);
        if (explodedBasicBlock.isExitBlock()) {
            return EmptyIterator.instance();
        }
        if (explodedBasicBlock.isEntryBlock()) {
            IExplodedBasicBlock iExplodedBasicBlock2 = this.normalNodes.get(0);
            return iExplodedBasicBlock2 == null ? EmptyIterator.instance() : NonNullSingletonIterator.make(iExplodedBasicBlock2);
        }
        if (explodedBasicBlock.instructionIndex == explodedBasicBlock.original.getLastInstructionIndex()) {
            ArrayList<IExplodedBasicBlock> arrayList = new ArrayList<IExplodedBasicBlock>();
            Iterator<ISSABasicBlock> iterator = this.ir.getControlFlowGraph().getSuccNodes(explodedBasicBlock.original);
            while (iterator.hasNext()) {
                ISSABasicBlock iSSABasicBlock = iterator.next();
                if (iSSABasicBlock.equals(this.ir.getControlFlowGraph().exit())) {
                    arrayList.add(this.exit());
                    continue;
                }
                if (this.normalNodes.get(iSSABasicBlock.getFirstInstructionIndex()) == null) continue;
                arrayList.add(this.normalNodes.get(iSSABasicBlock.getFirstInstructionIndex()));
            }
            return arrayList.iterator();
        }
        assert (this.normalNodes.get(explodedBasicBlock.instructionIndex + 1) != null);
        return NonNullSingletonIterator.make(this.normalNodes.get(explodedBasicBlock.instructionIndex + 1));
    }

    @Override
    public boolean hasEdge(IExplodedBasicBlock iExplodedBasicBlock, IExplodedBasicBlock iExplodedBasicBlock2) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public void removeAllIncidentEdges(IExplodedBasicBlock iExplodedBasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(IExplodedBasicBlock iExplodedBasicBlock, IExplodedBasicBlock iExplodedBasicBlock2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeIncomingEdges(IExplodedBasicBlock iExplodedBasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(IExplodedBasicBlock iExplodedBasicBlock) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxNumber() {
        return this.getNumberOfNodes() - 1;
    }

    @Override
    public IExplodedBasicBlock getNode(int n) {
        if (n == 0) {
            return this.entry();
        }
        if (n == this.getNumberOfNodes() - 1) {
            return this.exit();
        }
        return this.normalNodes.get(n - 1);
    }

    @Override
    public int getNumber(IExplodedBasicBlock iExplodedBasicBlock) throws IllegalArgumentException {
        if (iExplodedBasicBlock == null) {
            throw new IllegalArgumentException("n == null");
        }
        return iExplodedBasicBlock.getNumber();
    }

    @Override
    public Iterator<IExplodedBasicBlock> iterateNodes(IntSet intSet) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(IExplodedBasicBlock iExplodedBasicBlock) {
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        Iterator<IExplodedBasicBlock> iterator = this.getPredNodes(iExplodedBasicBlock);
        while (iterator.hasNext()) {
            mutableSparseIntSet.add(this.getNumber(iterator.next()));
        }
        return mutableSparseIntSet;
    }

    @Override
    public IntSet getSuccNodeNumbers(IExplodedBasicBlock iExplodedBasicBlock) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (IExplodedBasicBlock iExplodedBasicBlock : this) {
            stringBuffer.append("BB").append(this.getNumber(iExplodedBasicBlock)).append("\n");
            Iterator<IExplodedBasicBlock> iterator = this.getSuccNodes(iExplodedBasicBlock);
            while (iterator.hasNext()) {
                stringBuffer.append("    -> BB").append(this.getNumber(iterator.next())).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public IR getIR() {
        return this.ir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExplodedBasicBlock
    implements IExplodedBasicBlock {
        private final int instructionIndex;
        private final ISSABasicBlock original;

        public ExplodedBasicBlock(int n, ISSABasicBlock iSSABasicBlock) {
            this.instructionIndex = n;
            this.original = iSSABasicBlock;
        }

        public ExplodedControlFlowGraph getExplodedCFG() {
            return ExplodedControlFlowGraph.this;
        }

        @Override
        public Iterator<TypeReference> getCaughtExceptionTypes() {
            if (this.original instanceof SSACFG.ExceptionHandlerBasicBlock) {
                SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)this.original;
                return exceptionHandlerBasicBlock.getCaughtExceptionTypes();
            }
            return EmptyIterator.instance();
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.instructionIndex;
        }

        @Override
        public int getLastInstructionIndex() {
            return this.instructionIndex;
        }

        @Override
        public IMethod getMethod() {
            return ExplodedControlFlowGraph.this.getMethod();
        }

        @Override
        public int getNumber() {
            if (this.isEntryBlock()) {
                return 0;
            }
            if (this.isExitBlock()) {
                return ExplodedControlFlowGraph.this.getNumberOfNodes() - 1;
            }
            return this.instructionIndex + 1;
        }

        @Override
        public boolean isCatchBlock() {
            if (this.original == null) {
                return false;
            }
            return this.original.isCatchBlock() && this.instructionIndex == this.original.getFirstInstructionIndex();
        }

        @Override
        public SSAGetCaughtExceptionInstruction getCatchInstruction() {
            if (!(this.original instanceof SSACFG.ExceptionHandlerBasicBlock)) {
                throw new IllegalArgumentException("block does not represent an exception handler");
            }
            SSACFG.ExceptionHandlerBasicBlock exceptionHandlerBasicBlock = (SSACFG.ExceptionHandlerBasicBlock)this.original;
            return exceptionHandlerBasicBlock.getCatchInstruction();
        }

        @Override
        public boolean isEntryBlock() {
            return this.instructionIndex == -1;
        }

        @Override
        public boolean isExitBlock() {
            return this.instructionIndex == -2;
        }

        @Override
        public int getGraphNodeId() {
            return this.getNumber();
        }

        @Override
        public void setGraphNodeId(int n) {
            Assertions.UNREACHABLE();
        }

        @Override
        public Iterator<SSAInstruction> iterator() {
            if (this.isEntryBlock() || this.isExitBlock() || this.getInstruction() == null) {
                return EmptyIterator.instance();
            }
            return NonNullSingletonIterator.make(this.getInstruction());
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.instructionIndex;
            n = 31 * n + (this.original == null ? 0 : this.original.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ExplodedBasicBlock explodedBasicBlock = (ExplodedBasicBlock)object;
            if (this.instructionIndex != explodedBasicBlock.instructionIndex) {
                return false;
            }
            return !(this.original == null ? explodedBasicBlock.original != null : !this.original.equals(explodedBasicBlock.original));
        }

        @Override
        public SSAInstruction getInstruction() {
            if (this.isEntryBlock() || this.isExitBlock()) {
                return null;
            }
            return ExplodedControlFlowGraph.this.ir.getInstructions()[this.instructionIndex];
        }

        @Override
        public SSAInstruction getLastInstruction() {
            if (this.getLastInstructionIndex() < 0) {
                return null;
            }
            return ExplodedControlFlowGraph.this.ir.getInstructions()[this.getLastInstructionIndex()];
        }

        @Override
        public Iterator<SSAPhiInstruction> iteratePhis() {
            if (this.isEntryBlock() || this.isExitBlock() || this.instructionIndex != this.original.getFirstInstructionIndex()) {
                return EmptyIterator.instance();
            }
            return this.original.iteratePhis();
        }

        @Override
        public Iterator<SSAPiInstruction> iteratePis() {
            if (this.isEntryBlock() || this.isExitBlock() || this.instructionIndex != this.original.getLastInstructionIndex()) {
                return EmptyIterator.instance();
            }
            return this.original.iteratePis();
        }

        public String toString() {
            if (this.isEntryBlock()) {
                return "ExplodedBlock[" + this.getNumber() + "](entry:" + this.getMethod() + ")";
            }
            if (this.isExitBlock()) {
                return "ExplodedBlock[" + this.getNumber() + "](exit:" + this.getMethod() + ")";
            }
            return "ExplodedBlock[" + this.getNumber() + "](original:" + this.original + ")";
        }
    }
}

