/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.util.strings.UTF8Convert;
import java.util.Map;

public final class Descriptor {
    private static final Map<Key, Descriptor> map = HashMapFactory.make();
    private final Key key;

    public static Descriptor findOrCreate(TypeName[] typeNameArray, TypeName typeName) {
        Key key;
        Descriptor descriptor;
        if (typeName == null) {
            throw new IllegalArgumentException("null returnType");
        }
        if (typeNameArray != null && typeNameArray.length == 0) {
            typeNameArray = null;
        }
        if ((descriptor = map.get(key = new Key(typeName, typeNameArray))) == null) {
            descriptor = new Descriptor(key);
            map.put(key, descriptor);
        }
        return descriptor;
    }

    public static Descriptor findOrCreate(Language language, ImmutableByteArray immutableByteArray) throws IllegalArgumentException {
        TypeName[] typeNameArray;
        TypeName typeName = StringStuff.parseForReturnTypeName(language, immutableByteArray);
        Key key = new Key(typeName, typeNameArray = StringStuff.parseForParameterNames(language, immutableByteArray));
        Descriptor descriptor = map.get(key);
        if (descriptor == null) {
            descriptor = new Descriptor(key);
            map.put(key, descriptor);
        }
        return descriptor;
    }

    public static Descriptor findOrCreate(ImmutableByteArray immutableByteArray) throws IllegalArgumentException {
        return Descriptor.findOrCreate(Language.JAVA, immutableByteArray);
    }

    public static Descriptor findOrCreateUTF8(String string) throws IllegalArgumentException {
        return Descriptor.findOrCreateUTF8(Language.JAVA, string);
    }

    public static Descriptor findOrCreateUTF8(Language language, String string) throws IllegalArgumentException {
        byte[] byArray = UTF8Convert.toUTF8(string);
        return Descriptor.findOrCreate(language, new ImmutableByteArray(byArray));
    }

    private Descriptor(Key key) {
        this.key = key;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key.toString();
    }

    public String toUnicodeString() {
        return this.key.toUnicodeString();
    }

    public TypeName getReturnType() {
        return this.key.returnType;
    }

    public TypeName[] getParameters() {
        return this.key.parameters;
    }

    public int getNumberOfParameters() {
        return this.key.parameters == null ? 0 : this.key.parameters.length;
    }

    private static class Key {
        private final TypeName returnType;
        private final TypeName[] parameters;
        private final int hashCode;

        Key(TypeName typeName, TypeName[] typeNameArray) {
            this.returnType = typeName;
            this.parameters = typeNameArray;
            if (typeNameArray != null) assert (typeNameArray.length > 0);
            this.hashCode = this.computeHashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public int computeHashCode() {
            int n = this.returnType.hashCode() * 5309;
            if (this.parameters != null) {
                int n2 = 0;
                while (n2 < this.parameters.length) {
                    n += this.parameters[n2].hashCode() * (0x14CB ^ n2);
                    ++n2;
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            assert (object instanceof Key);
            Key key = (Key)object;
            if (!this.returnType.equals(key.returnType)) {
                return false;
            }
            if (this.parameters == null) {
                return key.parameters == null;
            }
            if (key.parameters == null) {
                return false;
            }
            if (this.parameters.length != key.parameters.length) {
                return false;
            }
            int n = 0;
            while (n < this.parameters.length) {
                if (!this.parameters[n].equals(key.parameters[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            if (this.parameters != null) {
                int n = 0;
                while (n < this.parameters.length) {
                    TypeName typeName = this.parameters[n];
                    stringBuffer.append(typeName);
                    this.appendSemicolonIfNeeded(stringBuffer, typeName);
                    ++n;
                }
            }
            stringBuffer.append(")");
            stringBuffer.append(this.returnType);
            this.appendSemicolonIfNeeded(stringBuffer, this.returnType);
            return stringBuffer.toString();
        }

        public String toUnicodeString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            if (this.parameters != null) {
                int n = 0;
                while (n < this.parameters.length) {
                    TypeName typeName = this.parameters[n];
                    stringBuffer.append(typeName.toUnicodeString());
                    this.appendSemicolonIfNeeded(stringBuffer, typeName);
                    ++n;
                }
            }
            stringBuffer.append(")");
            stringBuffer.append(this.returnType);
            this.appendSemicolonIfNeeded(stringBuffer, this.returnType);
            return stringBuffer.toString();
        }

        private void appendSemicolonIfNeeded(StringBuffer stringBuffer, TypeName typeName) {
            if (typeName.isArrayType()) {
                TypeName typeName2 = typeName.getInnermostElementType();
                String string = typeName2.toUnicodeString();
                if (string.startsWith("L") || string.startsWith("P")) {
                    stringBuffer.append(";");
                }
            } else {
                String string = typeName.toUnicodeString();
                if (string.startsWith("L") || string.startsWith("P")) {
                    stringBuffer.append(";");
                }
            }
        }
    }
}

