/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.strings.Atom;
import java.util.HashMap;

public final class MethodReference
extends MemberReference {
    private static final HashMap<Key, MethodReference> dictionary = HashMapFactory.make();
    public static final Atom newInstanceAtom = Atom.findOrCreateUnicodeAtom("newInstance");
    private static final Descriptor newInstanceDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "()Ljava/lang/Object;");
    public static final MethodReference JavaLangClassNewInstance = MethodReference.findOrCreate(TypeReference.JavaLangClass, newInstanceAtom, newInstanceDesc);
    private static final Atom ctorNewInstanceAtom = Atom.findOrCreateUnicodeAtom("newInstance");
    private static final Descriptor ctorNewInstanceDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "([Ljava/lang/Object;)Ljava/lang/Object;");
    public static final MemberReference JavaLangReflectCtorNewInstance = MethodReference.findOrCreate(TypeReference.JavaLangReflectConstructor, ctorNewInstanceAtom, ctorNewInstanceDesc);
    public static final Atom forNameAtom = Atom.findOrCreateUnicodeAtom("forName");
    private static final Descriptor forNameDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "(Ljava/lang/String;)Ljava/lang/Class;");
    public static final MethodReference JavaLangClassForName = MethodReference.findOrCreate(TypeReference.JavaLangClass, forNameAtom, forNameDesc);
    public static final Atom initAtom = Atom.findOrCreateUnicodeAtom("<init>");
    public static final Descriptor defaultInitDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "()V");
    public static final Selector initSelector = new Selector(initAtom, defaultInitDesc);
    public static final Atom clinitName = Atom.findOrCreateUnicodeAtom("<clinit>");
    public static final Selector clinitSelector = new Selector(clinitName, defaultInitDesc);
    public static final Atom runAtom = Atom.findOrCreateUnicodeAtom("run");
    public static final Descriptor runDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "()Ljava/lang/Object;");
    public static final Selector runSelector = new Selector(runAtom, runDesc);
    public static final Atom equalsAtom = Atom.findOrCreateUnicodeAtom("equals");
    public static final Descriptor equalsDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "(Ljava/lang/Object;)Z");
    public static final Selector equalsSelector = new Selector(equalsAtom, equalsDesc);
    private final TypeReference[] parameterTypes;
    private final TypeReference returnType;
    private final Selector selector;

    public static synchronized MethodReference findOrCreate(TypeReference typeReference, Atom atom, Descriptor descriptor) {
        if (typeReference == null) {
            throw new IllegalArgumentException("null tref");
        }
        Key key = new Key(typeReference, atom, descriptor);
        MethodReference methodReference = dictionary.get(key);
        if (methodReference != null) {
            return methodReference;
        }
        methodReference = new MethodReference(key);
        dictionary.put(key, methodReference);
        return methodReference;
    }

    public static synchronized MethodReference findOrCreate(TypeReference typeReference, Selector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector is null");
        }
        return MethodReference.findOrCreate(typeReference, selector.getName(), selector.getDescriptor());
    }

    public static MethodReference findOrCreate(TypeReference typeReference, String string, String string2) throws IllegalArgumentException {
        return MethodReference.findOrCreate(Language.JAVA, typeReference, string, string2);
    }

    public static MethodReference findOrCreate(Language language, TypeReference typeReference, String string, String string2) throws IllegalArgumentException {
        Descriptor descriptor = Descriptor.findOrCreateUTF8(language, string2);
        return MethodReference.findOrCreate(typeReference, Atom.findOrCreateUnicodeAtom(string), descriptor);
    }

    public static MethodReference findOrCreate(ClassLoaderReference classLoaderReference, String string, String string2, String string3) throws IllegalArgumentException {
        return MethodReference.findOrCreate(Language.JAVA, classLoaderReference, string, string2, string3);
    }

    public static MethodReference findOrCreate(Language language, ClassLoaderReference classLoaderReference, String string, String string2, String string3) throws IllegalArgumentException {
        TypeReference typeReference = ShrikeUtil.makeTypeReference(classLoaderReference, string);
        Atom atom = Atom.findOrCreateUnicodeAtom(string2);
        Descriptor descriptor = Descriptor.findOrCreateUTF8(language, string3);
        return MethodReference.findOrCreate(typeReference, atom, descriptor);
    }

    public final Descriptor getDescriptor() {
        return this.selector.getDescriptor();
    }

    public final String toString() {
        return "< " + this.getDeclaringClass().getClassLoader().getName() + ", " + this.getDeclaringClass().getName() + ", " + this.selector + " >";
    }

    MethodReference(Key key) {
        super(key.type, key.name, key.hashCode());
        this.selector = new Selector(key.name, key.descriptor);
        TypeName[] typeNameArray = key.descriptor.getParameters();
        this.parameterTypes = typeNameArray != null ? new TypeReference[typeNameArray.length] : null;
        ClassLoaderReference classLoaderReference = this.getDeclaringClass().getClassLoader();
        if (typeNameArray != null) {
            int n = 0;
            while (n < typeNameArray.length) {
                this.parameterTypes[n] = TypeReference.findOrCreate(classLoaderReference, typeNameArray[n]);
                ++n;
            }
        }
        TypeName typeName = key.descriptor.getReturnType();
        this.returnType = TypeReference.findOrCreate(this.getDeclaringClass().getClassLoader(), typeName);
    }

    public final TypeReference getReturnType() {
        return this.returnType;
    }

    public final TypeReference getParameterType(int n) throws IllegalArgumentException {
        if (this.parameterTypes == null || n >= this.parameterTypes.length) {
            throw new IllegalArgumentException("illegal parameter number " + n + " for " + this);
        }
        return this.parameterTypes[n];
    }

    public boolean isInit() {
        return this.getName().equals(initAtom);
    }

    public String getSignature() {
        String string = String.valueOf(this.getDeclaringClass().getName().toString().substring(1).replace('/', '.')) + "." + this.getName() + this.getDescriptor();
        return string;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    protected static class Key {
        private final TypeReference type;
        private final Atom name;
        private final Descriptor descriptor;

        Key(TypeReference typeReference, Atom atom, Descriptor descriptor) {
            this.type = typeReference;
            this.name = atom;
            this.descriptor = descriptor;
        }

        public final int hashCode() {
            return 7001 * this.type.hashCode() + 7013 * this.name.hashCode() + this.descriptor.hashCode();
        }

        public final boolean equals(Object object) {
            assert (object != null && this.getClass().equals(object.getClass()));
            Key key = (Key)object;
            return this.type.equals(key.type) && this.name.equals(key.name) && this.descriptor.equals(key.descriptor);
        }
    }
}

